/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.WrappedPipe;

abstract class ServerPipe
extends WrappedPipe {
    private static final int READING = 0;
    private static final int WRITING = 1;
    private static final int CLOSED = 2;
    private static final AtomicIntegerFieldUpdater<ServerPipe> cStateUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerPipe.class, "mState");
    private final InvocationChannel mChannel;
    private volatile int mState;

    ServerPipe(InvocationChannel channel) {
        this.mChannel = channel;
    }

    @Override
    public void close() throws IOException {
        if (cStateUpdater.getAndSet(this, 2) == 2) {
            return;
        }
        InvocationChannel channel = this.mChannel;
        if (!channel.cancelTimeout()) {
            return;
        }
        try {
            if (!channel.outputSuspend()) {
                channel.close();
                return;
            }
            channel.reset();
            this.tryInputResume(channel);
        }
        catch (ClosedException e) {
            return;
        }
    }

    @Override
    Pipe pipeForRead() throws IOException {
        if (this.mState == 0) {
            return this.mChannel;
        }
        this.anyPipe();
        throw new IOException("Pipe is not in a readable state");
    }

    @Override
    Pipe pipeForWrite() throws IOException {
        if (this.mState == 1 || cStateUpdater.compareAndSet(this, 0, 1) || this.mState == 1) {
            return this.mChannel;
        }
        throw new IOException("Pipe is closed");
    }

    @Override
    Pipe anyPipe() throws IOException {
        if (this.mState != 2) {
            return this.mChannel;
        }
        throw new IOException("Pipe is closed");
    }

    abstract void tryInputResume(InvocationChannel var1);
}

