/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.core.RemoteCompletion;

class SessionExchanger {
    private Object mObject;
    private RemoteCompletion<Object> mCallback;

    SessionExchanger() {
    }

    public synchronized boolean enqueue(Object obj, long timeout, TimeUnit unit) throws RemoteException, InterruptedException {
        if (obj == null) {
            obj = new Null();
        }
        if (timeout < 0L) {
            while (this.mObject != null) {
                this.wait();
            }
        } else {
            long timeoutMillis = unit.toMillis(timeout);
            if (timeoutMillis > 0L) {
                long endNanos = System.nanoTime() + unit.toNanos(timeout);
                while (this.mObject != null) {
                    long timeoutNanos;
                    this.wait(timeoutMillis);
                    if (this.mObject == null || (timeoutNanos = endNanos - System.nanoTime()) < 1000000L) break;
                    timeoutMillis = timeoutNanos / 1000000L;
                }
            }
            if (this.mObject != null) {
                return false;
            }
        }
        if (this.mCallback == null) {
            this.mObject = obj;
        } else {
            this.mCallback.complete(obj);
            this.mCallback = null;
        }
        return true;
    }

    public synchronized Object dequeue(RemoteCompletion<Object> callback) {
        if (callback != null && this.mCallback != null) {
            throw new IllegalStateException();
        }
        if (this.mObject != null) {
            Object obj = this.mObject;
            this.mObject = null;
            this.notify();
            return obj;
        }
        this.mCallback = callback;
        return null;
    }

    public static class Null
    implements Serializable {
    }
}

