/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.CallMode;
import org.cojen.dirmi.Completion;
import org.cojen.dirmi.Link;
import org.cojen.dirmi.MalformedRemoteObjectException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.SessionAware;
import org.cojen.dirmi.core.BatchedInvocationException;
import org.cojen.dirmi.core.CodeBuilderUtil;
import org.cojen.dirmi.core.EmptySkeletonFactory;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.LocalSession;
import org.cojen.dirmi.core.OrderedInvoker;
import org.cojen.dirmi.core.RemoteCompletion;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.SkeletonFactory;
import org.cojen.dirmi.core.SkeletonSupport;
import org.cojen.dirmi.core.VersionedIdentifier;
import org.cojen.dirmi.info.RemoteInfo;
import org.cojen.dirmi.info.RemoteIntrospector;
import org.cojen.dirmi.info.RemoteMethod;
import org.cojen.dirmi.info.RemoteParameter;
import org.cojen.dirmi.util.Cache;
import org.cojen.util.KeyFactory;

public class SkeletonFactoryGenerator<R extends Remote> {
    private static final String SUPPORT_FIELD_NAME = "support";
    private static final String REMOTE_FIELD_NAME = "remote";
    private static final String ID_FIELD_NAME = "id";
    private static final String ORDERED_INVOKER_FIELD_NAME = "orderedInvoker";
    private static final String METHOD_FIELD_PREFIX = "method$";
    private static final Cache<Object, SkeletonFactory<?>> cCache = Cache.newSoftValueCache(17);
    private final Class<R> mType;
    private final RemoteInfo mInfo;
    private final RemoteInfo mLocalInfo;
    private final String mMalformedInfoMessage;
    private final AtomicReference<Object> mFactoryRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Remote> SkeletonFactory<R> getSkeletonFactory(Class<R> type) throws IllegalArgumentException {
        RemoteInfo localInfo = RemoteIntrospector.examine(type);
        Object key = KeyFactory.createKey((Object[])new Object[]{type, localInfo.getInfoId()});
        Cache<Object, SkeletonFactory<?>> cache = cCache;
        synchronized (cache) {
            SkeletonFactory<Object> factory = cCache.get(key);
            if (factory == null) {
                factory = super.generateFactory();
                cCache.put(key, factory);
            }
            return factory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Remote> SkeletonFactory<R> getSkeletonFactory(Class<R> type, RemoteInfo remoteInfo) {
        Object key = KeyFactory.createKey((Object[])new Object[]{type, remoteInfo.getInfoId()});
        Cache<Object, SkeletonFactory<?>> cache = cCache;
        synchronized (cache) {
            SkeletonFactory<Object> factory = cCache.get(key);
            if (factory == null) {
                factory = super.generateFactory();
                cCache.put(key, factory);
            }
            return factory;
        }
    }

    private SkeletonFactoryGenerator(RemoteInfo localInfo, Class<R> type) {
        this.mType = type;
        this.mInfo = this.mLocalInfo = localInfo;
        this.mMalformedInfoMessage = null;
    }

    private SkeletonFactoryGenerator(Class<R> type, RemoteInfo remoteInfo) {
        String malformed;
        RemoteInfo localInfo;
        this.mType = type;
        this.mInfo = remoteInfo;
        try {
            localInfo = RemoteIntrospector.examine(type);
            malformed = null;
        }
        catch (IllegalArgumentException e) {
            localInfo = null;
            malformed = e.getMessage();
        }
        this.mLocalInfo = localInfo;
        this.mMalformedInfoMessage = malformed;
    }

    private SkeletonFactory<R> generateFactory() {
        if (this.mInfo.getRemoteMethods().isEmpty()) {
            return EmptySkeletonFactory.THE;
        }
        return (SkeletonFactory)AccessController.doPrivileged(new PrivilegedAction<SkeletonFactory<R>>(){

            @Override
            public SkeletonFactory<R> run() {
                Class skeletonClass = SkeletonFactoryGenerator.this.generateSkeleton();
                try {
                    Factory factory = new Factory(skeletonClass.getConstructor(VersionedIdentifier.class, SkeletonSupport.class, SkeletonFactoryGenerator.this.mType));
                    SkeletonFactoryGenerator.this.mFactoryRef.set(factory);
                    return factory;
                }
                catch (NoSuchMethodException e) {
                    NoSuchMethodError nsme = new NoSuchMethodError();
                    nsme.initCause(e);
                    throw nsme;
                }
            }
        });
    }

    private Class<? extends Skeleton> generateSkeleton() {
        RuntimeClassFile cf = CodeBuilderUtil.createRuntimeClassFile(this.mType.getName() + "$Skeleton", this.mType.getClassLoader());
        cf.addInterface(Skeleton.class);
        cf.setSourceFile(SkeletonFactoryGenerator.class.getName());
        cf.markSynthetic();
        cf.setTarget("1.5");
        TypeDesc remoteType = TypeDesc.forClass(this.mType);
        cf.addField(Modifiers.PRIVATE.toFinal(true), SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
        cf.addField(Modifiers.PRIVATE.toFinal(true), REMOTE_FIELD_NAME, remoteType);
        CodeBuilder staticInitBuilder = CodeBuilderUtil.addStaticFactoryRefUnfinished((ClassFile)cf, this.mFactoryRef);
        MethodInfo mi = cf.addMethod(Modifiers.PUBLIC, "getRemoteServer", TypeDesc.forClass(Remote.class), null);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadThis();
        b.loadField(REMOTE_FIELD_NAME, remoteType);
        b.returnValue(TypeDesc.OBJECT);
        MethodInfo mi2 = cf.addMethod(Modifiers.PUBLIC, "invoke", TypeDesc.INT, new TypeDesc[]{CodeBuilderUtil.LINK_TYPE, TypeDesc.INT, CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.BATCH_INV_EX_TYPE});
        CodeBuilder invokeBuilder = new CodeBuilder(mi2);
        Set<? extends RemoteMethod> methods = this.mInfo.getRemoteMethods();
        LinkedHashMap<Integer, RemoteMethod> caseMap = new LinkedHashMap<Integer, RemoteMethod>(methods.size());
        boolean hasOrderedMethods = false;
        boolean hasDisposer = false;
        for (RemoteMethod remoteMethod : methods) {
            caseMap.put(remoteMethod.getMethodId(), remoteMethod);
            hasOrderedMethods |= remoteMethod.isOrdered();
            hasDisposer |= remoteMethod.isDisposer();
        }
        int caseCount = caseMap.size();
        int[] nArray = new int[caseCount];
        Label[] switchLabels = new Label[caseCount];
        Label defaultLabel = invokeBuilder.createLabel();
        int caseIndex = 0;
        for (Integer key : caseMap.keySet()) {
            nArray[caseIndex] = key;
            switchLabels[caseIndex] = invokeBuilder.createLabel();
            ++caseIndex;
        }
        invokeBuilder.loadLocal(invokeBuilder.getParameter(1));
        invokeBuilder.switchBranch(nArray, (Location[])switchLabels, (Location)defaultLabel);
        LinkedHashMap<String, Integer> methodNames = new LinkedHashMap<String, Integer>();
        ArrayList<Label> disposerTryLabels = null;
        Label disposerGotoLabel = null;
        int caseIndex2 = 0;
        for (RemoteMethod method : caseMap.values()) {
            boolean batchedRemote;
            TypeDesc[] paramTypes;
            switchLabels[caseIndex2++].setLocation();
            String name = SkeletonFactoryGenerator.generateMethodName(methodNames, method);
            TypeDesc[] params = new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.BATCH_INV_EX_TYPE};
            MethodInfo innerMethod = cf.addMethod(Modifiers.PRIVATE, name, TypeDesc.INT, params);
            CodeBuilder b2 = new CodeBuilder(innerMethod);
            invokeBuilder.loadThis();
            invokeBuilder.loadLocal(invokeBuilder.getParameter(2));
            invokeBuilder.loadLocal(invokeBuilder.getParameter(3));
            if (!method.isDisposer()) {
                invokeBuilder.invokePrivate(name, TypeDesc.INT, params);
                invokeBuilder.returnValue(TypeDesc.INT);
            } else {
                if (disposerTryLabels == null) {
                    disposerTryLabels = new ArrayList<Label>();
                }
                disposerTryLabels.add(invokeBuilder.createLabel().setLocation());
                invokeBuilder.invokePrivate(name, TypeDesc.INT, params);
                disposerTryLabels.add(invokeBuilder.createLabel().setLocation());
                if (disposerGotoLabel == null) {
                    disposerGotoLabel = invokeBuilder.createLabel();
                }
                if (method.isOrdered()) {
                    invokeBuilder.dup();
                    invokeBuilder.ifZeroComparisonBranch((Location)disposerGotoLabel, ">=");
                    invokeBuilder.loadConstant(-1);
                    invokeBuilder.math((byte)-126);
                    invokeBuilder.returnValue(TypeDesc.INT);
                } else {
                    invokeBuilder.branch((Location)disposerGotoLabel);
                }
            }
            LocalVariable channelVar = b2.getParameter(0);
            LocalVariable batchedExceptionVar = b2.getParameter(1);
            LocalVariable sequenceVar = null;
            if (method.isOrdered()) {
                if (method.isAsynchronous() && !method.isBatched() && this.methodExists(method)) {
                    TypeDesc methodType = TypeDesc.forClass(Method.class);
                    String fieldName = METHOD_FIELD_PREFIX + caseIndex2;
                    cf.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), fieldName, methodType);
                    staticInitBuilder.loadConstant(remoteType);
                    staticInitBuilder.loadConstant(method.getName());
                    paramTypes = CodeBuilderUtil.getTypeDescs(method.getParameterTypes());
                    if (paramTypes.length == 0) {
                        staticInitBuilder.loadNull();
                    } else {
                        staticInitBuilder.loadConstant(paramTypes.length);
                        staticInitBuilder.newObject(CodeBuilderUtil.CLASS_TYPE.toArrayType());
                        for (int i = 0; i < paramTypes.length; ++i) {
                            staticInitBuilder.dup();
                            staticInitBuilder.loadConstant(i);
                            staticInitBuilder.loadConstant(paramTypes[i]);
                            staticInitBuilder.storeToArray(TypeDesc.OBJECT);
                        }
                    }
                    staticInitBuilder.invokeVirtual(CodeBuilderUtil.CLASS_TYPE, "getMethod", methodType, new TypeDesc[]{TypeDesc.STRING, CodeBuilderUtil.CLASS_TYPE.toArrayType()});
                    staticInitBuilder.storeStaticField(fieldName, methodType);
                }
                b2.loadLocal(channelVar);
                b2.invokeInterface(channelVar.getType(), "readInt", TypeDesc.INT, null);
                sequenceVar = b2.createLocalVariable(null, TypeDesc.INT);
                b2.storeLocal(sequenceVar);
            }
            LocalVariable invInVar = null;
            TypeDesc returnDesc = CodeBuilderUtil.getTypeDesc(method.getReturnType());
            paramTypes = method.getParameterTypes();
            LocalVariable completionVar = null;
            if (method.isAsynchronous() && returnDesc != null && (Future.class == returnDesc.toClass() || Completion.class == returnDesc.toClass())) {
                completionVar = b2.createLocalVariable(null, TypeDesc.forClass(RemoteCompletion.class));
                invInVar = SkeletonFactoryGenerator.invInVar(b2, channelVar, invInVar);
                b2.loadLocal(invInVar);
                b2.invokeVirtual(invInVar.getType(), "readUnshared", TypeDesc.OBJECT, null);
                b2.checkCast(completionVar.getType());
                b2.storeLocal(completionVar);
            }
            b2.loadThis();
            b2.loadField(REMOTE_FIELD_NAME, remoteType);
            boolean noPipeParam = true;
            if (!paramTypes.isEmpty()) {
                boolean lookForPipe = method.isAsynchronous() && returnDesc != null && Pipe.class == returnDesc.toClass();
                for (int i = 0; i < paramTypes.size(); ++i) {
                    RemoteParameter<?> paramType = paramTypes.get(i);
                    if (lookForPipe && Pipe.class == paramType.getType()) {
                        lookForPipe = false;
                        noPipeParam = false;
                        if (method.getAsynchronousCallMode() == CallMode.REQUEST_REPLY) {
                            b2.loadThis();
                            b2.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
                            b2.loadLocal(channelVar);
                            b2.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "requestReply", returnDesc, new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE});
                            continue;
                        }
                        b2.loadLocal(channelVar);
                        continue;
                    }
                    invInVar = SkeletonFactoryGenerator.invInVar(b2, channelVar, invInVar);
                    CodeBuilderUtil.readParam(b2, paramType, invInVar);
                }
            }
            LocalVariable remoteTypeIdVar = null;
            LocalVariable remoteIdVar = null;
            boolean bl = batchedRemote = method.isBatched() && returnDesc != null && Remote.class.isAssignableFrom(returnDesc.toClass());
            if (batchedRemote) {
                invInVar = SkeletonFactoryGenerator.invInVar(b2, channelVar, invInVar);
                b2.loadLocal(invInVar);
                b2.invokeStatic(CodeBuilderUtil.IDENTIFIER_TYPE, "read", CodeBuilderUtil.IDENTIFIER_TYPE, new TypeDesc[]{TypeDesc.forClass(DataInput.class)});
                remoteTypeIdVar = b2.createLocalVariable(null, CodeBuilderUtil.IDENTIFIER_TYPE);
                b2.storeLocal(remoteTypeIdVar);
                b2.loadLocal(invInVar);
                b2.invokeStatic(CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE, "readAndUpdateRemoteVersion", CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE, new TypeDesc[]{TypeDesc.forClass(DataInput.class)});
                remoteIdVar = b2.createLocalVariable(null, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
                b2.storeLocal(remoteIdVar);
            }
            if (method.getAsynchronousCallMode() == CallMode.ACKNOWLEDGED) {
                b2.loadLocal(channelVar);
                b2.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getOutputStream", CodeBuilderUtil.INV_OUT_TYPE, null);
                b2.dup();
                b2.loadNull();
                b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "writeThrowable", null, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
                b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "flush", null, null);
            }
            if (method.isAsynchronous() && !method.isBatched() && !method.isOrdered() && noPipeParam) {
                this.genFinishedAsync(b2, channelVar);
            }
            Label tryStart = b2.createLabel().setLocation();
            b2.loadLocal(batchedExceptionVar);
            Label noPendingException = b2.createLabel();
            b2.ifNullBranch((Location)noPendingException, true);
            b2.loadLocal(batchedExceptionVar);
            if (method.isBatched()) {
                b2.throwObject();
            } else {
                Class[] declaredExceptions = this.declaredExceptionTypes(method);
                if (declaredExceptions == null || declaredExceptions.length == 0) {
                    b2.loadNull();
                    b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "isCauseDeclared", TypeDesc.BOOLEAN, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE.toArrayType()});
                } else if (declaredExceptions.length == 1) {
                    b2.loadConstant(TypeDesc.forClass((Class)declaredExceptions[0]));
                    b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "isCauseDeclared", TypeDesc.BOOLEAN, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE});
                } else if (declaredExceptions.length == 2) {
                    b2.loadConstant(TypeDesc.forClass((Class)declaredExceptions[0]));
                    b2.loadConstant(TypeDesc.forClass((Class)declaredExceptions[1]));
                    b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "isCauseDeclared", TypeDesc.BOOLEAN, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, CodeBuilderUtil.CLASS_TYPE});
                } else {
                    b2.loadConstant(declaredExceptions.length);
                    b2.newObject(CodeBuilderUtil.CLASS_TYPE.toArrayType());
                    for (int i = 0; i < declaredExceptions.length; ++i) {
                        Class exception = declaredExceptions[i];
                        b2.dup();
                        b2.loadConstant(i);
                        b2.loadConstant(TypeDesc.forClass((Class)exception));
                        b2.storeToArray(CodeBuilderUtil.CLASS_TYPE);
                    }
                    b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "isCauseDeclared", TypeDesc.BOOLEAN, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE.toArrayType()});
                }
                Label isDeclared = b2.createLabel();
                b2.ifZeroComparisonBranch((Location)isDeclared, "!=");
                TypeDesc undecExType = TypeDesc.forClass(UndeclaredThrowableException.class);
                b2.newObject(undecExType);
                b2.dup();
                b2.loadLocal(batchedExceptionVar);
                b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "getCause", CodeBuilderUtil.THROWABLE_TYPE, null);
                b2.dup();
                b2.invokeVirtual(CodeBuilderUtil.THROWABLE_TYPE, "toString", TypeDesc.STRING, null);
                b2.invokeConstructor(undecExType, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE, TypeDesc.STRING});
                b2.throwObject();
                isDeclared.setLocation();
                b2.loadLocal(batchedExceptionVar);
                b2.invokeVirtual(CodeBuilderUtil.BATCH_INV_EX_TYPE, "getCause", CodeBuilderUtil.THROWABLE_TYPE, null);
                b2.throwObject();
            }
            noPendingException.setLocation();
            if (method.isOrdered() && this.methodExists(method)) {
                Label isNext = b2.createLabel();
                if (!method.isAsynchronous() || method.isBatched()) {
                    this.genWaitForNext(b2, sequenceVar);
                    b2.ifZeroComparisonBranch((Location)isNext, "!=");
                    b2.loadConstant(0);
                    b2.returnValue(TypeDesc.INT);
                    isNext.setLocation();
                } else {
                    int retValue;
                    TypeDesc[] params2;
                    int i;
                    LocalVariable[] paramVars;
                    this.genIsNext(b2, sequenceVar);
                    b2.ifZeroComparisonBranch((Location)isNext, "!=");
                    TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
                    TypeDesc methodType = TypeDesc.forClass(Method.class);
                    if (paramTypes.isEmpty()) {
                        paramVars = null;
                    } else {
                        paramVars = new LocalVariable[paramTypes.size()];
                        i = paramTypes.size();
                        while (--i >= 0) {
                            LocalVariable paramVar;
                            Class paramType = ((RemoteParameter)paramTypes.get(i)).getType();
                            TypeDesc paramDesc = TypeDesc.forClass(paramType);
                            TypeDesc objParamDesc = paramDesc.toObjectType();
                            paramVars[i] = paramVar = b2.createLocalVariable(null, objParamDesc);
                            b2.convert(paramDesc, objParamDesc);
                            b2.storeLocal(paramVar);
                        }
                    }
                    b2.pop();
                    b2.loadThis();
                    b2.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
                    b2.loadLocal(sequenceVar);
                    b2.loadStaticField(METHOD_FIELD_PREFIX + caseIndex2, methodType);
                    b2.loadThis();
                    b2.loadField(REMOTE_FIELD_NAME, remoteType);
                    if (paramVars == null) {
                        b2.loadNull();
                    } else {
                        b2.loadConstant(paramVars.length);
                        b2.newObject(TypeDesc.OBJECT.toArrayType());
                        for (i = 0; i < paramVars.length; ++i) {
                            b2.dup();
                            b2.loadConstant(i);
                            b2.loadLocal(paramVars[i]);
                            b2.storeToArray(TypeDesc.OBJECT);
                        }
                    }
                    if (method.isDisposer()) {
                        b2.loadThis();
                        b2.loadField(ID_FIELD_NAME, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
                    } else {
                        b2.loadNull();
                    }
                    if (completionVar == null) {
                        TypeDesc[] params22 = new TypeDesc[]{TypeDesc.INT, methodType, TypeDesc.OBJECT, TypeDesc.OBJECT.toArrayType(), CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE};
                    } else {
                        b2.loadLocal(completionVar);
                        params2 = new TypeDesc[]{TypeDesc.INT, methodType, TypeDesc.OBJECT, TypeDesc.OBJECT.toArrayType(), CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE, TypeDesc.forClass(RemoteCompletion.class)};
                    }
                    b2.invokeVirtual(orderedInvokerType, "addPendingMethod", null, params2);
                    int n = retValue = noPipeParam ? 1 : 0;
                    if (method.isDisposer()) {
                        retValue ^= 0xFFFFFFFF;
                    }
                    b2.loadConstant(retValue);
                    b2.returnValue(TypeDesc.INT);
                    isNext.setLocation();
                    if (noPipeParam) {
                        this.genFinishedAsync(b2, channelVar);
                    }
                }
            }
            this.invokeMethod(b2, method);
            Label tryEnd = b2.createLabel().setLocation();
            if (method.isOrdered()) {
                TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
                b2.loadThis();
                b2.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
                b2.loadLocal(sequenceVar);
                b2.invokeVirtual(orderedInvokerType, "finished", null, new TypeDesc[]{TypeDesc.INT});
            }
            if (batchedRemote) {
                Label haveRemote = b2.createLabel();
                b2.branch((Location)haveRemote);
                TypeDesc rootRemoteType = TypeDesc.forClass(Remote.class);
                this.genExceptionHandler(b2, tryStart, tryEnd, sequenceVar);
                LocalVariable exVar = b2.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
                b2.storeLocal(exVar);
                b2.loadThis();
                b2.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
                b2.loadConstant(returnDesc);
                b2.loadLocal(exVar);
                b2.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "failedBatchedRemote", rootRemoteType, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, CodeBuilderUtil.THROWABLE_TYPE});
                Label linkRemote = b2.createLabel();
                b2.branch((Location)linkRemote);
                haveRemote.setLocation();
                b2.loadNull();
                b2.storeLocal(exVar);
                linkRemote.setLocation();
                LocalVariable remoteVar = b2.createLocalVariable(null, returnDesc);
                b2.storeLocal(remoteVar);
                b2.loadThis();
                b2.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
                b2.loadThis();
                b2.loadConstant(method.getName());
                b2.loadLocal(remoteTypeIdVar);
                b2.loadLocal(remoteIdVar);
                b2.loadConstant(returnDesc);
                b2.loadLocal(remoteVar);
                b2.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "linkBatchedRemote", null, new TypeDesc[]{TypeDesc.forClass(Skeleton.class), TypeDesc.STRING, remoteTypeIdVar.getType(), remoteIdVar.getType(), CodeBuilderUtil.CLASS_TYPE, rootRemoteType});
                b2.loadLocal(exVar);
                Label hasException = b2.createLabel();
                b2.ifNullBranch((Location)hasException, false);
                b2.loadConstant(2);
                b2.returnValue(TypeDesc.INT);
                hasException.setLocation();
                b2.loadLocal(exVar);
                b2.invokeStatic(CodeBuilderUtil.BATCH_INV_EX_TYPE, "make", CodeBuilderUtil.BATCH_INV_EX_TYPE, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
                b2.throwObject();
                continue;
            }
            if (method.isBatched()) {
                if (completionVar == null) {
                    this.genDiscardResponse(b2, returnDesc);
                } else {
                    this.genCompletionResponse(b2, returnDesc, completionVar, tryStart, tryEnd, sequenceVar);
                }
                b2.loadConstant(2);
                b2.returnValue(TypeDesc.INT);
                if (completionVar != null) continue;
                this.genExceptionHandler(b2, tryStart, tryEnd, sequenceVar);
                b2.invokeStatic(CodeBuilderUtil.BATCH_INV_EX_TYPE, "make", CodeBuilderUtil.BATCH_INV_EX_TYPE, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
                b2.throwObject();
                continue;
            }
            if (method.isAsynchronous()) {
                if (completionVar == null) {
                    this.genDiscardResponse(b2, returnDesc);
                } else {
                    this.genCompletionResponse(b2, returnDesc, completionVar, tryStart, tryEnd, sequenceVar);
                }
                b2.loadConstant(0);
                b2.returnValue(TypeDesc.INT);
                if (completionVar != null) continue;
                this.genExceptionHandler(b2, tryStart, tryEnd, sequenceVar);
                LocalVariable exVar = b2.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
                b2.storeLocal(exVar);
                b2.loadThis();
                b2.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
                b2.loadLocal(exVar);
                b2.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "uncaughtException", null, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
                b2.loadConstant(0);
                b2.returnValue(TypeDesc.INT);
                continue;
            }
            LocalVariable retVar = null;
            if (returnDesc != null) {
                retVar = b2.createLocalVariable(null, returnDesc);
                b2.storeLocal(retVar);
            }
            b2.loadLocal(channelVar);
            b2.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getOutputStream", CodeBuilderUtil.INV_OUT_TYPE, null);
            LocalVariable invOutVar = b2.createLocalVariable(null, CodeBuilderUtil.INV_OUT_TYPE);
            b2.storeLocal(invOutVar);
            b2.loadLocal(invOutVar);
            b2.loadNull();
            b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "writeThrowable", null, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
            boolean doReset = retVar == null ? false : CodeBuilderUtil.writeParam(b2, method.getReturnType(), invOutVar, retVar);
            this.genFinished(b2, channelVar, doReset);
            b2.returnValue(TypeDesc.INT);
            this.genExceptionHandler(b2, tryStart, tryEnd, sequenceVar);
            LocalVariable throwableVar = b2.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
            b2.storeLocal(throwableVar);
            b2.loadThis();
            b2.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
            b2.loadLocal(channelVar);
            b2.loadLocal(throwableVar);
            b2.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "finished", TypeDesc.INT, new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.THROWABLE_TYPE});
            b2.returnValue(TypeDesc.INT);
        }
        defaultLabel.setLocation();
        invokeBuilder.newObject(CodeBuilderUtil.NO_SUCH_METHOD_EX_TYPE);
        invokeBuilder.dup();
        invokeBuilder.loadLocal(invokeBuilder.getParameter(1));
        invokeBuilder.invokeStatic(TypeDesc.STRING, "valueOf", TypeDesc.STRING, new TypeDesc[]{TypeDesc.INT});
        invokeBuilder.invokeConstructor(CodeBuilderUtil.NO_SUCH_METHOD_EX_TYPE, new TypeDesc[]{TypeDesc.STRING});
        invokeBuilder.throwObject();
        if (disposerGotoLabel != null) {
            disposerGotoLabel.setLocation();
            invokeBuilder.loadThis();
            invokeBuilder.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
            invokeBuilder.loadThis();
            invokeBuilder.loadField(ID_FIELD_NAME, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
            invokeBuilder.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "dispose", null, new TypeDesc[]{CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE});
            invokeBuilder.returnValue(TypeDesc.INT);
        }
        if (disposerTryLabels != null) {
            for (int i = 0; i < disposerTryLabels.size(); i += 2) {
                invokeBuilder.exceptionHandler((Location)disposerTryLabels.get(i), (Location)disposerTryLabels.get(i + 1), null);
            }
            invokeBuilder.loadThis();
            invokeBuilder.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
            invokeBuilder.loadThis();
            invokeBuilder.loadField(ID_FIELD_NAME, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
            invokeBuilder.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "dispose", null, new TypeDesc[]{CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE});
            invokeBuilder.throwObject();
        }
        CodeBuilder b3 = new CodeBuilder(cf.addMethod(Modifiers.PUBLIC, "unreferenced", null, null));
        if (hasOrderedMethods) {
            TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
            b3.loadThis();
            b3.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
            b3.invokeVirtual(orderedInvokerType, "close", null, null);
        }
        b3.loadThis();
        b3.loadField(REMOTE_FIELD_NAME, remoteType);
        b3.instanceOf(CodeBuilderUtil.UNREFERENCED_TYPE);
        Label notUnref = b3.createLabel();
        b3.ifZeroComparisonBranch((Location)notUnref, "==");
        b3.loadThis();
        b3.loadField(REMOTE_FIELD_NAME, remoteType);
        b3.checkCast(CodeBuilderUtil.UNREFERENCED_TYPE);
        b3.invokeInterface(CodeBuilderUtil.UNREFERENCED_TYPE, "unreferenced", null, null);
        notUnref.setLocation();
        b3.returnVoid();
        MethodInfo mi3 = cf.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE, CodeBuilderUtil.SKEL_SUPPORT_TYPE, remoteType});
        CodeBuilder ctorBuilder = new CodeBuilder(mi3);
        ctorBuilder.loadThis();
        ctorBuilder.invokeSuperConstructor(null);
        if (hasDisposer) {
            cf.addField(Modifiers.PRIVATE.toFinal(true), ID_FIELD_NAME, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
            ctorBuilder.loadThis();
            ctorBuilder.loadLocal(ctorBuilder.getParameter(0));
            ctorBuilder.storeField(ID_FIELD_NAME, CodeBuilderUtil.VERSIONED_IDENTIFIER_TYPE);
        }
        ctorBuilder.loadThis();
        ctorBuilder.loadLocal(ctorBuilder.getParameter(1));
        ctorBuilder.storeField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
        ctorBuilder.loadThis();
        ctorBuilder.loadLocal(ctorBuilder.getParameter(2));
        ctorBuilder.storeField(REMOTE_FIELD_NAME, remoteType);
        if (hasOrderedMethods) {
            TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
            cf.addField(Modifiers.PRIVATE.toFinal(true), ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
            ctorBuilder.loadThis();
            ctorBuilder.loadLocal(ctorBuilder.getParameter(1));
            ctorBuilder.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "createOrderedInvoker", orderedInvokerType, null);
            ctorBuilder.storeField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
        }
        ctorBuilder.returnVoid();
        staticInitBuilder.returnVoid();
        return cf.defineClass();
    }

    private static String generateMethodName(Map<String, Integer> methodNames, RemoteMethod method) {
        String name = method.getName();
        while (true) {
            Integer count;
            if ((count = methodNames.get(name)) == null) {
                methodNames.put(name, 1);
                return name;
            }
            methodNames.put(name, count + 1);
            name = name + '$' + count;
        }
    }

    private static LocalVariable invInVar(CodeBuilder b, LocalVariable channelVar, LocalVariable invInVar) {
        if (invInVar == null) {
            b.loadLocal(channelVar);
            b.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getInputStream", CodeBuilderUtil.INV_IN_TYPE, null);
            invInVar = b.createLocalVariable(null, CodeBuilderUtil.INV_IN_TYPE);
            b.storeLocal(invInVar);
        }
        return invInVar;
    }

    private TypeDesc invokeMethod(CodeBuilder b, RemoteMethod method) {
        TypeDesc remoteType = TypeDesc.forClass(this.mType);
        if (this.methodExists(method)) {
            TypeDesc returnDesc = CodeBuilderUtil.getTypeDesc(method.getReturnType());
            TypeDesc[] params = CodeBuilderUtil.getTypeDescs(method.getParameterTypes());
            b.invokeInterface(remoteType, method.getName(), returnDesc, params);
            return returnDesc;
        }
        if (this.mLocalInfo == null) {
            TypeDesc exType = TypeDesc.forClass(MalformedRemoteObjectException.class);
            b.newObject(exType);
            b.dup();
            b.loadConstant(this.mMalformedInfoMessage);
            b.loadConstant(remoteType);
            b.invokeConstructor(exType, new TypeDesc[]{TypeDesc.STRING, CodeBuilderUtil.CLASS_TYPE});
            b.throwObject();
            return null;
        }
        b.newObject(CodeBuilderUtil.UNIMPLEMENTED_EX_TYPE);
        b.dup();
        b.loadConstant(method.getSignature());
        b.invokeConstructor(CodeBuilderUtil.UNIMPLEMENTED_EX_TYPE, new TypeDesc[]{TypeDesc.STRING});
        b.throwObject();
        return null;
    }

    private boolean methodExists(RemoteMethod method) {
        if (this.mLocalInfo == this.mInfo) {
            return true;
        }
        if (this.mLocalInfo == null) {
            return false;
        }
        List<RemoteParameter<?>> paramList = method.getParameterTypes();
        RemoteParameter[] paramTypes = new RemoteParameter[paramList.size()];
        paramList.toArray(paramTypes);
        try {
            RemoteMethod localMethod = this.mLocalInfo.getRemoteMethod(method.getName(), paramTypes);
            return CodeBuilderUtil.equalTypes(localMethod.getReturnType(), method.getReturnType());
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private void genFinished(CodeBuilder b, LocalVariable channelVar, boolean reset) {
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
        b.loadLocal(channelVar);
        b.loadConstant(reset);
        b.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "finished", TypeDesc.INT, new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE, TypeDesc.BOOLEAN});
    }

    private void genFinishedAsync(CodeBuilder b, LocalVariable channelVar) {
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
        b.loadLocal(channelVar);
        b.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "finishedAsync", null, new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE});
    }

    private void genWaitForNext(CodeBuilder b, LocalVariable sequenceVar) {
        TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
        b.loadThis();
        b.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
        b.loadLocal(sequenceVar);
        b.invokeVirtual(orderedInvokerType, "waitForNext", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.INT});
    }

    private void genIsNext(CodeBuilder b, LocalVariable sequenceVar) {
        TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
        b.loadThis();
        b.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
        b.loadLocal(sequenceVar);
        b.invokeVirtual(orderedInvokerType, "isNext", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.INT});
    }

    private void genExceptionHandler(CodeBuilder b, Label tryStart, Label tryEnd, LocalVariable sequenceVar) {
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, Throwable.class.getName());
        if (sequenceVar != null) {
            TypeDesc orderedInvokerType = TypeDesc.forClass(OrderedInvoker.class);
            b.loadThis();
            b.loadField(ORDERED_INVOKER_FIELD_NAME, orderedInvokerType);
            b.loadLocal(sequenceVar);
            b.invokeVirtual(orderedInvokerType, "finished", null, new TypeDesc[]{TypeDesc.INT});
        }
    }

    private void genDiscardResponse(CodeBuilder b, TypeDesc type) {
        if (type != null) {
            if (type.isDoubleWord()) {
                b.pop2();
            } else {
                b.pop();
            }
        }
    }

    private void genCompletionResponse(CodeBuilder b, TypeDesc type, LocalVariable completionVar, Label tryStart, Label tryEnd, LocalVariable sequenceVar) {
        TypeDesc remoteCompletionType = TypeDesc.forClass(RemoteCompletion.class);
        LocalVariable valueVar = b.createLocalVariable(null, type);
        b.storeLocal(valueVar);
        b.loadThis();
        b.loadField(SUPPORT_FIELD_NAME, CodeBuilderUtil.SKEL_SUPPORT_TYPE);
        b.loadLocal(valueVar);
        b.loadLocal(completionVar);
        b.invokeInterface(CodeBuilderUtil.SKEL_SUPPORT_TYPE, "completion", null, new TypeDesc[]{TypeDesc.forClass(Future.class), remoteCompletionType});
        Label skip = b.createLabel();
        b.branch((Location)skip);
        this.genExceptionHandler(b, tryStart, tryEnd, sequenceVar);
        LocalVariable throwableVar = b.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
        b.storeLocal(throwableVar);
        b.loadLocal(completionVar);
        b.loadLocal(throwableVar);
        b.invokeInterface(remoteCompletionType, "exception", null, new TypeDesc[]{CodeBuilderUtil.THROWABLE_TYPE});
        skip.setLocation();
    }

    private Class[] declaredExceptionTypes(RemoteMethod method) {
        Set<? extends RemoteParameter<? extends Throwable>> all = method.getExceptionTypes();
        ArrayList<Class<? extends Throwable>> declared = new ArrayList<Class<? extends Throwable>>(all.size());
        for (RemoteParameter<? extends Throwable> remoteParameter : all) {
            Class<? extends Throwable> type = remoteParameter.getType();
            if (RuntimeException.class.isAssignableFrom(type) || Error.class.isAssignableFrom(type)) continue;
            declared.add(type);
        }
        return declared.toArray(new Class[declared.size()]);
    }

    private static class Factory<R extends Remote>
    implements SkeletonFactory<R> {
        private final Constructor<? extends Skeleton> mSkeletonCtor;

        Factory(Constructor<? extends Skeleton> ctor) {
            this.mSkeletonCtor = ctor;
        }

        @Override
        public Skeleton createSkeleton(VersionedIdentifier objId, SkeletonSupport support, R remoteServer) {
            Skeleton skeleton;
            block5: {
                Throwable error;
                try {
                    skeleton = this.mSkeletonCtor.newInstance(objId, support, remoteServer);
                    break block5;
                }
                catch (InstantiationException e) {
                    error = e;
                }
                catch (IllegalAccessException e) {
                    error = e;
                }
                catch (InvocationTargetException e) {
                    error = e.getCause();
                }
                InternalError ie = new InternalError();
                ie.initCause(error);
                throw ie;
            }
            if (remoteServer instanceof SessionAware) {
                final Skeleton fSkeleton = skeleton;
                skeleton = new Skeleton<R>(){

                    @Override
                    public R getRemoteServer() {
                        return fSkeleton.getRemoteServer();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int invoke(Link sessionLink, int methodId, InvocationChannel channel, BatchedInvocationException batchedException) throws IOException, NoSuchMethodException, ClassNotFoundException, BatchedInvocationException {
                        LocalSession.THE.set(sessionLink);
                        try {
                            int n = fSkeleton.invoke(sessionLink, methodId, channel, batchedException);
                            return n;
                        }
                        finally {
                            LocalSession.THE.remove();
                        }
                    }

                    @Override
                    public void unreferenced() {
                        fSkeleton.unreferenced();
                    }
                };
            }
            return skeleton;
        }
    }
}

