/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.Asynchronous;
import org.cojen.dirmi.ClassResolver;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.Link;
import org.cojen.dirmi.MalformedRemoteObjectException;
import org.cojen.dirmi.NoSuchClassException;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.ReconstructedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.Response;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionCloseListener;
import org.cojen.dirmi.Timeout;
import org.cojen.dirmi.TimeoutParam;
import org.cojen.dirmi.Unbatched;
import org.cojen.dirmi.UnimplementedMethodException;
import org.cojen.dirmi.core.AbstractIdentifier;
import org.cojen.dirmi.core.AbstractInvocationChannel;
import org.cojen.dirmi.core.AbstractStubSupport;
import org.cojen.dirmi.core.ClassDescriptorCache;
import org.cojen.dirmi.core.ClassLoaderResolver;
import org.cojen.dirmi.core.ClientPipe;
import org.cojen.dirmi.core.DisposedStubSupport;
import org.cojen.dirmi.core.DrainableObjectOutputStream;
import org.cojen.dirmi.core.Identifier;
import org.cojen.dirmi.core.InvocationChannel;
import org.cojen.dirmi.core.InvocationInputStream;
import org.cojen.dirmi.core.InvocationOutputStream;
import org.cojen.dirmi.core.LinkWrapper;
import org.cojen.dirmi.core.Marshalled;
import org.cojen.dirmi.core.MarshalledIntrospectionFailure;
import org.cojen.dirmi.core.MarshalledRemote;
import org.cojen.dirmi.core.OrderedInvoker;
import org.cojen.dirmi.core.RemoteCompletion;
import org.cojen.dirmi.core.RemoteCompletionServer;
import org.cojen.dirmi.core.RemoteTypeResolver;
import org.cojen.dirmi.core.ServerPipe;
import org.cojen.dirmi.core.SessionExchanger;
import org.cojen.dirmi.core.SessionRef;
import org.cojen.dirmi.core.Skeleton;
import org.cojen.dirmi.core.SkeletonFactory;
import org.cojen.dirmi.core.SkeletonFactoryGenerator;
import org.cojen.dirmi.core.SkeletonSupport;
import org.cojen.dirmi.core.StubFactory;
import org.cojen.dirmi.core.StubFactoryGenerator;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.core.VersionedIdentifier;
import org.cojen.dirmi.info.RemoteInfo;
import org.cojen.dirmi.info.RemoteIntrospector;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.ChannelBroker;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.util.Cache;
import org.cojen.dirmi.util.ScheduledTask;
import org.cojen.dirmi.util.Timer;
import org.cojen.util.ThrowUnchecked;

public class StandardSession
implements Session {
    static final int MAGIC_NUMBER = 1989588515;
    static final int PROTOCOL_VERSION = 20100321;
    private static final int DEFAULT_CHANNEL_IDLE_SECONDS = 60;
    private static final int DISPOSE_BATCH = 1000;
    private static final int CONNECT_TIMEOUT_SECONDS = 10;
    private static final int CREATE_TIMEOUT_SECONDS = 15;
    private static final int DEFAULT_DISPOSE_DELAY_SECONDS = 10;
    private static final AtomicIntegerFieldUpdater<StandardSession> closeStateUpdater = AtomicIntegerFieldUpdater.newUpdater(StandardSession.class, "mCloseState");
    private static final AtomicIntegerFieldUpdater<StandardSession> suppressPingUpdater = AtomicIntegerFieldUpdater.newUpdater(StandardSession.class, "mSuppressPing");
    private final boolean mIsolated;
    final ChannelBroker mBroker;
    final IOExecutor mExecutor;
    final ClassDescriptorCache mDescriptorCache;
    final SessionExchanger mSessionExchanger = new SessionExchanger();
    final ReferenceQueue<Object> mReferenceQueue;
    final ConcurrentMap<VersionedIdentifier, SkeletonFactory> mSkeletonFactories;
    final Cache<Identifier, SkeletonFactory> mRemoteSkeletonFactories;
    final ConcurrentMap<VersionedIdentifier, Skeleton> mSkeletons;
    final SkeletonSupport mSkeletonSupport;
    final Cache<VersionedIdentifier, StubFactory> mStubFactories;
    final ConcurrentMap<VersionedIdentifier, StubFactoryRef> mStubFactoryRefs;
    final Cache<VersionedIdentifier, Remote> mStubs;
    final ConcurrentMap<VersionedIdentifier, StubRef> mStubRefs;
    final Hidden.Admin mRemoteAdmin;
    final LinkedList<InvocationChan> mChannelPool;
    final ThreadLocal<InvocationChannel> mLocalChannel;
    final Map<InvocationChannel, Thread> mHeldChannelMap;
    volatile int mClockSeconds;
    final ScheduledFuture<?> mClockTask;
    final ScheduledFuture<?> mBackgroundTask;
    final RemoteTypeResolver mTypeResolver;
    volatile int mSuppressPing;
    private final Object mCloseLock;
    private static final int STATE_CLOSING = 4;
    private static final int STATE_UNREF = 2;
    private static final int STATE_PEER_UNREF = 1;
    volatile int mCloseState;
    private String mCloseMessage;
    private Object mCloseListeners;
    static final AtomicReferenceFieldUpdater<InvocationChan, Future> timeoutTaskUpdater = AtomicReferenceFieldUpdater.newUpdater(InvocationChan.class, Future.class, "mTimeoutTask");
    static final Future<Object> timedOut = Response.complete(null);

    public static Session create(IOExecutor executor, ChannelBroker broker) throws IOException {
        return StandardSession.create(executor, broker, -1L, null);
    }

    public static Session create(IOExecutor executor, ChannelBroker broker, long timeout, TimeUnit unit) throws IOException {
        Timer timer = timeout < 0L ? Timer.seconds(15L) : new Timer(timeout, unit);
        return new SessionRef(new StandardSession(executor, broker, timer));
    }

    public static Session create(IOExecutor executor, ChannelBroker broker, Timer timer) throws IOException {
        return new SessionRef(new StandardSession(executor, broker, timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardSession(IOExecutor executor, ChannelBroker broker, Timer timer) throws IOException {
        if (broker == null) {
            throw new IllegalArgumentException("Broker is null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Executor is null");
        }
        String isolated = null;
        try {
            isolated = System.getProperty("org.cojen.dirmi.isolatedSessions");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.mIsolated = isolated == null || isolated.equalsIgnoreCase("true");
        this.mTypeResolver = new RemoteTypeResolver();
        this.mCloseLock = new Object();
        this.mBroker = broker;
        this.mExecutor = executor;
        this.mDescriptorCache = new ClassDescriptorCache(executor);
        this.mReferenceQueue = new ReferenceQueue();
        this.mSkeletonFactories = new ConcurrentHashMap<VersionedIdentifier, SkeletonFactory>();
        this.mRemoteSkeletonFactories = Cache.newSoftValueCache(17);
        this.mSkeletons = new ConcurrentHashMap<VersionedIdentifier, Skeleton>();
        this.mSkeletonSupport = new SkeletonSupportImpl();
        this.mStubFactories = Cache.newSoftValueCache(17);
        this.mStubFactoryRefs = new ConcurrentHashMap<VersionedIdentifier, StubFactoryRef>();
        this.mStubs = Cache.newWeakValueCache(17);
        this.mStubRefs = new ConcurrentHashMap<VersionedIdentifier, StubRef>();
        this.mChannelPool = new LinkedList();
        this.mLocalChannel = new ThreadLocal();
        this.mHeldChannelMap = Collections.synchronizedMap(new HashMap());
        class Bootstrap
        implements ChannelAcceptor.Listener {
            private boolean mFinished;

            Bootstrap() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accepted(Channel channel) {
                this.finished();
                try {
                    InvocationChan chan = new InvocationChan(channel);
                    InvocationInputStream in = chan.getInputStream();
                    InvocationOutputStream out = chan.getOutputStream();
                    try {
                        int magic = in.readInt();
                        out.writeInt(1989588515);
                        if (magic != 1989588515) {
                            return;
                        }
                        int version = in.readInt();
                        out.writeInt(20100321);
                        if (version != 20100321) {
                            return;
                        }
                        out.writeUnshared(new AdminImpl());
                    }
                    finally {
                        out.flush();
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    channel.disconnect();
                }
            }

            @Override
            public void rejected(RejectedException e) {
                this.finished();
            }

            @Override
            public void failed(IOException e) {
                this.finished();
            }

            @Override
            public void closed(IOException e) {
                this.finished();
            }

            synchronized void waitToFinish(Timer timer) throws IOException {
                while (!this.mFinished) {
                    long remaining = RemoteTimeoutException.checkRemaining(timer);
                    long timeoutMillis = timer.unit().toMillis(remaining);
                    if (timeoutMillis == 0L) {
                        timeoutMillis = 1L;
                    }
                    try {
                        this.wait(timeoutMillis);
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                }
            }

            private synchronized void finished() {
                this.mFinished = true;
                this.notifyAll();
            }
        }
        Bootstrap bootstrap = new Bootstrap();
        broker.accept(bootstrap);
        Channel channel = broker.connect(timer);
        try {
            InvocationChan chan = new InvocationChan(channel);
            InvocationOutputStream out = chan.getOutputStream();
            InvocationInputStream in = chan.getInputStream();
            chan.startTimeout(RemoteTimeoutException.checkRemaining(timer), timer.unit());
            out.writeInt(1989588515);
            out.writeInt(20100321);
            out.flush();
            int magic = in.readInt();
            if (magic != 1989588515) {
                throw new IOException("Incorrect magic number: " + magic);
            }
            int version = in.readInt();
            if (version != 20100321) {
                throw new IOException("Unsupported protocol version: " + version);
            }
            try {
                this.mRemoteAdmin = (Hidden.Admin)in.readUnshared();
            }
            catch (ClassNotFoundException e) {
                IOException io = new IOException();
                io.initCause(e);
                throw io;
            }
            chan.cancelTimeout();
        }
        finally {
            channel.disconnect();
        }
        this.updateClock();
        try {
            this.mClockTask = executor.scheduleWithFixedDelay(new ScheduledTask<RuntimeException>(){

                @Override
                protected void doRun() {
                    StandardSession.this.updateClock();
                }
            }, 1L, 1L, TimeUnit.SECONDS);
            long delay = 5L;
            this.mBackgroundTask = executor.scheduleWithFixedDelay(new BackgroundTask(), delay, delay, TimeUnit.SECONDS);
        }
        catch (RejectedException e) {
            String message = "Unable to start background task";
            this.closeOnFailure(message, e);
            throw new RejectedException(message, e);
        }
        bootstrap.waitToFinish(timer);
        this.mBroker.accept(new Handler());
        ClassDescriptorCache.Handle handle = this.mDescriptorCache.localLink();
        try {
            this.mRemoteAdmin.linkDescriptorCache(handle, RemoteTimeoutException.checkRemaining(timer), timer.unit());
        }
        catch (UnimplementedMethodException e) {
            this.mRemoteAdmin.linkDescriptorCache(handle);
        }
    }

    @Override
    public void send(Object obj) throws RemoteException {
        this.send(obj, -1L, null);
    }

    @Override
    public void send(Object obj, long timeout, TimeUnit unit) throws RemoteException {
        if (timeout >= 0L && unit == null) {
            throw new NullPointerException("TimeUnit is null");
        }
        if (this.isClosing()) {
            throw new ClosedException("Session closed");
        }
        try {
            if (!this.mSessionExchanger.enqueue(obj, timeout, unit)) {
                throw new RemoteTimeoutException(timeout, unit);
            }
            if (this.isClosing()) {
                boolean anyDropped = false;
                while (this.mSessionExchanger.dequeue(null) != null) {
                    anyDropped = true;
                }
                if (anyDropped) {
                    throw new ClosedException("Session closed");
                }
            }
        }
        catch (RemoteException e) {
            this.closeOnFailure("Closed: " + e, e);
            throw e;
        }
        catch (InterruptedException e) {
            this.closeOnFailure("Closed: " + e, e);
            throw new RemoteException(e.toString(), e);
        }
    }

    @Override
    public Object receive() throws RemoteException {
        return this.receive(-1L, null);
    }

    @Override
    public Object receive(long timeout, TimeUnit unit) throws RemoteException {
        if (timeout >= 0L && unit == null) {
            throw new NullPointerException("TimeUnit is null");
        }
        try {
            Object obj;
            block11: {
                RemoteCompletionServer<Object> callback = new RemoteCompletionServer<Object>(null);
                obj = this.mRemoteAdmin.sessionDequeue(callback);
                if (obj == null) {
                    try {
                        if (timeout < 0L) {
                            obj = callback.get();
                            break block11;
                        }
                        try {
                            obj = callback.get(timeout, unit);
                        }
                        catch (TimeoutException e) {
                            throw new RemoteTimeoutException(timeout, unit);
                        }
                    }
                    catch (ExecutionException e) {
                        throw new RemoteException(e.getCause().getMessage(), e.getCause());
                    }
                }
            }
            if (obj instanceof SessionExchanger.Null) {
                obj = null;
            }
            return obj;
        }
        catch (RemoteException e) {
            this.closeOnFailure("Closed: " + e, e);
            throw e;
        }
        catch (InterruptedException e) {
            this.closeOnFailure("Closed: " + e, e);
            throw new RemoteException(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(final SessionCloseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        Object object = this.mCloseLock;
        synchronized (object) {
            if (this.mCloseListeners == null) {
                this.mCloseListeners = listener;
            } else if (this.mCloseListeners instanceof SessionCloseListener.Cause) {
                final Link sessionLink = LinkWrapper.wrap(this);
                try {
                    this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.closed(sessionLink, (SessionCloseListener.Cause)((Object)StandardSession.this.mCloseListeners));
                        }
                    });
                }
                catch (RejectedException e) {
                    throw e.throwUncheckedException();
                }
            } else if (this.mCloseListeners instanceof SessionCloseListener) {
                CopyOnWriteArrayList<Object> list = new CopyOnWriteArrayList<Object>();
                list.add(this.mCloseListeners);
                list.add(listener);
                this.mCloseListeners = list;
            } else {
                ((CopyOnWriteArrayList)this.mCloseListeners).add(listener);
            }
        }
    }

    @Override
    public void setClassResolver(ClassResolver resolver) {
        this.mTypeResolver.setClassResolver(resolver);
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        if (loader == null) {
            this.setClassResolver(null);
        } else {
            this.setClassResolver(new ClassLoaderResolver(loader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        ArrayList<InvocationChan> channels;
        IOException exception = null;
        Object object = this.mChannelPool;
        synchronized (object) {
            channels = new ArrayList<InvocationChan>(this.mChannelPool);
        }
        object = this.mHeldChannelMap;
        synchronized (object) {
            channels.addAll(this.mHeldChannelMap.keySet());
        }
        int i = channels.size();
        while (--i >= 0) {
            try {
                ((InvocationChannel)channels.get(i)).flush();
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() throws IOException {
        this.close(SessionCloseListener.Cause.LOCAL_CLOSE, null, null);
    }

    void close(String message) {
        try {
            this.close(SessionCloseListener.Cause.LOCAL_CLOSE, message, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void closeOnFailure(String message, Throwable exception) {
        try {
            this.close(SessionCloseListener.Cause.COMMUNICATION_FAILURE, message, exception);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void peerClosed(String message) {
        try {
            this.close(SessionCloseListener.Cause.REMOTE_CLOSE, message, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(SessionCloseListener.Cause cause, String message, Throwable exception) throws IOException {
        message = message == null ? "Session closed" : "Session closed (" + message + ')';
        Object object = this.mCloseLock;
        synchronized (object) {
            if (this.isClosing()) {
                return;
            }
            this.mCloseMessage = null;
            this.setCloseState(4);
        }
        try {
            ArrayList<InvocationChan> toDiscard;
            ScheduledFuture<?> task;
            if (cause == SessionCloseListener.Cause.LOCAL_CLOSE && this.mRemoteAdmin != null) {
                try {
                    this.mRemoteAdmin.closedExplicitly();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if ((task = this.mClockTask) != null) {
                task.cancel(false);
            }
            if ((task = this.mBackgroundTask) != null) {
                task.cancel(false);
            }
            this.mBroker.close();
            LinkedList<InvocationChan> linkedList = this.mChannelPool;
            synchronized (linkedList) {
                toDiscard = new ArrayList<InvocationChan>(this.mChannelPool);
                this.mChannelPool.clear();
            }
            for (InvocationChan chan : toDiscard) {
                if (cause == SessionCloseListener.Cause.LOCAL_CLOSE) {
                    chan.discard();
                    continue;
                }
                chan.disconnect();
            }
        }
        finally {
            this.clearCollections();
            this.mCloseMessage = message;
            this.setCloseState(4);
            while (this.mSessionExchanger.dequeue(null) != null) {
            }
            object = this.mCloseLock;
            synchronized (object) {
                Link sessionLink = LinkWrapper.wrap(this);
                try {
                    if (this.mCloseListeners instanceof SessionCloseListener) {
                        ((SessionCloseListener)this.mCloseListeners).closed(sessionLink, cause);
                    } else if (this.mCloseListeners instanceof CopyOnWriteArrayList) {
                        CopyOnWriteArrayList list = (CopyOnWriteArrayList)this.mCloseListeners;
                        for (Object obj : list) {
                            ((SessionCloseListener)obj).closed(sessionLink, cause);
                        }
                    }
                }
                finally {
                    this.mCloseListeners = cause;
                }
            }
        }
    }

    boolean isClosing() {
        return (this.mCloseState & 4) != 0;
    }

    void setCloseState(int mask) {
        int state;
        while (!closeStateUpdater.compareAndSet(this, state = this.mCloseState, state | mask)) {
        }
    }

    void sessionUnreferenced() {
        this.setCloseState(2);
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        StandardSession.this.mRemoteAdmin.sessionUnreferenced();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (RejectedException e) {
            try {
                this.mRemoteAdmin.sessionUnreferenced();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCollections() {
        this.mSkeletonFactories.clear();
        this.mStubFactoryRefs.clear();
        this.mStubRefs.clear();
        for (Skeleton skeleton : this.mSkeletons.values()) {
            this.unreferenced(skeleton);
        }
        this.mSkeletons.clear();
        Cache<VersionedIdentifier, Object> cache = this.mRemoteSkeletonFactories;
        synchronized (cache) {
            this.mRemoteSkeletonFactories.clear();
        }
        cache = this.mStubFactories;
        synchronized (cache) {
            this.mStubFactories.clear();
        }
        cache = this.mStubs;
        synchronized (cache) {
            this.mStubs.clear();
        }
    }

    void unreferenced(Skeleton skeleton) {
        try {
            skeleton.unreferenced();
        }
        catch (Throwable e) {
            this.uncaughtException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addSkeleton(VersionedIdentifier objId, Skeleton skeleton) {
        Object object = this.mCloseLock;
        synchronized (object) {
            if (!this.isClosing()) {
                objId.nextLocalVersion();
                this.mSkeletons.putIfAbsent(objId, skeleton);
                return true;
            }
        }
        this.unreferenced(skeleton);
        return false;
    }

    @Override
    public Object getRemoteAddress() {
        return this.mBroker.getRemoteAddress();
    }

    @Override
    public Object getLocalAddress() {
        return this.mBroker.getLocalAddress();
    }

    public String toString() {
        return "Session {localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }

    void sendDisposedStubs() throws RemoteException {
        if (this.mRemoteAdmin == null) {
            return;
        }
        while (true) {
            Reference<Object> ref;
            ArrayList<VersionedIdentifier> disposedList = new ArrayList<VersionedIdentifier>();
            while (disposedList.size() < 1000 && (ref = this.mReferenceQueue.poll()) != null) {
                VersionedIdentifier id = ((Ref)ref).unreachable();
                if (id == null) continue;
                disposedList.add(id);
            }
            int size = disposedList.size();
            if (size == 0) {
                return;
            }
            final VersionedIdentifier[] disposed = new VersionedIdentifier[size];
            final int[] localVersions = new int[size];
            final int[] remoteVersions = new int[size];
            for (int i = 0; i < size; ++i) {
                VersionedIdentifier id;
                disposed[i] = id = (VersionedIdentifier)disposedList.get(i);
                localVersions[i] = id.localVersion();
                remoteVersions[i] = id.remoteVersion();
            }
            int delay = 10;
            this.mExecutor.schedule(new Runnable(){
                int mRetryCount;

                @Override
                public void run() {
                    try {
                        StandardSession.this.mRemoteAdmin.disposed(disposed, localVersions, remoteVersions);
                    }
                    catch (RemoteException e) {
                        block6: {
                            if (StandardSession.this.isClosing()) {
                                return;
                            }
                            if (this.mRetryCount++ < 2) {
                                try {
                                    StandardSession.this.mExecutor.schedule(this, 10L, TimeUnit.SECONDS);
                                    return;
                                }
                                catch (RejectedException e2) {
                                    if (!StandardSession.this.isClosing()) break block6;
                                    return;
                                }
                            }
                        }
                        StandardSession.this.closeOnFailure("Unable to dispose remote objects", e);
                    }
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * Exception decompiling
     */
    void handleRequests(InvocationChannel invChannel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void readRequest(InvocationChannel invChannel) {
        if (invChannel.usesSelectNotification()) {
            this.listenForRequestAsync(invChannel);
        } else {
            this.handleRequests(invChannel);
        }
    }

    void resumeAndReadRequestAsync(final InvocationChannel invChannel) throws RejectedException {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!(invChannel instanceof InvocationChan)) {
                    invChannel.disconnect();
                    return;
                }
                InvocationChan chan = (InvocationChan)invChannel;
                if (!chan.inputResume()) {
                    if (chan.isResumeSupported()) {
                        try {
                            while (chan.skip(Integer.MAX_VALUE) > 0L) {
                            }
                        }
                        catch (IOException e) {
                            chan.disconnect();
                            return;
                        }
                    }
                    if (!chan.inputResume()) {
                        chan.disconnect();
                        return;
                    }
                }
                try {
                    chan = new InvocationChan(chan);
                }
                catch (IOException e) {
                    chan.disconnect();
                    return;
                }
                StandardSession.this.readRequest(chan);
            }
        });
    }

    void listenForRequestAsync(final InvocationChannel invChannel) {
        invChannel.inputNotify(new Channel.Listener(){

            @Override
            public void ready() {
                StandardSession.this.handleRequests(invChannel);
            }

            @Override
            public void rejected(RejectedException cause) {
                StandardSession.this.closeDueToRejection(invChannel, cause);
            }

            @Override
            public void closed(IOException cause) {
                invChannel.disconnect();
            }
        });
    }

    InvocationChan toInvocationChannel(Channel channel, final boolean accepted) throws IOException {
        SkeletonFactory<Remote> existing;
        Remote control = channel.installRecycler(new Channel.Recycler(){

            @Override
            public void recycled(final Channel channel) {
                try {
                    StandardSession.this.mExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            InvocationChan invChannel;
                            try {
                                invChannel = StandardSession.this.toInvocationChannel(channel, accepted);
                            }
                            catch (IOException e) {
                                channel.disconnect();
                                return;
                            }
                            if (accepted) {
                                StandardSession.this.readRequest(invChannel);
                            } else {
                                invChannel.recycle();
                            }
                        }
                    });
                }
                catch (RejectedException e) {
                    channel.disconnect();
                }
            }
        });
        InvocationChan invChannel = new InvocationChan(channel);
        if (control == null) {
            return invChannel;
        }
        Class<Remote> controlType = RemoteIntrospector.getRemoteType(control);
        VersionedIdentifier controlTypeId = VersionedIdentifier.identify(controlType);
        VersionedIdentifier controlId = VersionedIdentifier.identify(control);
        SkeletonFactory<Remote> factory = (SkeletonFactory<Remote>)this.mSkeletonFactories.get(controlTypeId);
        if (factory == null && (existing = this.mSkeletonFactories.putIfAbsent(controlTypeId, factory = SkeletonFactoryGenerator.getSkeletonFactory(controlType))) != null) {
            factory = existing;
        }
        Skeleton<Remote> skeleton = factory.createSkeleton(controlId, this.mSkeletonSupport, control);
        this.addSkeleton(controlId, skeleton);
        controlId.writeWithNextVersion(invChannel);
        invChannel.flush();
        controlId = VersionedIdentifier.read(invChannel);
        int controlVersion = invChannel.readInt();
        StubFactory<Remote> factory2 = this.mStubFactories.get(controlTypeId);
        if (factory2 == null) {
            RemoteInfo info = RemoteIntrospector.examine(controlType);
            factory2 = StubFactoryGenerator.getStubFactory(controlType, info);
            StubFactory<Remote> existing2 = StandardSession.register(this.mStubFactories, controlTypeId, factory2);
            if (existing2 == factory2) {
                this.mStubFactoryRefs.put(controlTypeId, new StubFactoryRef(factory2, this.mReferenceQueue, controlTypeId));
            } else {
                factory2 = existing2;
            }
        }
        controlId.updateRemoteVersion(controlVersion);
        Remote remoteControl = this.createAndRegisterStub(controlId, factory2, new StubSupportImpl(controlId));
        channel.setRecycleControl(remoteControl);
        return invChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvocationChannel getPooledChannel() throws IOException {
        String message;
        if (this.isClosing() && (message = this.mCloseMessage) != null) {
            throw new ClosedException(message);
        }
        InvocationChannel channel = this.mLocalChannel.get();
        if (channel != null) {
            return channel;
        }
        LinkedList<InvocationChan> linkedList = this.mChannelPool;
        synchronized (linkedList) {
            if (this.mChannelPool.size() > 0) {
                return this.mChannelPool.removeLast();
            }
        }
        return null;
    }

    void holdLocalChannel(InvocationChannel channel) {
        this.mLocalChannel.set(channel);
        this.mHeldChannelMap.put(channel, Thread.currentThread());
    }

    void releaseLocalChannel() {
        InvocationChannel channel = this.mLocalChannel.get();
        if (channel != null) {
            this.mLocalChannel.remove();
            this.mHeldChannelMap.remove(channel);
        }
    }

    void uncaughtException(Throwable e) {
        try {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void checkCommunication() {
        if (this.isClosing()) {
            return;
        }
        if (!suppressPingUpdater.compareAndSet(this, 0, 1)) {
            return;
        }
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            StandardSession.this.mRemoteAdmin.ping();
                        }
                        catch (UnimplementedMethodException e) {
                            try {
                                StandardSession.this.mRemoteAdmin.getRemoteInfo((Identifier)null);
                            }
                            catch (NullPointerException nullPointerException) {}
                        }
                    }
                    catch (RemoteException e) {
                        StandardSession.this.closeOnFailure("Ping failure", e);
                    }
                }
            });
        }
        catch (RejectedException rejectedException) {
            // empty catch block
        }
    }

    void closeDueToRejection(Channel channel, RejectedException cause) {
        if (!this.isClosing()) {
            RejectedException ex = cause.isShutdown() ? new RejectedException("No threads available; closing channel: " + channel, cause) : new RejectedException("Too many active threads; closing channel: " + channel, cause);
            this.uncaughtException(ex);
        }
        channel.disconnect();
    }

    Remote findIdentifiedRemote(VersionedIdentifier objId) {
        Remote remote = this.mStubs.get(objId);
        if (remote == null) {
            if (this.mIsolated) {
                Skeleton skeleton = (Skeleton)this.mSkeletons.get(objId);
                if (skeleton != null) {
                    remote = skeleton.getRemoteServer();
                }
            } else {
                Object retrieved = objId.tryRetrieve();
                if (retrieved instanceof Remote) {
                    remote = (Remote)retrieved;
                }
            }
        }
        return remote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <K extends AbstractIdentifier, V> V register(Cache<K, V> cache, K key, V value) {
        Cache<K, V> cache2 = cache;
        synchronized (cache2) {
            V existing = cache.get(key);
            if (existing != null) {
                return existing;
            }
            cache.put(key, value);
        }
        key.register(value);
        return value;
    }

    <R extends Remote> R createAndRegisterStub(VersionedIdentifier objId, StubFactory<R> factory, StubSupportImpl support) {
        Object remote = factory.createStub(support);
        Remote existing = StandardSession.register(this.mStubs, objId, remote);
        if (existing == remote) {
            this.mStubRefs.put(objId, new StubRef((Remote)remote, this.mReferenceQueue, support));
        } else {
            remote = existing;
        }
        return remote;
    }

    void clearStub(VersionedIdentifier objId) {
        StubRef ref = (StubRef)this.mStubRefs.remove(objId);
        if (ref != null) {
            ref.clear();
        }
    }

    void updateClock() {
        this.mClockSeconds = (int)(System.nanoTime() / 1000000000L);
    }

    void disposeSkeleton(VersionedIdentifier objId) {
        Skeleton skeleton = (Skeleton)this.mSkeletons.remove(objId);
        if (skeleton != null) {
            this.unreferenced(skeleton);
        }
    }

    static <V> void completion(Future<V> response, RemoteCompletion<V> completion) throws RemoteException {
        try {
            completion.complete(response == null ? null : (Object)response.get());
        }
        catch (InterruptedException e) {
            completion.exception(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            completion.exception(cause);
        }
    }

    private class StubSupportImpl
    extends AbstractStubSupport {
        StubSupportImpl(VersionedIdentifier id) {
            super(id);
        }

        private StubSupportImpl() {
        }

        @Override
        public Link sessionLink() {
            return LinkWrapper.wrap(StandardSession.this);
        }

        @Override
        public InvocationChannel unbatch() {
            InvocationChannel channel = StandardSession.this.mLocalChannel.get();
            if (channel != null) {
                StandardSession.this.mLocalChannel.set(null);
            }
            return channel;
        }

        @Override
        public void rebatch(InvocationChannel channel) {
            if (channel != null) {
                if (StandardSession.this.mLocalChannel.get() != null) {
                    throw new IllegalStateException();
                }
                StandardSession.this.mLocalChannel.set(channel);
            }
        }

        @Override
        public <T extends Throwable> InvocationChannel invoke(Class<T> remoteFailureEx) throws T {
            InvocationChannel channel;
            try {
                channel = this.getChannel();
            }
            catch (IOException e) {
                throw this.failed(remoteFailureEx, null, e);
            }
            try {
                this.mObjId.writeWithNextVersion(channel.getOutputStream());
            }
            catch (IOException e) {
                throw this.failed(remoteFailureEx, channel, e);
            }
            return channel;
        }

        @Override
        public <T extends Throwable> InvocationChannel invoke(Class<T> remoteFailureEx, long timeout, TimeUnit unit) throws T {
            if (timeout <= 0L) {
                if (timeout < 0L) {
                    return this.invoke(remoteFailureEx);
                }
                throw this.failed(remoteFailureEx, null, new RemoteTimeoutException(timeout, unit));
            }
            InvocationChannel channel = this.getChannel(remoteFailureEx, timeout, unit);
            try {
                this.mObjId.writeWithNextVersion(channel.getOutputStream());
            }
            catch (IOException e) {
                throw this.failedAndCancelTimeout(remoteFailureEx, channel, (Throwable)e, timeout, unit);
            }
            return channel;
        }

        @Override
        public <T extends Throwable> InvocationChannel invoke(Class<T> remoteFailureEx, double timeout, TimeUnit unit) throws T {
            InvocationChannel channel;
            if (!(timeout > 0.0)) {
                if (timeout < 0.0) {
                    return this.invoke(remoteFailureEx);
                }
                throw this.failed(remoteFailureEx, null, new RemoteTimeoutException(timeout, unit));
            }
            try {
                channel = this.getChannel(remoteFailureEx, this.toNanos(timeout, unit), TimeUnit.NANOSECONDS);
            }
            catch (Throwable e) {
                Throwable cause = e;
                do {
                    if (!(cause instanceof RemoteTimeoutException)) continue;
                    throw this.failed(remoteFailureEx, null, new RemoteTimeoutException(timeout, unit));
                } while ((cause = cause.getCause()) != null);
                ThrowUnchecked.fire((Throwable)e);
                return null;
            }
            try {
                this.mObjId.writeWithNextVersion(channel.getOutputStream());
            }
            catch (IOException e) {
                throw this.failedAndCancelTimeout(remoteFailureEx, channel, (Throwable)e, timeout, unit);
            }
            return channel;
        }

        @Override
        public <T extends Throwable, R extends Remote> R createBatchedRemote(Class<T> remoteFailureEx, InvocationChannel channel, Class<R> type) throws T {
            RemoteInfo info;
            try {
                info = RemoteIntrospector.examine(type);
            }
            catch (IllegalArgumentException e) {
                MalformedRemoteObjectException cause = new MalformedRemoteObjectException(e.getMessage(), type);
                throw this.failed(remoteFailureEx, channel, cause);
            }
            StubFactory<R> factory = StubFactoryGenerator.getStubFactory(type, info);
            StubSupportImpl support = new StubSupportImpl();
            Identifier typeId = Identifier.identify(type);
            try {
                typeId.write(channel);
                support.mObjId.writeWithNextVersion(channel.getOutputStream());
            }
            catch (IOException e) {
                throw this.failed(remoteFailureEx, channel, e);
            }
            return StandardSession.this.createAndRegisterStub(support.mObjId, factory, support);
        }

        @Override
        public void batched(InvocationChannel channel) {
            StandardSession.this.holdLocalChannel(channel);
        }

        @Override
        public void batchedAndCancelTimeout(InvocationChannel channel) {
            if (channel.cancelTimeout()) {
                StandardSession.this.holdLocalChannel(channel);
            } else {
                channel.disconnect();
            }
        }

        @Override
        public void release(InvocationChannel channel) {
            StandardSession.this.releaseLocalChannel();
        }

        @Override
        public Pipe requestReply(InvocationChannel channel) {
            StandardSession.this.releaseLocalChannel();
            return new ClientPipe(channel){

                @Override
                void tryInputResume(InvocationChannel channel) {
                    if (!(channel instanceof InvocationChan)) {
                        channel.disconnect();
                    } else {
                        ((InvocationChan)channel).inputResumeAndRecycle();
                    }
                }
            };
        }

        @Override
        public void finished(InvocationChannel channel, boolean reset) {
            StandardSession.this.releaseLocalChannel();
            if (!reset || this.reset(channel)) {
                if (channel instanceof InvocationChan) {
                    ((InvocationChan)channel).recycle();
                } else {
                    channel.disconnect();
                }
            }
        }

        @Override
        public void finishedAndCancelTimeout(InvocationChannel channel, boolean reset) {
            StandardSession.this.releaseLocalChannel();
            if (!reset || this.reset(channel)) {
                if (channel.cancelTimeout() && channel instanceof InvocationChan) {
                    ((InvocationChan)channel).recycle();
                } else {
                    channel.disconnect();
                }
            }
        }

        private boolean reset(InvocationChannel channel) {
            try {
                channel.reset();
                return true;
            }
            catch (IOException e) {
                channel.disconnect();
                return false;
            }
        }

        @Override
        public <T extends Throwable> T failed(Class<T> remoteFailureEx, InvocationChannel channel, Throwable cause) {
            StandardSession.this.releaseLocalChannel();
            if (channel != null) {
                channel.disconnect();
            }
            return this.remoteException(remoteFailureEx, cause);
        }

        @Override
        public StubSupport dispose() {
            DisposedStubSupport support = new DisposedStubSupport(this.mObjId);
            StandardSession.this.clearStub(this.mObjId);
            return support;
        }

        @Override
        protected void checkCommunication(Throwable cause) {
            StandardSession.this.checkCommunication();
        }

        private InvocationChannel getChannel() throws IOException {
            InvocationChannel channel = StandardSession.this.getPooledChannel();
            if (channel != null) {
                return channel;
            }
            return StandardSession.this.toInvocationChannel(StandardSession.this.mBroker.connect(10L, TimeUnit.SECONDS), false);
        }

        private <T extends Throwable> InvocationChannel getChannel(Class<T> remoteFailureEx, long timeout, TimeUnit unit) throws T {
            InvocationChannel channel;
            try {
                channel = StandardSession.this.getPooledChannel();
            }
            catch (IOException e) {
                throw this.failed(remoteFailureEx, null, e);
            }
            if (channel == null) {
                try {
                    if (timeout < 0L) {
                        channel = StandardSession.this.toInvocationChannel(StandardSession.this.mBroker.connect(), false);
                    } else {
                        long startNanos = System.nanoTime();
                        channel = StandardSession.this.toInvocationChannel(StandardSession.this.mBroker.connect(timeout, unit), false);
                        long elapsedNanos = System.nanoTime() - startNanos;
                        if ((timeout -= unit.convert(elapsedNanos, TimeUnit.NANOSECONDS)) < 0L) {
                            timeout = 0L;
                        }
                    }
                }
                catch (IOException e) {
                    throw this.failed(remoteFailureEx, null, e);
                }
            }
            try {
                channel.startTimeout(timeout, unit);
            }
            catch (IOException e) {
                throw this.failed(remoteFailureEx, channel, e);
            }
            return channel;
        }

        VersionedIdentifier unreachable() {
            return StandardSession.this.mStubRefs.remove(this.mObjId) == null ? null : this.mObjId;
        }
    }

    private class SkeletonSupportImpl
    implements SkeletonSupport {
        private SkeletonSupportImpl() {
        }

        @Override
        public Pipe requestReply(InvocationChannel channel) {
            return new ServerPipe(channel){

                @Override
                void tryInputResume(InvocationChannel channel) {
                    SkeletonSupportImpl.this.finishedAsync(channel, true);
                }
            };
        }

        @Override
        public <V> void completion(Future<V> response, RemoteCompletion<V> completion) throws RemoteException {
            StandardSession.completion(response, completion);
        }

        @Override
        public <R extends Remote> void linkBatchedRemote(Skeleton skeleton, String skeletonMethodName, Identifier typeId, VersionedIdentifier remoteId, Class<R> type, R remote) throws RemoteException {
            RemoteInfo remoteInfo;
            SkeletonFactory<R> existing;
            SkeletonFactory<R> factory = StandardSession.this.mRemoteSkeletonFactories.get(typeId);
            if (factory == null && (existing = StandardSession.register(StandardSession.this.mRemoteSkeletonFactories, typeId, factory = SkeletonFactoryGenerator.getSkeletonFactory(type, remoteInfo = StandardSession.this.mRemoteAdmin.getRemoteInfo(typeId)))) != factory) {
                factory = existing;
            }
            if (remote == null) {
                remote = this.failedBatchedRemote(type, new NullPointerException("Batched method \"" + skeleton.getRemoteServer().getClass().getName() + '.' + skeletonMethodName + "\" returned null"));
            }
            StandardSession.this.addSkeleton(remoteId, factory.createSkeleton(remoteId, this, remote));
        }

        @Override
        public <R extends Remote> R failedBatchedRemote(Class<R> type, final Throwable cause) {
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw cause;
                }
            };
            return (R)((Remote)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, handler));
        }

        @Override
        public int finished(InvocationChannel channel, boolean reset) {
            try {
                channel.getOutputStream().flush();
                if (reset) {
                    channel.getOutputStream().reset();
                }
                return 1;
            }
            catch (IOException e) {
                channel.disconnect();
                return 0;
            }
        }

        @Override
        public void finishedAsync(InvocationChannel channel) {
            this.finishedAsync(channel, false);
        }

        void finishedAsync(InvocationChannel channel, boolean inputResume) {
            try {
                if (inputResume) {
                    StandardSession.this.resumeAndReadRequestAsync(channel);
                } else {
                    StandardSession.this.listenForRequestAsync(channel);
                }
            }
            catch (RejectedException e) {
                StandardSession.this.closeDueToRejection(channel, e);
            }
        }

        @Override
        public int finished(InvocationChannel channel, Throwable cause) {
            try {
                channel.getOutputStream().writeThrowable(cause);
                return this.finished(channel, true);
            }
            catch (IOException e) {
                channel.disconnect();
                return 0;
            }
        }

        @Override
        public void uncaughtException(Throwable cause) {
            StandardSession.this.uncaughtException(cause);
        }

        @Override
        public OrderedInvoker createOrderedInvoker() {
            return new OrderedInvoker(StandardSession.this);
        }

        @Override
        public void dispose(VersionedIdentifier objId) {
            StandardSession.this.disposeSkeleton(objId);
        }
    }

    private class ReplacingObjectOutputStream
    extends DrainableObjectOutputStream {
        ReplacingObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected void writeStreamHeader() {
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            Remote ref = StandardSession.this.mDescriptorCache.toReference(desc);
            if (ref == null) {
                this.write(0);
                super.writeClassDescriptor(desc);
            } else {
                this.write(1);
                VersionedIdentifier.identify(ref).writeWithNextVersion(this);
            }
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Remote && !(obj instanceof Serializable)) {
                Class<Remote> remoteType;
                Remote remote = (Remote)obj;
                VersionedIdentifier objId = VersionedIdentifier.identify(remote);
                try {
                    remoteType = RemoteIntrospector.getRemoteType(remote);
                }
                catch (IllegalArgumentException e) {
                    return new MarshalledIntrospectionFailure(e.getMessage(), obj.getClass().getName());
                }
                VersionedIdentifier typeId = VersionedIdentifier.identify(remoteType);
                RemoteInfo info = null;
                if (!StandardSession.this.mStubRefs.containsKey(objId) && !StandardSession.this.mSkeletons.containsKey(objId)) {
                    Skeleton<Remote> skeleton;
                    SkeletonFactory<Remote> factory = (SkeletonFactory<Remote>)StandardSession.this.mSkeletonFactories.get(typeId);
                    if (factory == null) {
                        try {
                            factory = SkeletonFactoryGenerator.getSkeletonFactory(remoteType);
                        }
                        catch (IllegalArgumentException e) {
                            return new MarshalledIntrospectionFailure(e.getMessage(), remoteType);
                        }
                        SkeletonFactory<Remote> existing = StandardSession.this.mSkeletonFactories.putIfAbsent(typeId, factory);
                        if (existing != null && existing != factory) {
                            factory = existing;
                        } else {
                            info = RemoteIntrospector.examine(remoteType);
                        }
                    }
                    if (!StandardSession.this.addSkeleton(objId, skeleton = factory.createSkeleton(objId, StandardSession.this.mSkeletonSupport, remote))) {
                        throw new ClosedException("Session is closed");
                    }
                }
                obj = new MarshalledRemote(objId, typeId, info);
            }
            return obj;
        }
    }

    private class ResolvingObjectInputStream
    extends ObjectInputStream {
        ResolvingObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        @Override
        protected void readStreamHeader() {
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            byte type = this.readByte();
            if (type == 0) {
                ObjectStreamClass desc = super.readClassDescriptor();
                StandardSession.this.mDescriptorCache.requestReference(desc);
                return desc;
            }
            VersionedIdentifier refId = VersionedIdentifier.read(this);
            int refVersion = this.readInt();
            Remote ref = StandardSession.this.findIdentifiedRemote(refId);
            refId.updateRemoteVersion(refVersion);
            if (ref == null && StandardSession.this.isClosing()) {
                throw new ClosedException("Session is closed");
            }
            assert (ref != null);
            return StandardSession.this.mDescriptorCache.toDescriptor(ref);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            if (name.length() == 0) {
                return super.resolveClass(desc);
            }
            TypeDesc type = name.charAt(0) == '[' ? TypeDesc.forDescriptor((String)name) : TypeDesc.forClass((String)name);
            if (type.isPrimitive()) {
                return type.toClass();
            }
            if (type.isArray()) {
                TypeDesc root = type.getRootComponentType();
                if (root.isPrimitive()) {
                    return type.toClass();
                }
                int dims = type.getDimensions();
                type = TypeDesc.forClass(StandardSession.this.mTypeResolver.resolveClass(root.getRootName(), StandardSession.this.mRemoteAdmin));
                while (--dims >= 0) {
                    type = type.toArrayType();
                }
                return type.toClass();
            }
            return StandardSession.this.mTypeResolver.resolveClass(name, StandardSession.this.mRemoteAdmin);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof Marshalled) {
                if (obj instanceof MarshalledIntrospectionFailure) {
                    throw ((MarshalledIntrospectionFailure)obj).toException();
                }
                MarshalledRemote mr = (MarshalledRemote)obj;
                VersionedIdentifier objId = mr.mObjId;
                Remote remote = StandardSession.this.findIdentifiedRemote(objId);
                if (remote != null) {
                    mr.updateRemoteVersions();
                    return remote;
                }
                VersionedIdentifier typeId = mr.mTypeId;
                StubFactory<?> factory = StandardSession.this.mStubFactories.get(typeId);
                if (factory == null) {
                    Class<?> type;
                    StubFactory<?> existing;
                    RemoteInfo info = mr.mInfo;
                    if (info == null) {
                        info = StandardSession.this.mRemoteAdmin.getRemoteInfo(typeId);
                    }
                    if ((existing = StandardSession.register(StandardSession.this.mStubFactories, typeId, factory = StubFactoryGenerator.getStubFactory(type = StandardSession.this.mTypeResolver.resolveRemoteType(info), info))) == factory) {
                        StandardSession.this.mStubFactoryRefs.put(typeId, new StubFactoryRef(factory, StandardSession.this.mReferenceQueue, typeId));
                    } else {
                        factory = existing;
                    }
                }
                mr.updateRemoteVersions();
                return StandardSession.this.createAndRegisterStub(objId, factory, new StubSupportImpl(objId));
            }
            return obj;
        }
    }

    private final class InvocationChan
    extends AbstractInvocationChannel {
        private final Channel mChannel;
        private volatile int mTimestamp;
        volatile Future<?> mTimeoutTask;

        InvocationChan(Channel channel) throws IOException {
            super(new ResolvingObjectInputStream(channel.getInputStream()), new ReplacingObjectOutputStream(channel.getOutputStream()));
            this.mChannel = channel;
        }

        InvocationChan(InvocationChan chan) throws IOException {
            super(chan, new ResolvingObjectInputStream(chan.mChannel.getInputStream()));
            this.mChannel = chan.mChannel;
        }

        @Override
        public boolean isInputReady() throws IOException {
            return this.mChannel.isInputReady() || this.mInvIn.available() > 0;
        }

        @Override
        public boolean isOutputReady() throws IOException {
            return this.mChannel.isOutputReady();
        }

        @Override
        public int setInputBufferSize(int size) {
            return this.mChannel.setInputBufferSize(size);
        }

        @Override
        public int setOutputBufferSize(int size) {
            return this.mChannel.setOutputBufferSize(size);
        }

        @Override
        public void inputNotify(Channel.Listener listener) {
            this.mChannel.inputNotify(listener);
        }

        @Override
        public void outputNotify(Channel.Listener listener) {
            this.mChannel.outputNotify(listener);
        }

        @Override
        public boolean usesSelectNotification() {
            return this.mChannel.usesSelectNotification();
        }

        @Override
        public boolean inputResume() {
            return this.mChannel.inputResume();
        }

        @Override
        public boolean isResumeSupported() {
            return this.mChannel.isResumeSupported();
        }

        boolean inputResume(int timeout, TimeUnit unit) throws IOException {
            if (this.inputResume()) {
                return true;
            }
            this.startTimeout(timeout, unit);
            return this.read() < 0 && this.cancelTimeout() && this.inputResume();
        }

        @Override
        public boolean outputSuspend() throws IOException {
            this.mInvOut.doDrain();
            return this.mChannel.outputSuspend();
        }

        @Override
        public void register(CloseableGroup<? super Channel> group) {
            this.mChannel.register(group);
        }

        @Override
        public boolean isClosed() {
            return this.mChannel.isClosed();
        }

        @Override
        public void close() throws IOException {
            IOException exception;
            boolean wasOpen;
            block8: {
                block7: {
                    wasOpen = this.replaceTimeout(null, 0L, null) > 0;
                    exception = null;
                    try {
                        this.mInvOut.doDrain();
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    try {
                        this.mInvIn.doClose();
                    }
                    catch (IOException e) {
                        if (exception != null) break block7;
                        exception = e;
                    }
                }
                try {
                    this.mChannel.close();
                }
                catch (IOException e) {
                    if (exception != null) break block8;
                    exception = e;
                }
            }
            if (wasOpen && exception != null) {
                this.mChannel.disconnect();
                throw exception;
            }
        }

        @Override
        public void disconnect() {
            this.cancelTimeout();
            this.mChannel.disconnect();
        }

        @Override
        public Object getLocalAddress() {
            return this.mChannel.getLocalAddress();
        }

        @Override
        public Object getRemoteAddress() {
            return this.mChannel.getRemoteAddress();
        }

        @Override
        public Remote installRecycler(Channel.Recycler recycler) {
            return null;
        }

        @Override
        public void setRecycleControl(Remote control) {
        }

        @Override
        public Throwable readThrowable() throws IOException, ReconstructedException {
            return this.getInputStream().readThrowable();
        }

        @Override
        public void writeThrowable(Throwable t) throws IOException {
            this.getOutputStream().writeThrowable(t);
        }

        @Override
        public boolean startTimeout(long timeout, TimeUnit unit) throws IOException {
            TimeoutTask task;
            TimeoutTask timeoutTask = task = new TimeoutTask();
            synchronized (timeoutTask) {
                try {
                    return this.replaceTimeout(task, timeout, unit) > 0;
                }
                catch (RejectedException e) {
                    throw new RejectedException("Unable to schedule timeout", e);
                }
            }
        }

        @Override
        public boolean cancelTimeout() {
            try {
                return this.replaceTimeout(null, 0L, null) != 0;
            }
            catch (RejectedException e) {
                return false;
            }
        }

        private int replaceTimeout(TimeoutTask task, long timeout, TimeUnit unit) throws RejectedException {
            Future<?> existingTask;
            ScheduledFuture<?> futureTask = null;
            do {
                if (futureTask != null) {
                    futureTask.cancel(false);
                    futureTask = null;
                    task.setFuture(null);
                }
                if ((existingTask = this.mTimeoutTask) != null) {
                    existingTask.cancel(false);
                    if (existingTask == timedOut) {
                        return 0;
                    }
                }
                if (this.isClosed()) {
                    return -1;
                }
                if (task == null) continue;
                futureTask = StandardSession.this.mExecutor.schedule(task, timeout, unit);
                task.setFuture(futureTask);
            } while (!timeoutTaskUpdater.compareAndSet(this, existingTask, futureTask));
            return 1;
        }

        void timedOut(Future<?> expect) {
            if (timeoutTaskUpdater.compareAndSet(this, expect, timedOut)) {
                this.mChannel.disconnect();
            }
        }

        public String toString() {
            String hashCode = Integer.toHexString(this.hashCode());
            return "Pipe@" + hashCode + " {localAddress=" + this.mChannel.getLocalAddress() + ", remoteAddress=" + this.mChannel.getRemoteAddress() + '}';
        }

        void recycle() {
            try {
                if (StandardSession.this.isClosing()) {
                    this.discard();
                } else {
                    this.getOutputStream().reset();
                    this.addToPool();
                }
            }
            catch (Exception e) {
                this.disconnect();
            }
        }

        void inputResumeAndRecycle() {
            if (StandardSession.this.isClosing()) {
                this.disconnect();
                return;
            }
            if (this.inputResume()) {
                try {
                    new InvocationChan(this).addToPool();
                }
                catch (IOException e) {
                    this.disconnect();
                }
                return;
            }
            if (!this.isResumeSupported()) {
                this.disconnect();
                return;
            }
            try {
                StandardSession.this.mExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (InvocationChan.this.inputResume(1, TimeUnit.SECONDS) && !StandardSession.this.isClosing()) {
                                new InvocationChan(InvocationChan.this).addToPool();
                                return;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        InvocationChan.this.disconnect();
                    }
                });
            }
            catch (RejectedException e) {
                this.disconnect();
            }
        }

        void discard() {
            try {
                this.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                this.disconnect();
            }
        }

        int getIdleTimestamp() {
            return this.mTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addToPool() {
            this.mTimestamp = StandardSession.this.mClockSeconds;
            LinkedList<InvocationChan> linkedList = StandardSession.this.mChannelPool;
            synchronized (linkedList) {
                StandardSession.this.mChannelPool.add(this);
            }
        }

        private class TimeoutTask
        extends ScheduledTask<RuntimeException> {
            private Future<?> mMyFuture;

            private TimeoutTask() {
            }

            @Override
            protected synchronized void doRun() {
                Future<?> myFuture = this.mMyFuture;
                if (myFuture != null) {
                    InvocationChan.this.timedOut(myFuture);
                }
            }

            synchronized void setFuture(Future<?> future) {
                this.mMyFuture = future;
            }
        }
    }

    private class Handler
    implements ChannelAcceptor.Listener {
        private Handler() {
        }

        @Override
        public void accepted(Channel channel) {
            InvocationChan invChan;
            StandardSession.this.mBroker.accept(this);
            try {
                invChan = StandardSession.this.toInvocationChannel(channel, true);
            }
            catch (IOException e) {
                this.failed(e);
                return;
            }
            StandardSession.this.readRequest(invChan);
        }

        @Override
        public void rejected(RejectedException e) {
        }

        @Override
        public void failed(IOException e) {
        }

        @Override
        public void closed(IOException e) {
            if (!StandardSession.this.isClosing()) {
                StandardSession.this.closeOnFailure(e.getMessage(), e);
            }
        }
    }

    private class BackgroundTask
    extends ScheduledTask<RuntimeException> {
        private int mFailedToDisposeCount;

        private BackgroundTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            block19: {
                suppressPingUpdater.compareAndSet(StandardSession.this, 1, 0);
                try {
                    StandardSession.this.sendDisposedStubs();
                    this.mFailedToDisposeCount = 0;
                }
                catch (RemoteException e) {
                    ++this.mFailedToDisposeCount;
                    if (this.mFailedToDisposeCount <= 2 || StandardSession.this.isClosing()) break block19;
                    StandardSession.this.uncaughtException(e);
                }
            }
            ArrayList<InvocationChannel> released = null;
            LinkedList<InvocationChan> linkedList = StandardSession.this.mHeldChannelMap;
            synchronized (linkedList) {
                Iterator<Map.Entry<InvocationChannel, Thread>> it = StandardSession.this.mHeldChannelMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<InvocationChannel, Thread> entry = it.next();
                    if (entry.getValue().isAlive()) continue;
                    InvocationChannel channel = entry.getKey();
                    if (released == null) {
                        released = new ArrayList<InvocationChannel>();
                    }
                    released.add(channel);
                    it.remove();
                }
            }
            if (released != null) {
                for (InvocationChannel channel : released) {
                    if (channel instanceof InvocationChan) {
                        ((InvocationChan)channel).recycle();
                        continue;
                    }
                    channel.disconnect();
                }
            }
            while (true) {
                InvocationChan pooledChannel;
                linkedList = StandardSession.this.mChannelPool;
                synchronized (linkedList) {
                    pooledChannel = StandardSession.this.mChannelPool.peek();
                    if (pooledChannel == null) {
                        break;
                    }
                    int age = StandardSession.this.mClockSeconds - pooledChannel.getIdleTimestamp();
                    if (age < 60) {
                        break;
                    }
                    StandardSession.this.mChannelPool.remove();
                }
                pooledChannel.discard();
            }
            if (StandardSession.this.mStubRefs.size() <= 1 && StandardSession.this.mSkeletons.size() <= 1 && (StandardSession.this.mCloseState & 3) != 0) {
                try {
                    StandardSession.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class AdminImpl
    implements Hidden.Admin {
        private AdminImpl() {
        }

        @Override
        public Object sessionDequeue(RemoteCompletion<Object> callback) {
            return StandardSession.this.mSessionExchanger.dequeue(callback);
        }

        @Override
        public RemoteInfo getRemoteInfo(VersionedIdentifier typeId) throws NoSuchClassException {
            Class remoteType = (Class)typeId.tryRetrieve();
            if (remoteType == null) {
                throw new NoSuchClassException("No Class found for id: " + typeId);
            }
            return RemoteIntrospector.examine(remoteType);
        }

        @Override
        public RemoteInfo getRemoteInfo(Identifier typeId) throws NoSuchClassException {
            Class remoteType = (Class)typeId.tryRetrieve();
            if (remoteType == null) {
                throw new NoSuchClassException("No Class found for id: " + typeId);
            }
            return RemoteIntrospector.examine(remoteType);
        }

        @Override
        public String getUnknownClassInfo(String name) {
            String supers;
            char type;
            long serialVersionUID;
            Class<?> clazz;
            try {
                clazz = StandardSession.this.mTypeResolver.resolveClass(name);
            }
            catch (IOException e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (clazz == null) {
                return null;
            }
            ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
            if (osc == null) {
                serialVersionUID = 0L;
                type = 'N';
                supers = this.supersFor(clazz, null, null);
            } else {
                serialVersionUID = osc.getSerialVersionUID();
                if (Enum.class.isAssignableFrom(clazz)) {
                    type = 'U';
                    supers = this.supersFor(clazz, Enum.class, Comparable.class, Serializable.class);
                } else if (Externalizable.class.isAssignableFrom(clazz)) {
                    type = 'E';
                    supers = this.supersFor(clazz, null, Externalizable.class, Serializable.class);
                } else {
                    type = 'S';
                    supers = this.supersFor(clazz, null, Serializable.class);
                }
            }
            StringBuilder b = new StringBuilder();
            b.append(serialVersionUID).append(':').append(type);
            if (supers != null) {
                b.append(':');
                b.append(supers);
            }
            return b.toString();
        }

        private String supersFor(Class clazz, Class<?> impliedSuper, Class ... impliedInterfaces) {
            StringBuilder b = new StringBuilder();
            Class superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class && superclass != impliedSuper) {
                b.append(TypeDesc.forClass(superclass).getDescriptor());
            }
            b.append(':');
            block0: for (Class<?> iface : clazz.getInterfaces()) {
                if (impliedInterfaces != null) {
                    for (Class implied : impliedInterfaces) {
                        if (iface == implied) continue block0;
                    }
                }
                b.append(TypeDesc.forClass(iface).getDescriptor());
            }
            return b.length() <= 1 ? null : b.toString();
        }

        @Override
        public void disposed(VersionedIdentifier[] ids, int[] remoteVersions, int[] localVersions) {
            if (ids != null) {
                int waits = 0;
                for (int i = 0; i < ids.length; ++i) {
                    waits = this.dispose(ids[i], remoteVersions[i], localVersions[i], waits);
                }
            }
        }

        private int dispose(VersionedIdentifier id, int remoteVersion, int localVersion, int waits) {
            int currentRemoteVersion;
            if (id.localVersion() != localVersion) {
                return waits;
            }
            while ((currentRemoteVersion = id.remoteVersion()) != remoteVersion) {
                if (currentRemoteVersion - remoteVersion > 0) {
                    return waits;
                }
                if (StandardSession.this.isClosing() || waits > 100) break;
                try {
                    Thread.sleep(100L);
                    ++waits;
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            StandardSession.this.mSkeletonFactories.remove(id);
            Skeleton skeleton = (Skeleton)StandardSession.this.mSkeletons.remove(id);
            if (skeleton != null) {
                StandardSession.this.unreferenced(skeleton);
            }
            return waits;
        }

        @Override
        public void linkDescriptorCache(Remote link) {
            StandardSession.this.mDescriptorCache.link(link);
        }

        @Override
        public void linkDescriptorCache(Remote link, @TimeoutParam long timeout, TimeUnit unit) {
            StandardSession.this.mDescriptorCache.link(link);
        }

        @Override
        public void ping() {
        }

        @Override
        public void sessionUnreferenced() {
            StandardSession.this.setCloseState(1);
        }

        @Override
        public void closedExplicitly() {
            StandardSession.this.peerClosed("by remote endpoint");
        }

        @Override
        public void closedOnFailure(String message, Throwable exception) {
            String prefix = "by remote endpoint due to unexpected failure";
            message = message == null ? prefix : prefix + ": " + message;
            StandardSession.this.peerClosed(message);
        }
    }

    static class Hidden {
        Hidden() {
        }

        public static interface Admin
        extends Remote {
            public Object sessionDequeue(RemoteCompletion<Object> var1) throws RemoteException;

            @Unbatched
            public RemoteInfo getRemoteInfo(VersionedIdentifier var1) throws RemoteException;

            @Unbatched
            public RemoteInfo getRemoteInfo(Identifier var1) throws RemoteException;

            @Unbatched
            public String getUnknownClassInfo(String var1) throws RemoteException;

            public void disposed(VersionedIdentifier[] var1, int[] var2, int[] var3) throws RemoteException;

            public void linkDescriptorCache(Remote var1) throws RemoteException;

            public void linkDescriptorCache(Remote var1, @TimeoutParam long var2, TimeUnit var4) throws RemoteException;

            @Timeout(value=5000L)
            public void ping() throws RemoteException;

            @Asynchronous
            @Timeout(value=10000L)
            public void sessionUnreferenced() throws RemoteException;

            @Timeout(value=1000L)
            public void closedExplicitly() throws RemoteException;

            @Asynchronous
            @Timeout(value=1000L)
            public void closedOnFailure(String var1, Throwable var2) throws RemoteException;
        }
    }

    private static class StubRef
    extends Ref<Remote> {
        private final StubSupportImpl mStubSupport;

        StubRef(Remote stub, ReferenceQueue queue, StubSupportImpl support) {
            super(stub, queue);
            this.mStubSupport = support;
        }

        @Override
        protected VersionedIdentifier unreachable() {
            return this.mStubSupport.unreachable();
        }
    }

    private class StubFactoryRef
    extends Ref<StubFactory> {
        private final VersionedIdentifier mTypeId;

        StubFactoryRef(StubFactory factory, ReferenceQueue queue, VersionedIdentifier typeId) {
            super(factory, queue);
            this.mTypeId = typeId;
        }

        @Override
        protected VersionedIdentifier unreachable() {
            return StandardSession.this.mStubFactoryRefs.remove(this.mTypeId) == null ? null : this.mTypeId;
        }
    }

    private static abstract class Ref<T>
    extends PhantomReference<T> {
        public Ref(T referent, ReferenceQueue queue) {
            super(referent, queue);
        }

        protected abstract VersionedIdentifier unreachable();
    }
}

