/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.IOException;
import org.cojen.dirmi.Environment;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.Session;
import org.cojen.dirmi.SessionAcceptor;
import org.cojen.dirmi.SessionListener;
import org.cojen.dirmi.io.ChannelBroker;
import org.cojen.dirmi.io.ChannelBrokerAcceptor;

public class StandardSessionAcceptor
implements SessionAcceptor {
    final Environment mEnv;
    final ChannelBrokerAcceptor mBrokerAcceptor;
    private Auto mAuto;

    public static SessionAcceptor create(Environment environment, ChannelBrokerAcceptor brokerAcceptor) {
        return new StandardSessionAcceptor(environment, brokerAcceptor);
    }

    private StandardSessionAcceptor(Environment environment, ChannelBrokerAcceptor brokerAcceptor) {
        this.mEnv = environment;
        this.mBrokerAcceptor = brokerAcceptor;
    }

    @Override
    public Object getLocalAddress() {
        return this.mBrokerAcceptor.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(SessionListener listener) {
        StandardSessionAcceptor standardSessionAcceptor = this;
        synchronized (standardSessionAcceptor) {
            if (this.mAuto != null) {
                this.mAuto.disabled = true;
                this.mAuto = null;
            }
            if (listener != null) {
                this.mBrokerAcceptor.accept(new Manual(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptAll(Object shared) {
        StandardSessionAcceptor standardSessionAcceptor = this;
        synchronized (standardSessionAcceptor) {
            if (this.mAuto != null) {
                this.mAuto.disabled = true;
            }
            this.mAuto = new Auto(shared);
            this.mBrokerAcceptor.accept(this.mAuto);
        }
    }

    @Override
    public void close() throws IOException {
        this.mBrokerAcceptor.close();
    }

    public String toString() {
        return "SessionAcceptor {localAddress=" + this.getLocalAddress() + '}';
    }

    void uncaught(Throwable e) {
        Thread t = Thread.currentThread();
        try {
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread.yield();
    }

    private class Auto
    implements ChannelBrokerAcceptor.Listener {
        private final Object mShared;
        volatile boolean disabled;
        private volatile boolean mAnyAccepted;

        Auto(Object shared) {
            this.mShared = shared;
        }

        @Override
        public void accepted(ChannelBroker broker) {
            Session session;
            this.mAnyAccepted = true;
            if (!this.disabled) {
                StandardSessionAcceptor.this.mBrokerAcceptor.accept(this);
            }
            try {
                session = StandardSessionAcceptor.this.mEnv.newSession(broker);
            }
            catch (IOException cause) {
                broker.close();
                return;
            }
            try {
                session.send(this.mShared);
            }
            catch (IOException e) {
                try {
                    session.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }

        @Override
        public void rejected(RejectedException cause) {
            if (!this.disabled && !cause.isShutdown()) {
                StandardSessionAcceptor.this.mBrokerAcceptor.accept(this);
            }
        }

        @Override
        public void failed(IOException cause) {
            if (!this.disabled) {
                StandardSessionAcceptor.this.mBrokerAcceptor.accept(this);
            }
        }

        @Override
        public void closed(IOException cause) {
            if (!this.mAnyAccepted) {
                StandardSessionAcceptor.this.uncaught(cause);
            }
        }
    }

    private class Manual
    implements ChannelBrokerAcceptor.Listener {
        private final SessionListener mListener;

        Manual(SessionListener listener) {
            this.mListener = listener;
        }

        @Override
        public void accepted(ChannelBroker broker) {
            Session session;
            try {
                session = StandardSessionAcceptor.this.mEnv.newSession(broker);
            }
            catch (IOException cause) {
                broker.close();
                try {
                    this.mListener.establishFailed(cause);
                }
                catch (Throwable e) {
                    StandardSessionAcceptor.this.uncaught(e);
                }
                return;
            }
            try {
                this.mListener.established(session);
            }
            catch (Throwable e) {
                try {
                    session.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                StandardSessionAcceptor.this.uncaught(e);
            }
        }

        @Override
        public void rejected(RejectedException cause) {
            try {
                if (cause.isShutdown()) {
                    this.mListener.acceptFailed(cause);
                } else {
                    this.mListener.establishFailed(cause);
                }
            }
            catch (Throwable e) {
                StandardSessionAcceptor.this.uncaught(e);
            }
        }

        @Override
        public void failed(IOException cause) {
            try {
                this.mListener.establishFailed(cause);
            }
            catch (Throwable e) {
                StandardSessionAcceptor.this.uncaught(e);
            }
        }

        @Override
        public void closed(IOException cause) {
            try {
                this.mListener.acceptFailed(cause);
            }
            catch (Throwable e) {
                StandardSessionAcceptor.this.uncaught(e);
            }
        }
    }
}

