/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.CallMode;
import org.cojen.dirmi.Completion;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.Trace;
import org.cojen.dirmi.core.CodeBuilderUtil;
import org.cojen.dirmi.core.Stub;
import org.cojen.dirmi.core.StubFactory;
import org.cojen.dirmi.core.StubSupport;
import org.cojen.dirmi.info.RemoteInfo;
import org.cojen.dirmi.info.RemoteIntrospector;
import org.cojen.dirmi.info.RemoteMethod;
import org.cojen.dirmi.info.RemoteParameter;
import org.cojen.dirmi.util.Cache;
import org.cojen.util.AnnotationBuilder;
import org.cojen.util.KeyFactory;

public class StubFactoryGenerator<R extends Remote> {
    private static final String STUB_SUPPORT_NAME = "support";
    private static final String SEQUENCE_NAME = "sequence";
    private static final String SEQUENCE_UPDATER_NAME = "sequenceUpdater";
    private static final Cache<Object, StubFactory<?>> cCache = Cache.newSoftValueCache(17);
    private final Class<R> mType;
    private final RemoteInfo mLocalInfo;
    private final RemoteInfo mRemoteInfo;
    private final AtomicReference<Object> mFactoryRef = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Remote> StubFactory<R> getStubFactory(Class<R> type, RemoteInfo remoteInfo) throws IllegalArgumentException {
        Object key = KeyFactory.createKey((Object[])new Object[]{type, remoteInfo.getInfoId()});
        Cache<Object, StubFactory<?>> cache = cCache;
        synchronized (cache) {
            StubFactory<Object> factory = cCache.get(key);
            if (factory == null) {
                factory = super.generateFactory();
                cCache.put(key, factory);
            }
            return factory;
        }
    }

    private StubFactoryGenerator(Class<R> type, RemoteInfo remoteInfo) {
        this.mType = type;
        this.mLocalInfo = RemoteIntrospector.examine(type);
        if (remoteInfo == null) {
            remoteInfo = this.mLocalInfo;
        }
        this.mRemoteInfo = remoteInfo;
    }

    private StubFactory<R> generateFactory() {
        return (StubFactory)AccessController.doPrivileged(new PrivilegedAction<StubFactory<R>>(){

            @Override
            public StubFactory<R> run() {
                Class stubClass = StubFactoryGenerator.this.generateStub();
                try {
                    Factory factory = new Factory(stubClass.getConstructor(StubSupport.class));
                    StubFactoryGenerator.this.mFactoryRef.set(factory);
                    return factory;
                }
                catch (NoSuchMethodException e) {
                    NoSuchMethodError nsme = new NoSuchMethodError();
                    nsme.initCause(e);
                    throw nsme;
                }
            }
        });
    }

    private Class<? extends R> generateStub() {
        TypeDesc exceptionDescs;
        MethodInfo mi;
        RuntimeClassFile cf = CodeBuilderUtil.createRuntimeClassFile(this.mRemoteInfo.getName() + "$Stub", this.mType.getClassLoader());
        cf.addInterface(this.mType);
        cf.addInterface(Stub.class);
        cf.setSourceFile(StubFactoryGenerator.class.getName());
        cf.markSynthetic();
        cf.setTarget("1.5");
        CodeBuilder staticInitBuilder = CodeBuilderUtil.addStaticFactoryRefUnfinished((ClassFile)cf, this.mFactoryRef);
        MethodInfo mi2 = cf.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{CodeBuilderUtil.STUB_SUPPORT_TYPE});
        CodeBuilder b = new CodeBuilder(mi2);
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.storeField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        b.returnVoid();
        boolean generatedSequenceFields = false;
        boolean hasDisposer = false;
        for (RemoteMethod remoteMethod : this.mRemoteInfo.getRemoteMethods()) {
            Label invokeEnd;
            TypeDesc remoteFailureExType;
            Trace trace;
            RemoteMethod localMethod;
            TypeDesc returnDesc = CodeBuilderUtil.getTypeDesc(remoteMethod.getReturnType());
            TypeDesc[] paramDescs = CodeBuilderUtil.getTypeDescs(remoteMethod.getParameterTypes());
            if (!CodeBuilderUtil.isKnownType(this.mType.getClassLoader(), returnDesc) || !CodeBuilderUtil.isKnownTypes(this.mType.getClassLoader(), paramDescs)) continue;
            hasDisposer |= remoteMethod.isDisposer();
            RemoteParameter[] params = remoteMethod.getParameterTypes().toArray(new RemoteParameter[remoteMethod.getParameterTypes().size()]);
            try {
                localMethod = this.mLocalInfo.getRemoteMethod(remoteMethod.getName(), params);
            }
            catch (NoSuchMethodException e) {
                localMethod = null;
            }
            mi = cf.addMethod(Modifiers.PUBLIC, remoteMethod.getName(), returnDesc, paramDescs);
            if (localMethod != null && (trace = localMethod.getTraceAnnotation()) != null) {
                new AnnotationBuilder().visit((Annotation)trace, (Object)mi.addRuntimeVisibleAnnotation(TypeDesc.forClass(Trace.class)));
            }
            for (TypeDesc desc : exceptionDescs = CodeBuilderUtil.getTypeDescs(remoteMethod.getExceptionTypes())) {
                if (!CodeBuilderUtil.isKnownType(this.mType.getClassLoader(), desc)) continue;
                mi.addException(desc);
            }
            if (localMethod != null) {
                remoteFailureExType = TypeDesc.forClass(localMethod.getRemoteFailureException().getType());
            } else {
                remoteFailureExType = TypeDesc.forClass(remoteMethod.getRemoteFailureException().getType());
                if (!CodeBuilderUtil.isKnownType(this.mType.getClassLoader(), remoteFailureExType)) {
                    remoteFailureExType = TypeDesc.forClass(Remote.class);
                }
            }
            CodeBuilder b2 = new CodeBuilder(mi);
            long timeout = remoteMethod.getTimeout();
            TimeUnit timeoutUnit = remoteMethod.getTimeoutUnit();
            TypeDesc timeoutType = TypeDesc.LONG;
            LocalVariable timeoutVar = null;
            LocalVariable timeoutUnitVar = null;
            int i = 0;
            for (RemoteParameter<?> paramType : remoteMethod.getParameterTypes()) {
                if (paramType.isTimeout()) {
                    timeoutVar = b2.getParameter(i);
                    TypeDesc desc = timeoutVar.getType().toPrimitiveType();
                    if (desc == TypeDesc.FLOAT || desc == TypeDesc.DOUBLE) {
                        timeoutType = TypeDesc.DOUBLE;
                    }
                } else if (paramType.isTimeoutUnit()) {
                    timeoutUnitVar = b2.getParameter(i);
                }
                ++i;
            }
            boolean noTimeout = timeout < 0L && timeoutVar == null;
            LocalVariable originalTimeoutVar = timeoutVar;
            LocalVariable supportVar = b2.createLocalVariable(null, CodeBuilderUtil.STUB_SUPPORT_TYPE);
            b2.loadThis();
            b2.loadField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
            b2.storeLocal(supportVar);
            if (remoteMethod.isDisposer()) {
                b2.loadThis();
                b2.loadLocal(supportVar);
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "dispose", CodeBuilderUtil.STUB_SUPPORT_TYPE, null);
                b2.storeField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
            }
            LocalVariable batchedChannelVar = null;
            if (remoteMethod.isUnbatched()) {
                b2.loadLocal(supportVar);
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "unbatch", CodeBuilderUtil.INV_CHANNEL_TYPE, null);
                batchedChannelVar = b2.createLocalVariable(null, CodeBuilderUtil.INV_CHANNEL_TYPE);
                b2.storeLocal(batchedChannelVar);
            }
            b2.loadLocal(supportVar);
            b2.loadConstant(remoteFailureExType);
            if (noTimeout) {
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "invoke", CodeBuilderUtil.INV_CHANNEL_TYPE, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE});
            } else {
                timeoutVar = this.genLoadTimeoutVars(b2, true, timeout, timeoutUnit, timeoutType, timeoutVar, timeoutUnitVar);
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "invoke", CodeBuilderUtil.INV_CHANNEL_TYPE, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, timeoutType, CodeBuilderUtil.TIME_UNIT_TYPE});
            }
            LocalVariable channelVar = b2.createLocalVariable(null, CodeBuilderUtil.INV_CHANNEL_TYPE);
            b2.storeLocal(channelVar);
            LocalVariable compVar = null;
            if (remoteMethod.isAsynchronous() && returnDesc != null && (Future.class == returnDesc.toClass() || Completion.class == returnDesc.toClass())) {
                compVar = b2.createLocalVariable(null, TypeDesc.forClass(Completion.class));
                b2.loadLocal(supportVar);
                b2.loadThis();
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "createCompletion", compVar.getType(), new TypeDesc[]{TypeDesc.OBJECT});
                b2.storeLocal(compVar);
            }
            Label invokeStart = b2.createLabel().setLocation();
            b2.loadLocal(channelVar);
            b2.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getOutputStream", CodeBuilderUtil.INV_OUT_TYPE, null);
            LocalVariable invOutVar = b2.createLocalVariable(null, CodeBuilderUtil.INV_OUT_TYPE);
            b2.storeLocal(invOutVar);
            b2.loadLocal(invOutVar);
            b2.loadConstant(remoteMethod.getMethodId());
            b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "writeInt", null, new TypeDesc[]{TypeDesc.INT});
            if (remoteMethod.isOrdered()) {
                TypeDesc updaterType = TypeDesc.forClass(AtomicIntegerFieldUpdater.class);
                if (!generatedSequenceFields) {
                    generatedSequenceFields = true;
                    cf.addField(Modifiers.PRIVATE.toVolatile(true), SEQUENCE_NAME, TypeDesc.INT);
                    cf.addField(Modifiers.PRIVATE.toStatic(true).toFinal(true), SEQUENCE_UPDATER_NAME, updaterType);
                    staticInitBuilder.loadConstant(cf.getType());
                    staticInitBuilder.loadConstant(SEQUENCE_NAME);
                    staticInitBuilder.invokeStatic(updaterType, "newUpdater", updaterType, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, TypeDesc.STRING});
                    staticInitBuilder.storeStaticField(SEQUENCE_UPDATER_NAME, updaterType);
                }
                b2.loadLocal(invOutVar);
                b2.loadStaticField(SEQUENCE_UPDATER_NAME, updaterType);
                b2.loadThis();
                b2.invokeVirtual(updaterType, "incrementAndGet", TypeDesc.INT, new TypeDesc[]{TypeDesc.OBJECT});
                b2.invokeVirtual(invOutVar.getType(), "writeInt", null, new TypeDesc[]{TypeDesc.INT});
            }
            if (compVar != null) {
                b2.loadLocal(invOutVar);
                b2.loadLocal(compVar);
                b2.invokeVirtual(invOutVar.getType(), "writeUnshared", null, new TypeDesc[]{TypeDesc.OBJECT});
            }
            boolean returnPipe = false;
            boolean anySharedParam = false;
            if (paramDescs.length > 0) {
                boolean lookForPipe = remoteMethod.isAsynchronous() && returnDesc != null && Pipe.class == returnDesc.toClass();
                int i2 = 0;
                for (RemoteParameter<?> paramType : remoteMethod.getParameterTypes()) {
                    if (lookForPipe && Pipe.class == paramType.getType()) {
                        returnPipe = true;
                        lookForPipe = false;
                    } else {
                        LocalVariable param = b2.getParameter(i2);
                        if (param == originalTimeoutVar) {
                            param = timeoutVar;
                        }
                        anySharedParam |= CodeBuilderUtil.writeParam(b2, paramType, invOutVar, param);
                    }
                    ++i2;
                }
            }
            if (!remoteMethod.isAsynchronous() || remoteMethod.getAsynchronousCallMode() == CallMode.IMMEDIATE || remoteMethod.getAsynchronousCallMode() == CallMode.ACKNOWLEDGED || !returnPipe && remoteMethod.getAsynchronousCallMode() == CallMode.REQUEST_REPLY) {
                b2.loadLocal(invOutVar);
                b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "flush", null, null);
            }
            if (anySharedParam && !returnPipe && (!remoteMethod.isAsynchronous() || remoteMethod.isBatched())) {
                b2.loadLocal(invOutVar);
                b2.invokeVirtual(CodeBuilderUtil.INV_OUT_TYPE, "reset", null, null);
            }
            if (remoteMethod.getAsynchronousCallMode() == CallMode.ACKNOWLEDGED) {
                b2.loadLocal(channelVar);
                b2.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getInputStream", CodeBuilderUtil.INV_IN_TYPE, null);
                b2.invokeVirtual(CodeBuilderUtil.INV_IN_TYPE, "readThrowable", CodeBuilderUtil.THROWABLE_TYPE, null);
                b2.pop();
            }
            if (remoteMethod.isAsynchronous()) {
                invokeEnd = b2.createLabel().setLocation();
                if (returnPipe) {
                    b2.loadLocal(supportVar);
                    b2.loadLocal(channelVar);
                    if (remoteMethod.getAsynchronousCallMode() == CallMode.REQUEST_REPLY) {
                        b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "requestReply", returnDesc, new TypeDesc[]{channelVar.getType()});
                        this.genRebatch(b2, supportVar, batchedChannelVar);
                    } else {
                        b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "release", null, new TypeDesc[]{channelVar.getType()});
                        this.genRebatch(b2, supportVar, batchedChannelVar);
                        b2.loadLocal(channelVar);
                    }
                    b2.returnValue(returnDesc);
                } else if (compVar != null) {
                    if (remoteMethod.isBatched()) {
                        this.genBatched(b2, supportVar, channelVar, noTimeout);
                    } else {
                        this.genFinished(b2, supportVar, channelVar, batchedChannelVar, noTimeout, anySharedParam);
                    }
                    b2.loadLocal(compVar);
                    b2.returnValue(returnDesc);
                } else if (remoteMethod.isBatched() && returnDesc != null && Remote.class.isAssignableFrom(returnDesc.toClass())) {
                    b2.loadLocal(supportVar);
                    b2.loadConstant(remoteFailureExType);
                    b2.loadLocal(channelVar);
                    b2.loadConstant(returnDesc);
                    b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "createBatchedRemote", TypeDesc.forClass(Remote.class), new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.CLASS_TYPE});
                    b2.checkCast(returnDesc);
                    this.genBatched(b2, supportVar, channelVar, noTimeout);
                    b2.returnValue(returnDesc);
                } else {
                    if (remoteMethod.isBatched()) {
                        this.genBatched(b2, supportVar, channelVar, noTimeout);
                    } else {
                        this.genFinished(b2, supportVar, channelVar, batchedChannelVar, noTimeout, anySharedParam);
                    }
                    if (returnDesc == null) {
                        b2.returnVoid();
                    } else {
                        switch (returnDesc.getTypeCode()) {
                            case 5: 
                            case 8: 
                            case 9: 
                            case 10: {
                                b2.loadConstant(0);
                                break;
                            }
                            case 11: {
                                b2.loadConstant(0L);
                                break;
                            }
                            case 6: {
                                b2.loadConstant(0.0f);
                                break;
                            }
                            case 7: {
                                b2.loadConstant(0.0);
                                break;
                            }
                            case 4: {
                                b2.loadConstant(false);
                                break;
                            }
                            default: {
                                b2.loadNull();
                            }
                        }
                        b2.returnValue(returnDesc);
                    }
                }
            } else {
                b2.loadLocal(channelVar);
                b2.invokeInterface(CodeBuilderUtil.INV_CHANNEL_TYPE, "getInputStream", CodeBuilderUtil.INV_IN_TYPE, null);
                LocalVariable invInVar = b2.createLocalVariable(null, CodeBuilderUtil.INV_IN_TYPE);
                b2.storeLocal(invInVar);
                LocalVariable throwableVar = b2.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
                b2.loadLocal(invInVar);
                b2.invokeVirtual(CodeBuilderUtil.INV_IN_TYPE, "readThrowable", CodeBuilderUtil.THROWABLE_TYPE, null);
                b2.storeLocal(throwableVar);
                b2.loadLocal(throwableVar);
                Label abnormalResponse = b2.createLabel();
                b2.ifNullBranch((Location)abnormalResponse, false);
                if (returnDesc == null) {
                    invokeEnd = b2.createLabel().setLocation();
                    this.genFinished(b2, supportVar, channelVar, batchedChannelVar, noTimeout, false);
                    b2.returnVoid();
                } else {
                    CodeBuilderUtil.readParam(b2, remoteMethod.getReturnType(), invInVar);
                    invokeEnd = b2.createLabel().setLocation();
                    this.genFinished(b2, supportVar, channelVar, batchedChannelVar, noTimeout, false);
                    b2.returnValue(returnDesc);
                }
                abnormalResponse.setLocation();
                this.genFinished(b2, supportVar, channelVar, batchedChannelVar, noTimeout, false);
                b2.loadLocal(throwableVar);
                b2.throwObject();
            }
            b2.exceptionHandler((Location)invokeStart, (Location)invokeEnd, Throwable.class.getName());
            LocalVariable throwableVar = b2.createLocalVariable(null, CodeBuilderUtil.THROWABLE_TYPE);
            b2.storeLocal(throwableVar);
            b2.loadLocal(supportVar);
            b2.loadConstant(remoteFailureExType);
            b2.loadLocal(channelVar);
            b2.loadLocal(throwableVar);
            if (noTimeout) {
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "failed", CodeBuilderUtil.THROWABLE_TYPE, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.THROWABLE_TYPE});
            } else {
                this.genLoadTimeoutVars(b2, false, timeout, timeoutUnit, timeoutType, originalTimeoutVar, timeoutUnitVar);
                b2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "failedAndCancelTimeout", CodeBuilderUtil.THROWABLE_TYPE, new TypeDesc[]{CodeBuilderUtil.CLASS_TYPE, CodeBuilderUtil.INV_CHANNEL_TYPE, CodeBuilderUtil.THROWABLE_TYPE, timeoutType, CodeBuilderUtil.TIME_UNIT_TYPE});
            }
            this.genRebatch(b2, supportVar, batchedChannelVar);
            b2.throwObject();
        }
        Object mods = Modifiers.PRIVATE;
        mods = hasDisposer ? mods.toVolatile(true) : mods.toFinal(true);
        cf.addField((Modifiers)mods, STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        for (RemoteMethod remoteMethod : this.mLocalInfo.getRemoteMethods()) {
            List<RemoteParameter<?>> paramList = remoteMethod.getParameterTypes();
            try {
                RemoteParameter[] paramTypes = new RemoteParameter[paramList.size()];
                paramList.toArray(paramTypes);
                RemoteMethod remoteMethod2 = this.mRemoteInfo.getRemoteMethod(remoteMethod.getName(), paramTypes);
                if (CodeBuilderUtil.equalTypes(remoteMethod2.getReturnType(), remoteMethod.getReturnType())) {
                    continue;
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            TypeDesc returnDesc = CodeBuilderUtil.getTypeDesc(remoteMethod.getReturnType());
            TypeDesc[] paramDescs = CodeBuilderUtil.getTypeDescs(remoteMethod.getParameterTypes());
            mi = cf.addMethod(Modifiers.PUBLIC, remoteMethod.getName(), returnDesc, paramDescs);
            for (TypeDesc desc : exceptionDescs = CodeBuilderUtil.getTypeDescs(remoteMethod.getExceptionTypes())) {
                mi.addException(desc);
            }
            CodeBuilder b3 = new CodeBuilder(mi);
            b3.newObject(CodeBuilderUtil.UNIMPLEMENTED_EX_TYPE);
            b3.dup();
            b3.loadConstant(mi.getMethodDescriptor().toMethodSignature(remoteMethod.getName()));
            b3.invokeConstructor(CodeBuilderUtil.UNIMPLEMENTED_EX_TYPE, new TypeDesc[]{TypeDesc.STRING});
            b3.throwObject();
        }
        MethodInfo mi3 = cf.addMethod(Modifiers.PUBLIC, "hashCode", TypeDesc.INT, null);
        CodeBuilder codeBuilder = new CodeBuilder(mi3);
        codeBuilder.loadThis();
        codeBuilder.loadField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        codeBuilder.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "stubHashCode", TypeDesc.INT, null);
        codeBuilder.returnValue(TypeDesc.INT);
        MethodInfo mi4 = cf.addMethod(Modifiers.PUBLIC, "equals", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.OBJECT});
        CodeBuilder codeBuilder2 = new CodeBuilder(mi4);
        codeBuilder2.loadThis();
        codeBuilder2.loadLocal(codeBuilder2.getParameter(0));
        Label notIdentical = codeBuilder2.createLabel();
        codeBuilder2.ifEqualBranch((Location)notIdentical, false);
        codeBuilder2.loadConstant(true);
        codeBuilder2.returnValue(TypeDesc.BOOLEAN);
        notIdentical.setLocation();
        codeBuilder2.loadLocal(codeBuilder2.getParameter(0));
        codeBuilder2.instanceOf(cf.getType());
        Label notInstance = codeBuilder2.createLabel();
        codeBuilder2.ifZeroComparisonBranch((Location)notInstance, "==");
        codeBuilder2.loadThis();
        codeBuilder2.loadField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        codeBuilder2.loadLocal(codeBuilder2.getParameter(0));
        codeBuilder2.checkCast(cf.getType());
        codeBuilder2.loadField(cf.getType(), STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        codeBuilder2.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "stubEquals", TypeDesc.BOOLEAN, new TypeDesc[]{CodeBuilderUtil.STUB_SUPPORT_TYPE});
        codeBuilder2.returnValue(TypeDesc.BOOLEAN);
        notInstance.setLocation();
        codeBuilder2.loadConstant(false);
        codeBuilder2.returnValue(TypeDesc.BOOLEAN);
        mi4 = cf.addMethod(Modifiers.PUBLIC, "toString", TypeDesc.STRING, null);
        CodeBuilder codeBuilder3 = new CodeBuilder(mi4);
        codeBuilder3.loadConstant(this.mRemoteInfo.getName() + '@');
        codeBuilder3.loadThis();
        codeBuilder3.loadField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        codeBuilder3.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "stubToString", TypeDesc.STRING, null);
        codeBuilder3.invokeVirtual(TypeDesc.STRING, "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
        codeBuilder3.returnValue(TypeDesc.STRING);
        mi4 = cf.addMethod(Modifiers.PUBLIC.toStatic(true), "sessionLink", CodeBuilderUtil.LINK_TYPE, new TypeDesc[]{cf.getType()});
        CodeBuilder codeBuilder4 = new CodeBuilder(mi4);
        codeBuilder4.loadLocal(codeBuilder4.getParameter(0));
        codeBuilder4.loadField(STUB_SUPPORT_NAME, CodeBuilderUtil.STUB_SUPPORT_TYPE);
        codeBuilder4.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "sessionLink", CodeBuilderUtil.LINK_TYPE, null);
        codeBuilder4.returnValue(CodeBuilderUtil.LINK_TYPE);
        staticInitBuilder.returnVoid();
        return cf.defineClass();
    }

    private LocalVariable genLoadTimeoutVars(CodeBuilder b, boolean replaceNull, long timeout, TimeUnit timeoutUnit, TypeDesc timeoutType, LocalVariable timeoutVar, LocalVariable timeoutUnitVar) {
        if (timeoutVar == null) {
            b.loadConstant(timeout);
        } else {
            TypeDesc desc = timeoutVar.getType();
            if (desc.isPrimitive()) {
                b.loadLocal(timeoutVar);
                b.convert(desc, timeoutType);
            } else {
                b.loadLocal(timeoutVar);
                Label ready = b.createLabel();
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                LocalVariable originalTimeoutVar = timeoutVar;
                if (replaceNull) {
                    if (this.genLoadConstantTimeoutValue(b, timeout, timeoutType, timeoutVar)) {
                        timeoutVar = b.createLocalVariable(null, timeoutVar.getType());
                    }
                    b.convert(timeoutVar.getType().toPrimitiveType(), timeoutVar.getType());
                    b.storeLocal(timeoutVar);
                }
                if (timeoutType == TypeDesc.DOUBLE) {
                    b.loadConstant((double)timeout);
                } else {
                    b.loadConstant(timeout);
                }
                b.branch((Location)ready);
                notNull.setLocation();
                b.loadLocal(originalTimeoutVar);
                if (originalTimeoutVar != timeoutVar) {
                    b.storeLocal(timeoutVar);
                    b.loadLocal(originalTimeoutVar);
                }
                b.convert(desc, timeoutType);
                ready.setLocation();
            }
        }
        if (timeoutUnitVar == null) {
            b.loadStaticField(CodeBuilderUtil.TIME_UNIT_TYPE, timeoutUnit.name(), CodeBuilderUtil.TIME_UNIT_TYPE);
        } else {
            b.loadLocal(timeoutUnitVar);
            if (replaceNull) {
                Label notNull = b.createLabel();
                b.ifNullBranch((Location)notNull, false);
                b.loadStaticField(CodeBuilderUtil.TIME_UNIT_TYPE, timeoutUnit.name(), CodeBuilderUtil.TIME_UNIT_TYPE);
                b.storeLocal(timeoutUnitVar);
                notNull.setLocation();
                b.loadLocal(timeoutUnitVar);
            }
        }
        return timeoutVar;
    }

    private boolean genLoadConstantTimeoutValue(CodeBuilder b, long timeout, TypeDesc timeoutType, LocalVariable timeoutVar) {
        switch (timeoutVar.getType().toPrimitiveType().getTypeCode()) {
            case 8: {
                if ((long)((byte)timeout) != timeout) {
                    b.loadConstant(-1);
                    return true;
                }
                b.loadConstant((int)((byte)timeout));
                return false;
            }
            case 9: {
                if ((long)((short)timeout) != timeout) {
                    b.loadConstant(-1);
                    return true;
                }
                b.loadConstant((int)((short)timeout));
                return false;
            }
            case 10: {
                if ((long)((int)timeout) != timeout) {
                    b.loadConstant(-1);
                    return true;
                }
                b.loadConstant((int)timeout);
                return false;
            }
            default: {
                b.loadConstant(timeout);
                return false;
            }
            case 6: {
                b.loadConstant((float)timeout);
                return (float)timeout != (float)timeout;
            }
            case 7: 
        }
        b.loadConstant((double)timeout);
        return (double)timeout != (double)timeout;
    }

    private void genBatched(CodeBuilder b, LocalVariable supportVar, LocalVariable channelVar, boolean noTimeout) {
        b.loadLocal(supportVar);
        b.loadLocal(channelVar);
        String methodName = noTimeout ? "batched" : "batchedAndCancelTimeout";
        b.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, methodName, null, new TypeDesc[]{channelVar.getType()});
    }

    private void genFinished(CodeBuilder b, LocalVariable supportVar, LocalVariable channelVar, LocalVariable batchedChannelVar, boolean noTimeout, boolean reset) {
        b.loadLocal(supportVar);
        b.loadLocal(channelVar);
        b.loadConstant(reset);
        String methodName = noTimeout ? "finished" : "finishedAndCancelTimeout";
        b.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, methodName, null, new TypeDesc[]{channelVar.getType(), TypeDesc.BOOLEAN});
        this.genRebatch(b, supportVar, batchedChannelVar);
    }

    private void genRebatch(CodeBuilder b, LocalVariable supportVar, LocalVariable batchedChannelVar) {
        if (batchedChannelVar != null) {
            b.loadLocal(supportVar);
            b.loadLocal(batchedChannelVar);
            b.invokeInterface(CodeBuilderUtil.STUB_SUPPORT_TYPE, "rebatch", null, new TypeDesc[]{CodeBuilderUtil.INV_CHANNEL_TYPE});
        }
    }

    private static class Factory<R extends Remote>
    implements StubFactory<R> {
        private final Constructor<? extends R> mStubCtor;

        Factory(Constructor<? extends R> ctor) {
            this.mStubCtor = ctor;
        }

        @Override
        public R createStub(StubSupport support) {
            Throwable error;
            try {
                return (R)((Remote)this.mStubCtor.newInstance(support));
            }
            catch (InstantiationException e) {
                error = e;
            }
            catch (IllegalAccessException e) {
                error = e;
            }
            catch (InvocationTargetException e) {
                error = e.getCause();
            }
            InternalError ie = new InternalError();
            ie.initCause(error);
            throw ie;
        }
    }
}

