/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.cojen.dirmi.core.AbstractIdentifier;
import org.cojen.dirmi.core.IdentifierStore;

public class VersionedIdentifier
extends AbstractIdentifier {
    private static final AtomicIntegerFieldUpdater<VersionedIdentifier> cLocalUpdater = AtomicIntegerFieldUpdater.newUpdater(VersionedIdentifier.class, "mLocalVersion");
    private static final AtomicIntegerFieldUpdater<VersionedIdentifier> cRemoteUpdater = AtomicIntegerFieldUpdater.newUpdater(VersionedIdentifier.class, "mRemoteVersion");
    private static final IdentifierStore<VersionedIdentifier> cStore = new IdentifierStore<VersionedIdentifier>(){

        @Override
        VersionedIdentifier newIdentifier(long bits) {
            return new VersionedIdentifier(bits);
        }
    };
    private volatile transient int mLocalVersion;
    private volatile transient int mRemoteVersion;

    public static VersionedIdentifier identify(Object obj) {
        return cStore.identify(obj);
    }

    public static VersionedIdentifier read(DataInput in) throws IOException {
        return cStore.read(in);
    }

    public static VersionedIdentifier read(InputStream in) throws IOException {
        return cStore.read(in);
    }

    public static VersionedIdentifier readAndUpdateRemoteVersion(DataInput in) throws IOException {
        VersionedIdentifier id = VersionedIdentifier.read(in);
        id.updateRemoteVersion(in.readInt());
        return id;
    }

    VersionedIdentifier(long bits) {
        super(bits);
    }

    public void writeWithNextVersion(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.nextLocalVersion());
    }

    public int localVersion() {
        return this.mLocalVersion;
    }

    public int nextLocalVersion() {
        return cLocalUpdater.incrementAndGet(this);
    }

    public int remoteVersion() {
        return this.mRemoteVersion;
    }

    public boolean updateRemoteVersion(int value) {
        int current;
        while ((current = this.mRemoteVersion) - value < 0) {
            if (!cRemoteUpdater.compareAndSet(this, current, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object tryRetrieve() {
        return cStore.tryRetrieve(this);
    }

    @Override
    public <T> void register(T obj) throws IllegalArgumentException {
        cStore.register(this, obj);
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return cStore.canonicalIdentifier(this);
    }
}

