/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.info;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.Asynchronous;
import org.cojen.dirmi.Batched;
import org.cojen.dirmi.CallMode;
import org.cojen.dirmi.Completion;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.Ordered;
import org.cojen.dirmi.Pipe;
import org.cojen.dirmi.RemoteFailure;
import org.cojen.dirmi.Timeout;
import org.cojen.dirmi.TimeoutParam;
import org.cojen.dirmi.TimeoutUnit;
import org.cojen.dirmi.Trace;
import org.cojen.dirmi.Unbatched;
import org.cojen.dirmi.info.RemoteInfo;
import org.cojen.dirmi.info.RemoteMethod;
import org.cojen.dirmi.info.RemoteParameter;
import org.cojen.dirmi.util.Cache;
import org.cojen.util.WeakCanonicalSet;

public class RemoteIntrospector {
    private static final Cache<Class<?>, Class<?>> cInterfaceCache = Cache.newWeakIdentityCache(17);
    private static final Cache<Class<?>, RInfo> cInfoCache = Cache.newWeakIdentityCache(17);
    private static final WeakCanonicalSet cParameterCache = new WeakCanonicalSet();

    static <T> RParameter<T> intern(RParameter<T> param) {
        return (RParameter)cParameterCache.put(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Remote> Class<? extends Remote> getRemoteType(R remoteObj) throws IllegalArgumentException {
        if (remoteObj == null) {
            throw new IllegalArgumentException("Remote object must not be null");
        }
        Class<?> clazz = remoteObj.getClass();
        Cache<Class<?>, Class<?>> cache = cInterfaceCache;
        synchronized (cache) {
            Class<?> theOne = cInterfaceCache.get(clazz);
            if (theOne != null) {
                return theOne;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Modifier.isPublic(iface.getModifiers()) || !Remote.class.isAssignableFrom(iface)) continue;
                if (theOne != null) {
                    throw new IllegalArgumentException("At most one Remote interface may be directly implemented: " + clazz.getName());
                }
                theOne = iface;
            }
            if (theOne == null) {
                throw new IllegalArgumentException("No Remote types directly implemented: " + clazz.getName());
            }
            cInterfaceCache.put(clazz, theOne);
            return theOne;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteInfo examine(Class<? extends Remote> remote) throws IllegalArgumentException {
        if (remote == null) {
            throw new IllegalArgumentException("Remote interface must not be null");
        }
        Cache<Class<?>, RInfo> cache = cInfoCache;
        synchronized (cache) {
            RInfo info = cInfoCache.get(remote);
            if (info != null) {
                return info;
            }
            if (!remote.isInterface()) {
                throw new IllegalArgumentException("Remote type must be an interface: " + remote);
            }
            if (!Modifier.isPublic(remote.getModifiers())) {
                throw new IllegalArgumentException("Remote interface must be public: " + remote.getName());
            }
            if (!Remote.class.isAssignableFrom(remote)) {
                throw new IllegalArgumentException("Remote interface must extend java.rmi.Remote: " + remote.getName());
            }
            if (Serializable.class.isAssignableFrom(remote)) {
                throw new IllegalArgumentException("Remote interface cannot extend java.io.Serializable: " + remote.getName());
            }
            TreeMap<String, RMethod> methodMap = new TreeMap<String, RMethod>();
            for (Method m : remote.getMethods()) {
                RMethod candidate;
                if (!m.getDeclaringClass().isInterface() || RemoteIntrospector.isObjectMethod(m)) continue;
                Class<?>[] params = m.getParameterTypes();
                TypeDesc[] paramDescs = new TypeDesc[params.length];
                for (int i = 0; i < params.length; ++i) {
                    paramDescs[i] = TypeDesc.forClass(params[i]);
                }
                MethodDesc desc = MethodDesc.forArguments((TypeDesc)TypeDesc.forClass(m.getReturnType()), (TypeDesc[])paramDescs);
                String key = m.getName() + ':' + desc;
                if (!methodMap.containsKey(key)) {
                    methodMap.put(key, new RMethod(m));
                    continue;
                }
                RMethod existing = (RMethod)methodMap.get(key);
                if (existing.equals(candidate = new RMethod(m))) continue;
                candidate = existing.intersectExceptions(candidate);
                methodMap.put(key, candidate);
            }
            for (RMethod method : methodMap.values()) {
                if (!method.isAsynchronous() || method.getReturnType() == null) continue;
                Class returnType = method.getReturnType().getType();
                if (Pipe.class == returnType) {
                    if (method.isBatched()) {
                        throw new IllegalArgumentException("Asynchronous batched method cannot return Pipe: " + method.methodDesc());
                    }
                    int count = 0;
                    for (RemoteParameter<?> param : method.getParameterTypes()) {
                        if (param.getType() != returnType) continue;
                        ++count;
                    }
                    if (count == true) continue;
                    throw new IllegalArgumentException("Asynchronous method which returns Pipe must have exactly one matching Pipe input parameter: " + method.methodDesc());
                }
                if (Future.class == returnType || Completion.class == returnType) continue;
                if (method.isBatched()) {
                    if (Remote.class.isAssignableFrom(returnType)) continue;
                    throw new IllegalArgumentException("Asynchronous batched method must return void, a Remote object, Completion or Future: " + method.methodDesc());
                }
                throw new IllegalArgumentException("Asynchronous method must return void, Pipe, Completion or Future: " + method.methodDesc());
            }
            TreeSet<String> interfaces = new TreeSet<String>();
            RemoteIntrospector.gatherRemoteInterfaces(interfaces, remote);
            info = new RInfo(remote, interfaces, new LinkedHashSet<RMethod>(methodMap.values()));
            cInfoCache.put(remote, info);
            try {
                info.resolve();
            }
            catch (IllegalArgumentException e) {
                cInfoCache.remove(remote);
                throw e;
            }
            return info;
        }
    }

    private static void gatherRemoteInterfaces(Set<String> interfaces, Class clazz) {
        for (Class<?> i : clazz.getInterfaces()) {
            if (!Remote.class.isAssignableFrom(i) || !interfaces.add(i.getName())) continue;
            RemoteIntrospector.gatherRemoteInterfaces(interfaces, i);
        }
        if (clazz.isInterface() && Remote.class.isAssignableFrom(clazz)) {
            interfaces.add(clazz.getName());
        }
    }

    private static boolean isObjectMethod(Method m) {
        try {
            return Object.class.getMethod(m.getName(), m.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private RemoteIntrospector() {
    }

    private static class RParameter<T>
    implements RemoteParameter<T>,
    Comparable<RParameter> {
        private static final long serialVersionUID = 1L;
        private static final int FLAG_UNSHARED = 1;
        private static final int FLAG_TIMEOUT = 2;
        private static final int FLAG_TIMEOUT_UNIT = 4;
        private final Class<T> mType;
        private final int mFlags;
        private final String mDescriptor;

        static <T> RParameter<T> make(Class<T> type) {
            return RParameter.make(type, false, false, false);
        }

        static <T> RParameter<T> make(Class<T> type, boolean asynchronous) {
            return RParameter.make(type, asynchronous, false, false);
        }

        static <T> RParameter<T> make(Class<T> type, boolean asynchronous, boolean timeout, boolean timeoutUnit) {
            if (type == Void.TYPE || type == null) {
                return null;
            }
            boolean unshared = type.isPrimitive() || String.class.isAssignableFrom(type) || asynchronous && Pipe.class.isAssignableFrom(type) || TypeDesc.forClass(type).toPrimitiveType() != null;
            int flags = (unshared ? 1 : 0) | (timeout ? 2 : 0) | (timeoutUnit ? 4 : 0);
            return RemoteIntrospector.intern(new RParameter<T>(type, flags));
        }

        private RParameter(Class<T> type, int flags) {
            this.mType = type;
            this.mFlags = flags;
            this.mDescriptor = TypeDesc.forClass(type).getDescriptor().intern();
        }

        @Override
        public Class<T> getType() {
            return this.mType;
        }

        @Override
        public boolean isUnshared() {
            return (this.mFlags & 1) != 0;
        }

        @Override
        public boolean isTimeout() {
            return (this.mFlags & 2) != 0;
        }

        @Override
        public boolean isTimeoutUnit() {
            return (this.mFlags & 4) != 0;
        }

        @Override
        public boolean equalTypes(RemoteParameter other) {
            if (this == other) {
                return true;
            }
            return this.getType().getName().equals(other.getType().getName());
        }

        public int hashCode() {
            return this.mType.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RParameter) {
                RParameter other = (RParameter)obj;
                return this.mFlags == other.mFlags && this.mType.equals(other.mType);
            }
            return false;
        }

        public String toString() {
            return TypeDesc.forClass(this.mType).getFullName();
        }

        @Override
        public int compareTo(RParameter other) {
            int compare = this.mType.getName().compareTo(other.mType.getName());
            if (compare == 0) {
                if (this.mFlags < other.mFlags) {
                    compare = -1;
                } else if (this.mFlags > other.mFlags) {
                    compare = 1;
                }
            }
            return compare;
        }

        RParameter toUnshared(boolean unshared) {
            int flags;
            int n = flags = unshared ? this.mFlags | 1 : this.mFlags & 0xFFFFFFFE;
            if (flags == this.mFlags) {
                return this;
            }
            return RemoteIntrospector.intern(new RParameter<T>(this.mType, flags));
        }

        void mixIn(DataOutput digest) throws IOException {
            digest.writeUTF(this.mType.getName());
            digest.writeInt(this.mFlags);
        }

        private Object readResolve() {
            return RemoteIntrospector.intern(this);
        }
    }

    private static class RMethod
    implements RemoteMethod {
        private static final long serialVersionUID = 1L;
        private int mId;
        private final String mName;
        private RParameter mReturnType;
        private List<RParameter<Object>> mParameterTypes;
        private final SortedSet<RParameter<Throwable>> mExceptionTypes;
        private final CallMode mCallMode;
        private final boolean mBatched;
        private final boolean mUnbatched;
        private final boolean mOrdered;
        private final boolean mDisposer;
        private final transient Trace mTrace;
        private RParameter<? extends Throwable> mRemoteFailureException;
        private boolean mRemoteFailureExceptionDeclared;
        private long mTimeout;
        private TimeUnit mTimeoutUnit;
        private transient Method mMethod;

        RMethod(Method m) {
            long timeout;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new IllegalArgumentException("Remote method must be public: " + RMethod.methodDesc(m));
            }
            this.mName = m.getName();
            if (m.isAnnotationPresent(Batched.class)) {
                this.mBatched = true;
                this.mCallMode = m.getAnnotation(Batched.class).value();
                if (m.isAnnotationPresent(Asynchronous.class)) {
                    throw new IllegalArgumentException("Method cannot be annotated as both @Asynchronous and @Batched: " + RMethod.methodDesc(m));
                }
            } else {
                this.mBatched = false;
                Asynchronous ann = m.getAnnotation(Asynchronous.class);
                this.mCallMode = ann == null ? null : ann.value();
            }
            if (m.isAnnotationPresent(Unbatched.class)) {
                if (this.mBatched) {
                    throw new IllegalArgumentException("Method cannot be annotated as both @Batched and @Unbatched: " + RMethod.methodDesc(m));
                }
                this.mUnbatched = true;
            } else {
                this.mUnbatched = false;
            }
            this.mOrdered = m.isAnnotationPresent(Ordered.class);
            this.mDisposer = m.isAnnotationPresent(Disposer.class);
            this.mTrace = m.getAnnotation(Trace.class);
            Class<?> returnType = m.getReturnType();
            if (returnType == null) {
                this.mReturnType = null;
            } else {
                if (!Modifier.isPublic(returnType.getModifiers())) {
                    throw new IllegalArgumentException("Remote method return type must be public: " + RMethod.methodDesc(m));
                }
                this.mReturnType = RParameter.make(returnType, this.mCallMode != null);
            }
            Class<?>[] paramsTypes = m.getParameterTypes();
            if (paramsTypes == null || paramsTypes.length == 0) {
                this.mParameterTypes = null;
            } else {
                Class<?> paramType;
                int i;
                this.mParameterTypes = new ArrayList<RParameter<Object>>(paramsTypes.length);
                Annotation[][] paramsAnns = m.getParameterAnnotations();
                int timeoutValueParam = -1;
                int timeoutUnitParam = -1;
                boolean defaultTimeoutUnitParam = false;
                for (i = 0; i < paramsTypes.length; ++i) {
                    paramType = paramsTypes[i];
                    if (!Modifier.isPublic(paramType.getModifiers())) {
                        throw new IllegalArgumentException("Remote method parameter types must be public: " + RMethod.methodDesc(m));
                    }
                    Annotation[] paramAnns = paramsAnns[i];
                    if (paramAnns == null) continue;
                    for (Annotation ann : paramAnns) {
                        if (!(ann instanceof TimeoutParam)) continue;
                        if (paramType == TimeUnit.class) {
                            if (timeoutUnitParam >= 0 && !defaultTimeoutUnitParam) {
                                throw new IllegalArgumentException("At most one timeout unit parameter allowed: " + RMethod.methodDesc(m));
                            }
                            timeoutUnitParam = i;
                            defaultTimeoutUnitParam = false;
                            continue;
                        }
                        TypeDesc desc = TypeDesc.forClass(paramType).toPrimitiveType();
                        if (desc != null && desc != TypeDesc.BOOLEAN && desc != TypeDesc.CHAR) {
                            if (timeoutValueParam >= 0) {
                                throw new IllegalArgumentException("At most one timeout value parameter allowed: " + RMethod.methodDesc(m));
                            }
                            timeoutValueParam = i;
                            if (timeoutUnitParam >= 0 || i + 1 >= paramsTypes.length || paramsTypes[i + 1] != TimeUnit.class) continue;
                            timeoutUnitParam = i + 1;
                            defaultTimeoutUnitParam = true;
                            continue;
                        }
                        throw new IllegalArgumentException("Timeout parameter can only apply to primitive numerical types or TimeUnit, not " + TypeDesc.forClass(paramType).getFullName() + ": " + RMethod.methodDesc(m));
                    }
                }
                for (i = 0; i < paramsTypes.length; ++i) {
                    paramType = paramsTypes[i];
                    this.mParameterTypes.add(RParameter.make(paramType, this.mCallMode != null, timeoutValueParam == i, timeoutUnitParam == i));
                }
            }
            Class<?>[] exceptionTypes = m.getExceptionTypes();
            if (exceptionTypes == null || exceptionTypes.length == 0) {
                this.mExceptionTypes = null;
            } else {
                TreeSet set = new TreeSet();
                for (Class<?> exceptionType : exceptionTypes) {
                    if (!Modifier.isPublic(exceptionType.getModifiers())) {
                        throw new IllegalArgumentException("Remote method declared exception types must be public: " + RMethod.methodDesc(m, exceptionType));
                    }
                    set.add(RParameter.make(exceptionType));
                }
                this.mExceptionTypes = Collections.unmodifiableSortedSet(set);
            }
            Annotation ann = m.getAnnotation(RemoteFailure.class);
            if (ann != null) {
                this.mRemoteFailureException = RParameter.make(ann.exception());
                this.mRemoteFailureExceptionDeclared = ann.declared();
            }
            ann = m.getAnnotation(Timeout.class);
            this.mTimeout = ann == null ? Long.MIN_VALUE : ((timeout = ann.value()) < 0L ? -1L : timeout);
            ann = m.getAnnotation(TimeoutUnit.class);
            if (ann != null) {
                TimeUnit unit = ann.value();
                this.mTimeoutUnit = unit == null ? TimeUnit.MILLISECONDS : unit;
            }
            this.mMethod = m;
        }

        private RMethod(RMethod existing, SortedSet<RParameter<Throwable>> exceptionTypes) {
            this.mId = existing.mId;
            this.mName = existing.mName;
            this.mReturnType = existing.mReturnType;
            this.mParameterTypes = existing.mParameterTypes;
            this.mExceptionTypes = Collections.unmodifiableSortedSet(exceptionTypes);
            this.mCallMode = existing.mCallMode;
            this.mBatched = existing.mBatched;
            this.mUnbatched = existing.mUnbatched;
            this.mOrdered = existing.mOrdered;
            this.mDisposer = existing.mDisposer;
            this.mTrace = existing.mTrace;
            this.mRemoteFailureException = existing.mRemoteFailureException;
            this.mRemoteFailureExceptionDeclared = existing.mRemoteFailureExceptionDeclared;
            this.mMethod = existing.mMethod;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public int getMethodId() {
            return this.mId;
        }

        public RemoteParameter getReturnType() {
            return this.mReturnType;
        }

        @Override
        public List<? extends RemoteParameter<?>> getParameterTypes() {
            if (this.mParameterTypes == null) {
                return Collections.emptyList();
            }
            return this.mParameterTypes;
        }

        @Override
        public Set<? extends RemoteParameter<? extends Throwable>> getExceptionTypes() {
            if (this.mExceptionTypes == null) {
                return Collections.emptySet();
            }
            return this.mExceptionTypes;
        }

        @Override
        public String getSignature() {
            return this.getSignature(null);
        }

        @Override
        public boolean isAsynchronous() {
            return this.mCallMode != null;
        }

        @Override
        public CallMode getAsynchronousCallMode() {
            return this.mCallMode;
        }

        @Override
        public boolean isBatched() {
            return this.mBatched;
        }

        @Override
        public boolean isUnbatched() {
            return this.mUnbatched;
        }

        @Override
        public boolean isOrdered() {
            return this.mOrdered;
        }

        @Override
        public boolean isDisposer() {
            return this.mDisposer;
        }

        @Override
        public RemoteParameter<? extends Throwable> getRemoteFailureException() {
            return this.mRemoteFailureException;
        }

        @Override
        public boolean isRemoteFailureExceptionDeclared() {
            return this.mRemoteFailureExceptionDeclared;
        }

        @Override
        public long getTimeout() {
            return this.mTimeout;
        }

        @Override
        public TimeUnit getTimeoutUnit() {
            return this.mTimeoutUnit;
        }

        @Override
        public Trace getTraceAnnotation() {
            return this.mTrace;
        }

        public int hashCode() {
            return this.mName.hashCode() + this.mId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RMethod) {
                RMethod other = (RMethod)obj;
                return this.mName.equals(other.mName) && this.mId == other.mId && this.getParameterTypes().equals(other.getParameterTypes()) && this.getExceptionTypes().equals(other.getExceptionTypes()) && this.mCallMode == other.mCallMode && this.mBatched == other.mBatched && this.mRemoteFailureException == other.getRemoteFailureException() && this.mRemoteFailureExceptionDeclared == other.isRemoteFailureExceptionDeclared();
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("RemoteMethod {id=");
            b.append(this.mId);
            b.append(", sig=\"");
            b.append(this.getSignature(null));
            b.append('\"');
            b.append('}');
            return b.toString();
        }

        String getSignature(String className) {
            StringBuilder b = new StringBuilder();
            b.append(this.getReturnType() == null ? "void" : this.getReturnType());
            b.append(' ');
            if (className != null) {
                b.append(className);
                b.append('.');
            }
            b.append(this.getName());
            b.append('(');
            int count = 0;
            for (RemoteParameter<?> param : this.getParameterTypes()) {
                if (count++ > 0) {
                    b.append(", ");
                }
                b.append(param);
            }
            b.append(')');
            Set<? extends RemoteParameter<? extends Throwable>> exceptions = this.getExceptionTypes();
            if (exceptions.size() > 0) {
                b.append(" throws ");
                count = 0;
                for (RemoteParameter<? extends Throwable> remoteParameter : exceptions) {
                    if (count++ > 0) {
                        b.append(", ");
                    }
                    b.append(remoteParameter);
                }
            }
            return b.toString();
        }

        RMethod intersectExceptions(RMethod other) {
            if (this == other) {
                return this;
            }
            if (!this.mName.equals(other.mName)) {
                throw new IllegalArgumentException("name mismatch");
            }
            if (this.mId != other.mId) {
                throw new IllegalArgumentException("id mismatch");
            }
            if (!this.getParameterTypes().equals(other.getParameterTypes())) {
                throw new IllegalArgumentException("parameter types mismatch");
            }
            if (this.mCallMode != other.mCallMode || this.mBatched != other.mBatched) {
                String conflictType = !this.mBatched && !other.mBatched ? "@Asynchronous" : (this.mBatched && (other.mBatched || other.mCallMode == null) || other.mBatched && (this.mBatched || this.mCallMode == null) ? "@Batched" : "@Asynchronous/@Batched");
                throw new IllegalArgumentException("Inherited methods conflict in use of " + conflictType + " annotation: " + this.methodDesc() + " and " + other.methodDesc());
            }
            TreeSet<RParameter<Throwable>> subset = new TreeSet<RParameter<Throwable>>();
            for (RParameter rParameter : this.mExceptionTypes) {
                if (!other.declaresException(rParameter)) continue;
                subset.add(rParameter);
            }
            for (RParameter rParameter : other.mExceptionTypes) {
                if (!this.declaresException(rParameter)) continue;
                subset.add(rParameter);
            }
            return new RMethod(this, subset);
        }

        boolean declaresException(RemoteParameter exceptionType) {
            return this.declaresException(exceptionType.getType());
        }

        boolean declaresException(Class<?> exceptionType) {
            if (this.mExceptionTypes == null) {
                return false;
            }
            for (RemoteParameter remoteParameter : this.mExceptionTypes) {
                if (!remoteParameter.getType().isAssignableFrom(exceptionType)) continue;
                return true;
            }
            return false;
        }

        void resolve(RInfo info, Set<Class> validExceptions) {
            Class<?>[] exceptionTypes;
            Class<? extends Throwable> failExClass;
            block16: {
                if (this.mParameterTypes != null) {
                    int i;
                    int size = this.mParameterTypes.size();
                    boolean noneUnshared = false;
                    for (i = 0; i < size; ++i) {
                        if (this.mParameterTypes.get(i).isUnshared()) continue;
                        noneUnshared = true;
                        break;
                    }
                    for (i = 0; i < size; ++i) {
                        boolean unshared;
                        RParameter<Object> param = this.mParameterTypes.get(i);
                        Class<Object> type = param.getType();
                        boolean bl = unshared = !noneUnshared && param.isUnshared();
                        if (unshared) {
                            for (int j = i + 1; j < size; ++j) {
                                RParameter<Object> jp = this.mParameterTypes.get(j);
                                if (type != jp.getType()) continue;
                                unshared = false;
                                this.mParameterTypes.set(j, jp.toUnshared(false));
                                break;
                            }
                        }
                        this.mParameterTypes.set(i, param.toUnshared(unshared));
                    }
                    this.mParameterTypes = Collections.unmodifiableList(this.mParameterTypes);
                }
                if (this.mRemoteFailureException == null) {
                    this.mRemoteFailureException = info.getRemoteFailureException();
                    this.mRemoteFailureExceptionDeclared = info.isRemoteFailureExceptionDeclared();
                }
                if (this.mTimeout == Long.MIN_VALUE) {
                    this.mTimeout = info.getTimeout();
                }
                if (this.mTimeoutUnit == null) {
                    this.mTimeoutUnit = info.getTimeoutUnit();
                }
                if (!(failExClass = this.mRemoteFailureException.getType()).isAssignableFrom(RemoteException.class)) {
                    if (!Modifier.isPublic(failExClass.getModifiers())) {
                        throw new IllegalArgumentException("Remote failure exception must be public: " + failExClass.getName());
                    }
                    if (!validExceptions.contains(failExClass)) {
                        for (Constructor<?> ctor : failExClass.getConstructors()) {
                            Class<?>[] paramTypes = ctor.getParameterTypes();
                            if (paramTypes.length != 1 || !paramTypes[0].isAssignableFrom(RemoteException.class)) continue;
                            validExceptions.add(failExClass);
                            break block16;
                        }
                        throw new IllegalArgumentException("Remote failure exception does not have a public single-argument constructor which accepts a RemoteException: " + failExClass.getName());
                    }
                }
            }
            if (RMethod.isChecked(failExClass) && this.isRemoteFailureExceptionDeclared() && !this.declaresException(failExClass)) {
                String message = "Method must declare throwing " + failExClass.getName();
                if (this.isBatched() || !this.isAsynchronous()) {
                    message = message + " (or a superclass)";
                }
                throw new IllegalArgumentException(message + ": " + this.methodDesc() + "; use @RemoteFailure to override behavior");
            }
            if (this.isAsynchronous() && !this.isBatched() && (exceptionTypes = this.mMethod.getExceptionTypes()) != null) {
                for (Class<?> exceptionType : exceptionTypes) {
                    if (!RMethod.isChecked(exceptionType) || exceptionType == failExClass) continue;
                    throw new IllegalArgumentException("Asynchronous method can only declare throwing " + failExClass.getName() + ": " + RMethod.methodDesc(this.mMethod, exceptionType) + "; use @RemoteFailure override behavior");
                }
            }
            this.mMethod = null;
        }

        private static boolean isChecked(Class<? extends Throwable> exClass) {
            return !RuntimeException.class.isAssignableFrom(exClass) && !Error.class.isAssignableFrom(exClass);
        }

        static String methodDesc(Method m) {
            return RMethod.methodDesc(m, null);
        }

        static String methodDesc(Method m, Class exceptionType) {
            String name = m.getDeclaringClass().getName() + '.' + m.getName();
            StringBuilder b = new StringBuilder();
            b.append('\"');
            b.append(MethodDesc.forMethod((Method)m).toMethodSignature(name));
            if (exceptionType != null) {
                b.append(" throws ");
                b.append(exceptionType.getName());
            }
            b.append('\"');
            return b.toString();
        }

        String methodDesc() {
            return RMethod.methodDesc(this.mMethod);
        }

        void mixIn(DataOutput digest) throws IOException {
            digest.writeUTF(this.mName);
            if (this.mReturnType != null) {
                this.mReturnType.mixIn(digest);
            }
            if (this.mParameterTypes != null) {
                for (RParameter<Object> rParameter : this.mParameterTypes) {
                    rParameter.mixIn(digest);
                }
            }
            if (this.mExceptionTypes != null) {
                for (RParameter<Object> rParameter : this.mExceptionTypes) {
                    rParameter.mixIn(digest);
                }
            }
            if (this.mCallMode != null) {
                digest.writeUTF(this.mCallMode.name());
            }
            digest.writeBoolean(this.mBatched);
            this.mRemoteFailureException.mixIn(digest);
            digest.writeBoolean(this.mRemoteFailureExceptionDeclared);
            digest.writeLong(this.mTimeout);
            digest.writeUTF(this.mTimeoutUnit.name());
        }

        void setId(int id) {
            this.mId = id;
        }
    }

    private static class RInfo
    implements RemoteInfo {
        private static final long serialVersionUID = 1L;
        private long mId;
        private final String mName;
        private final SortedSet<String> mInterfaceNames;
        private final Set<RMethod> mMethods;
        private final transient RParameter<? extends Throwable> mRemoteFailureException;
        private final transient boolean mRemoteFailureExceptionDeclared;
        private final transient long mTimeout;
        private final transient TimeUnit mTimeoutUnit;
        private transient Map<String, Set<RMethod>> mMethodsByName;

        RInfo(Class<? extends Remote> remote, SortedSet<String> interfaces, Set<RMethod> methods) {
            TimeUnit unit;
            long timeout;
            this.mName = remote.getName();
            this.mInterfaceNames = Collections.unmodifiableSortedSet(interfaces);
            this.mMethods = Collections.unmodifiableSet(methods);
            Annotation ann = remote.getAnnotation(RemoteFailure.class);
            if (ann == null) {
                this.mRemoteFailureException = RParameter.make(RemoteException.class);
                this.mRemoteFailureExceptionDeclared = true;
            } else {
                this.mRemoteFailureException = RParameter.make(ann.exception());
                this.mRemoteFailureExceptionDeclared = ann.declared();
            }
            ann = remote.getAnnotation(Timeout.class);
            this.mTimeout = ann == null ? -1L : ((timeout = ann.value()) < 0L ? -1L : timeout);
            ann = remote.getAnnotation(TimeoutUnit.class);
            this.mTimeoutUnit = ann == null ? TimeUnit.MILLISECONDS : ((unit = ann.value()) == null ? TimeUnit.MILLISECONDS : unit);
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public long getInfoId() {
            return this.mId;
        }

        @Override
        public Set<String> getInterfaceNames() {
            return this.mInterfaceNames;
        }

        @Override
        public Set<? extends RemoteMethod> getRemoteMethods() {
            return this.mMethods;
        }

        @Override
        public Set<? extends RemoteMethod> getRemoteMethods(String name) {
            Set<RMethod> methods;
            if (this.mMethodsByName == null) {
                HashMap<String, Set<RMethod>> methodsByName = new HashMap<String, Set<RMethod>>();
                for (RMethod rMethod : this.mMethods) {
                    String methodName = rMethod.getName();
                    LinkedHashSet<RMethod> set = (LinkedHashSet<RMethod>)methodsByName.get(methodName);
                    if (set == null) {
                        set = new LinkedHashSet<RMethod>();
                        methodsByName.put(methodName, set);
                    }
                    set.add(rMethod);
                }
                for (Map.Entry entry : methodsByName.entrySet()) {
                    entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
                }
                this.mMethodsByName = methodsByName;
            }
            if ((methods = this.mMethodsByName.get(name)) == null) {
                methods = Collections.emptySet();
            }
            return methods;
        }

        public RemoteMethod getRemoteMethod(String name, RemoteParameter ... params) throws NoSuchMethodException {
            int paramsLength = params == null ? 0 : params.length;
            block0: for (RemoteMethod remoteMethod : this.getRemoteMethods(name)) {
                List<RemoteParameter<?>> paramTypes = remoteMethod.getParameterTypes();
                if (paramTypes.size() != paramsLength) continue;
                for (int i = 0; i < paramsLength; ++i) {
                    if (!paramTypes.get(i).equalTypes(params[i])) continue block0;
                }
                return remoteMethod;
            }
            throw new NoSuchMethodException(name);
        }

        public int hashCode() {
            return this.mName.hashCode() + (int)(this.mId >> 32) + (int)this.mId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RInfo) {
                RInfo other = (RInfo)obj;
                return this.mName.equals(other.mName) && this.mId == other.mId && this.mInterfaceNames.equals(other.mInterfaceNames) && this.getRemoteMethods().equals(other.getRemoteMethods());
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("RemoteInfo {id=");
            b.append(this.mId);
            b.append(", name=");
            b.append(this.mName);
            b.append('}');
            return b.toString();
        }

        RParameter<? extends Throwable> getRemoteFailureException() {
            return this.mRemoteFailureException;
        }

        boolean isRemoteFailureExceptionDeclared() {
            return this.mRemoteFailureExceptionDeclared;
        }

        long getTimeout() {
            return this.mTimeout;
        }

        TimeUnit getTimeoutUnit() {
            return this.mTimeoutUnit;
        }

        void resolve() {
            MessageDigest digest;
            HashSet<Class> validExceptions = new HashSet<Class>();
            for (RMethod method : this.mMethods) {
                method.resolve(this, validExceptions);
            }
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
            OutputStream nullOut = new OutputStream(){

                @Override
                public void write(int b) {
                }

                @Override
                public void write(byte[] b, int off, int len) {
                }
            };
            DataOutputStream digestOutput = new DataOutputStream(new DigestOutputStream(nullOut, digest));
            try {
                this.mixIn(digestOutput);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            byte[] hash = digest.digest();
            long id = 0L;
            for (int i = 0; i < hash.length; ++i) {
                id ^= ((long)hash[i] & 0xFFL) << ((i & 7) << 3);
            }
            this.mId = id;
            int methodId = 0;
            for (int i = 0; i < 4; ++i) {
                methodId ^= (hash[i] & 0xFF) << ((i & 3) << 3);
            }
            for (RMethod method : this.mMethods) {
                if (method.isAsynchronous()) {
                    if ((methodId & 1) == 0) {
                        ++methodId;
                    }
                } else if ((methodId & 1) != 0) {
                    ++methodId;
                }
                method.setId(methodId);
                ++methodId;
            }
        }

        void mixIn(DataOutput digest) throws IOException {
            digest.writeUTF(this.mName);
            for (String name : this.mInterfaceNames) {
                digest.writeUTF(name);
            }
            for (RMethod method : this.mMethods) {
                method.mixIn(digest);
            }
        }
    }
}

