/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelAcceptWaiter;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.ChannelBroker;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.ListenerQueue;
import org.cojen.dirmi.util.ScheduledTask;
import org.cojen.dirmi.util.Timer;

abstract class BasicChannelBroker
implements ChannelBroker {
    private static final int PING_DELAY_MILLIS = 2500;
    private static final int PING_CHECK_DELAY_MILLIS = 1000;
    private static final int PING_FAILURE_MILLIS = 9000;
    static final Logger cPingLogger;
    protected final long mId;
    protected final Channel mControl;
    protected final CloseableGroup<Channel> mAllChannels;
    private final ListenerQueue<ChannelAcceptor.Listener> mListenerQueue;
    private final Future<?> mScheduledPingCheck;
    private final Future<?> mScheduledDoPing;
    private volatile long mLastPingNanos;

    BasicChannelBroker(IOExecutor executor, long id, Channel control) throws RejectedException {
        this.mId = id;
        this.mControl = control;
        this.mAllChannels = new CloseableGroup();
        this.mListenerQueue = new ListenerQueue<ChannelAcceptor.Listener>(executor, ChannelAcceptor.Listener.class);
        control.setInputBufferSize(10);
        control.setOutputBufferSize(10);
        this.mLastPingNanos = System.nanoTime();
        PingTask pinger = new PingCheckTask(this);
        try {
            this.mScheduledPingCheck = executor.scheduleWithFixedDelay(pinger, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedException e) {
            control.disconnect();
            throw e;
        }
        pinger.scheduled(this.mScheduledPingCheck);
        if (!this.requirePingTask()) {
            this.mScheduledDoPing = null;
        } else {
            pinger = new DoPingTask(this);
            try {
                this.mScheduledDoPing = executor.scheduleWithFixedDelay(pinger, 2500L, 2500L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedException e) {
                this.mScheduledPingCheck.cancel(false);
                control.disconnect();
                throw e;
            }
            pinger.scheduled(this.mScheduledDoPing);
        }
    }

    @Override
    public Object getRemoteAddress() {
        return this.mControl.getRemoteAddress();
    }

    @Override
    public Object getLocalAddress() {
        return this.mControl.getLocalAddress();
    }

    @Override
    public Channel connect(Timer timer) throws IOException {
        return this.connect(RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    @Override
    public Channel accept() throws IOException {
        ChannelAcceptWaiter listener = new ChannelAcceptWaiter();
        this.accept(listener);
        return listener.waitForChannel();
    }

    @Override
    public Channel accept(long timeout, TimeUnit unit) throws IOException {
        ChannelAcceptWaiter listener = new ChannelAcceptWaiter();
        this.accept(listener);
        return listener.waitForChannel(timeout, unit);
    }

    @Override
    public Channel accept(Timer timer) throws IOException {
        return this.accept(RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    @Override
    public void accept(ChannelAcceptor.Listener listener) {
        try {
            this.mListenerQueue.enqueue(listener);
        }
        catch (RejectedException e) {
            this.mListenerQueue.dequeue().rejected(e);
        }
    }

    @Override
    public void close() {
        this.close(null);
    }

    public String toString() {
        return "ChannelBroker {localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }

    protected void accepted(Channel channel) {
        channel.register(this.mAllChannels);
        this.mListenerQueue.dequeue().accepted(channel);
    }

    protected void close(IOException cause) {
        if (this.mAllChannels.isClosed()) {
            return;
        }
        try {
            if (cause == null) {
                cause = new ClosedException();
            }
            if (this.mScheduledPingCheck != null) {
                this.mScheduledPingCheck.cancel(false);
            }
            if (this.mScheduledDoPing != null) {
                this.mScheduledDoPing.cancel(false);
            }
            this.mControl.disconnect();
            this.mAllChannels.disconnect();
        }
        finally {
            this.mListenerQueue.dequeueForClose().closed(cause);
        }
    }

    protected void pinged() {
        this.mLastPingNanos = System.nanoTime();
    }

    protected abstract boolean requirePingTask();

    protected abstract boolean doPing() throws IOException;

    void logPingMessage(String message) {
        if (cPingLogger != null) {
            cPingLogger.info(message);
        }
    }

    private boolean pingCheck() {
        long lag = System.nanoTime() - this.mLastPingNanos;
        if (lag > 9000000000L) {
            if (cPingLogger != null) {
                this.logPingMessage("Ping missed for " + this.mControl + ": " + lag / 1000000L + " > " + 9000);
            }
            this.close(new ClosedException("Ping failure"));
            return false;
        }
        if (cPingLogger != null && lag >= 3500000000L) {
            this.logPingMessage("Ping lag for " + this.mControl + ": " + lag / 1000000L + " <= " + 9000);
        }
        return true;
    }

    static {
        String prop = System.getProperty(BasicChannelBroker.class.getName() + ".LOG_PINGS");
        cPingLogger = prop == null || !prop.equalsIgnoreCase("true") ? null : Logger.getLogger(BasicChannelBroker.class.getName());
    }

    private static class PingCheckTask
    extends PingTask {
        PingCheckTask(BasicChannelBroker broker) {
            super(broker);
        }

        @Override
        boolean doTask(BasicChannelBroker broker) {
            return broker.pingCheck();
        }
    }

    private static class DoPingTask
    extends PingTask {
        DoPingTask(BasicChannelBroker broker) {
            super(broker);
        }

        @Override
        boolean doTask(BasicChannelBroker broker) throws IOException {
            if (broker.doPing()) {
                broker.pinged();
                return true;
            }
            return false;
        }
    }

    private static abstract class PingTask
    extends ScheduledTask<RuntimeException> {
        private final WeakReference<BasicChannelBroker> mBrokerRef;
        private volatile Future<?> mScheduled;

        PingTask(BasicChannelBroker broker) {
            this.mBrokerRef = new WeakReference<BasicChannelBroker>(broker);
        }

        @Override
        protected void doRun() {
            BasicChannelBroker broker = (BasicChannelBroker)this.mBrokerRef.get();
            if (broker != null) {
                try {
                    if (this.doTask(broker)) {
                        return;
                    }
                    broker.close(new ClosedException("Ping failure"));
                }
                catch (IOException e) {
                    broker.close(new ClosedException("Ping failure", e));
                }
            }
            this.mScheduled.cancel(true);
        }

        void scheduled(Future<?> scheduled) {
            this.mScheduled = scheduled;
        }

        abstract boolean doTask(BasicChannelBroker var1) throws IOException;
    }
}

