/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.BasicChannelBroker;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.ChannelBroker;
import org.cojen.dirmi.io.ChannelBrokerAcceptor;
import org.cojen.dirmi.io.ChannelConnectWaiter;
import org.cojen.dirmi.io.ChannelConnector;
import org.cojen.dirmi.io.ChannelTimeout;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.ListenerQueue;
import org.cojen.dirmi.io.Waiter;
import org.cojen.dirmi.util.Timer;
import org.cojen.util.ThrowUnchecked;

public class BasicChannelBrokerAcceptor
implements ChannelBrokerAcceptor {
    static final byte OPEN_REQUEST = 1;
    static final byte ACCEPT_REQUEST = 3;
    static final byte CONNECT_REQUEST = 5;
    static final byte CONNECT_RESPONSE = 6;
    static final byte PING_REQUEST = 7;
    static final byte PING_RESPONSE = 8;
    static final byte ACCEPT_CONFIRM_REQUEST = 9;
    static final byte ACCEPT_SUCCESS_RESPONSE = 10;
    static final byte ACCEPT_FAILED_RESPONSE = 11;
    private final IOExecutor mExecutor;
    private final ChannelAcceptor mAcceptor;
    private final SecureRandom mRandom;
    private final ChannelAcceptor.Listener mBrokerListener;
    private final Map<Long, Broker> mAcceptedBrokers;
    private boolean mClosed;
    private final ListenerQueue<ChannelBrokerAcceptor.Listener> mAcceptListenerQueue;
    private boolean mNotListening;

    public BasicChannelBrokerAcceptor(IOExecutor executor, ChannelAcceptor acceptor) {
        this.mExecutor = executor;
        this.mAcceptor = acceptor;
        this.mRandom = new SecureRandom();
        this.mAcceptedBrokers = new HashMap<Long, Broker>();
        this.mAcceptListenerQueue = new ListenerQueue<ChannelBrokerAcceptor.Listener>(this.mExecutor, ChannelBrokerAcceptor.Listener.class);
        this.mBrokerListener = new ChannelAcceptor.Listener(){

            @Override
            public void accepted(Channel channel) {
                ChannelBroker broker;
                BasicChannelBrokerAcceptor.this.mAcceptor.accept(this);
                try {
                    broker = BasicChannelBrokerAcceptor.this.accepted(channel);
                }
                catch (IOException e) {
                    channel.disconnect();
                    ((ChannelBrokerAcceptor.Listener)BasicChannelBrokerAcceptor.this.mAcceptListenerQueue.dequeue()).failed(e);
                    return;
                }
                if (broker != null) {
                    ((ChannelBrokerAcceptor.Listener)BasicChannelBrokerAcceptor.this.mAcceptListenerQueue.dequeue()).accepted(broker);
                }
            }

            @Override
            public void rejected(RejectedException e) {
                BasicChannelBrokerAcceptor.this.notListening();
                ((ChannelBrokerAcceptor.Listener)BasicChannelBrokerAcceptor.this.mAcceptListenerQueue.dequeue()).rejected(e);
            }

            @Override
            public void failed(IOException e) {
                BasicChannelBrokerAcceptor.this.notListening();
                ((ChannelBrokerAcceptor.Listener)BasicChannelBrokerAcceptor.this.mAcceptListenerQueue.dequeue()).failed(e);
            }

            @Override
            public void closed(IOException e) {
                BasicChannelBrokerAcceptor.this.notListening();
                ((ChannelBrokerAcceptor.Listener)BasicChannelBrokerAcceptor.this.mAcceptListenerQueue.dequeueForClose()).closed(e);
            }
        };
        this.mAcceptor.accept(this.mBrokerListener);
    }

    @Override
    public Object getLocalAddress() {
        return this.mAcceptor.getLocalAddress();
    }

    @Override
    public ChannelBroker accept() throws IOException {
        AcceptListener listener = new AcceptListener();
        this.accept(listener);
        return listener.waitForBroker();
    }

    @Override
    public ChannelBroker accept(long timeout, TimeUnit unit) throws IOException {
        AcceptListener listener = new AcceptListener();
        this.accept(listener);
        return listener.waitForBroker(timeout, unit);
    }

    @Override
    public ChannelBroker accept(Timer timer) throws IOException {
        return this.accept(RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(ChannelBrokerAcceptor.Listener listener) {
        BasicChannelBrokerAcceptor basicChannelBrokerAcceptor = this;
        synchronized (basicChannelBrokerAcceptor) {
            if (this.mNotListening) {
                this.mNotListening = false;
                try {
                    this.mAcceptor.accept(this.mBrokerListener);
                }
                catch (Throwable e) {
                    this.mNotListening = true;
                    ThrowUnchecked.fire((Throwable)e);
                }
            }
        }
        try {
            this.mAcceptListenerQueue.enqueue(listener);
        }
        catch (RejectedException e) {
            this.mAcceptListenerQueue.dequeue().rejected(e);
        }
    }

    synchronized void notListening() {
        this.mNotListening = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<Long, Broker> copy;
        this.mAcceptor.close();
        Map<Long, Broker> map = this.mAcceptedBrokers;
        synchronized (map) {
            this.mClosed = true;
            copy = new HashMap<Long, Broker>(this.mAcceptedBrokers);
            this.mAcceptedBrokers.clear();
        }
        for (Broker broker : copy.values()) {
            broker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelBroker accepted(Channel channel) throws IOException {
        Broker broker;
        long id;
        int op;
        ChannelTimeout timeout = new ChannelTimeout(this.mExecutor, channel, 15L, TimeUnit.SECONDS);
        try {
            InputStream in = channel.getInputStream();
            op = in.read();
            if (op == 1) {
                Broker broker2;
                long id2;
                Map<Long, Broker> map = this.mAcceptedBrokers;
                synchronized (map) {
                    if (this.mClosed) {
                        throw new ClosedException("ChannelBrokerAcceptor is closed");
                    }
                    while (this.mAcceptedBrokers.containsKey(id2 = this.mRandom.nextLong())) {
                    }
                    broker2 = new Broker(id2, channel);
                    this.mAcceptedBrokers.put(id2, broker2);
                }
                try {
                    DataOutputStream dout = new DataOutputStream(channel.getOutputStream());
                    dout.writeLong(id2);
                    dout.flush();
                    Broker broker3 = broker2;
                    return broker3;
                }
                catch (IOException e) {
                    broker2.close();
                    throw e;
                }
            }
            if (op != 3 && op != 6 && op != 9) {
                if (op < 0) {
                    throw new ClosedException("Accepted channel is closed");
                }
                throw new IOException("Invalid operation from accepted channel: " + op);
            }
            id = new DataInputStream(in).readLong();
        }
        finally {
            timeout.cancel();
        }
        Map<Long, Broker> map = this.mAcceptedBrokers;
        synchronized (map) {
            broker = this.mAcceptedBrokers.get(id);
            if (broker == null && this.mClosed) {
                throw new ClosedException("ChannelBrokerAcceptor is closed");
            }
        }
        if (broker == null) {
            if (op == 6) {
                throw new IOException("Reverse connect refers to an unknown session: " + id);
            }
            if (op == 9) {
                channel.getOutputStream().write(11);
                channel.getOutputStream().flush();
            }
            throw new IOException("Accepted connection refers to an unknown session: " + id);
        }
        if (op == 6) {
            broker.connected(channel);
        } else if (op == 9) {
            channel.getOutputStream().write(10);
            channel.getOutputStream().flush();
            broker.accepted(channel);
        } else {
            broker.accepted(channel);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBroker(final long id, final Broker broker, boolean immediate) {
        Map<Long, Broker> map = this.mAcceptedBrokers;
        synchronized (map) {
            if (this.mAcceptedBrokers.get(id) == broker) {
                if (!immediate) {
                    try {
                        this.mExecutor.schedule(new Runnable(){

                            @Override
                            public void run() {
                                BasicChannelBrokerAcceptor.this.removeBroker(id, broker, true);
                            }
                        }, 10L, TimeUnit.SECONDS);
                        return;
                    }
                    catch (RejectedException e) {
                        // empty catch block
                    }
                }
                this.mAcceptedBrokers.remove(id);
            }
        }
    }

    private static class AcceptListener
    implements ChannelBrokerAcceptor.Listener {
        private final Waiter<ChannelBroker> mWaiter = Waiter.create();

        private AcceptListener() {
        }

        @Override
        public void accepted(ChannelBroker broker) {
            this.mWaiter.available(broker);
        }

        @Override
        public void rejected(RejectedException e) {
            this.mWaiter.rejected(e);
        }

        @Override
        public void failed(IOException e) {
            this.mWaiter.failed(e);
        }

        @Override
        public void closed(IOException e) {
            this.mWaiter.closed(e);
        }

        ChannelBroker waitForBroker() throws IOException {
            return this.mWaiter.waitFor();
        }

        ChannelBroker waitForBroker(long timeout, TimeUnit unit) throws IOException {
            return this.mWaiter.waitFor(timeout, unit);
        }
    }

    private class Broker
    extends BasicChannelBroker {
        private final ListenerQueue<ChannelConnector.Listener> mListenerQueue;

        Broker(long id, Channel control) throws RejectedException {
            super(BasicChannelBrokerAcceptor.this.mExecutor, id, control);
            this.mListenerQueue = new ListenerQueue<ChannelConnector.Listener>(BasicChannelBrokerAcceptor.this.mExecutor, ChannelConnector.Listener.class);
        }

        @Override
        public Channel connect() throws IOException {
            return this.connect(15L, TimeUnit.SECONDS);
        }

        @Override
        public Channel connect(long timeout, TimeUnit unit) throws IOException {
            this.mAllChannels.checkClosed();
            ChannelConnectWaiter listener = new ChannelConnectWaiter();
            this.connect(listener);
            return listener.waitForChannel(timeout, unit);
        }

        @Override
        public void connect(ChannelConnector.Listener listener) {
            if (this.mAllChannels.isClosed()) {
                listener.closed(new ClosedException());
                return;
            }
            try {
                this.mListenerQueue.enqueue(listener);
            }
            catch (RejectedException e) {
                this.dequeueConnectListener().rejected(e);
                return;
            }
            this.mControl.outputNotify(new Channel.Listener(){

                @Override
                public void ready() {
                    try {
                        Broker.this.mControl.getOutputStream().write(5);
                        Broker.this.mControl.flush();
                    }
                    catch (IOException e) {
                        Broker.this.dequeueConnectListener().failed(e);
                        return;
                    }
                }

                @Override
                public void rejected(RejectedException e) {
                    Broker.this.dequeueConnectListener().rejected(e);
                }

                @Override
                public void closed(IOException e) {
                    Broker.this.dequeueConnectListenerForClose().closed(e);
                }
            });
        }

        @Override
        public void close() {
            BasicChannelBrokerAcceptor.this.removeBroker(this.mId, this, false);
            if (!this.mAllChannels.isClosed()) {
                this.dequeueConnectListenerForClose().failed(new ClosedException());
                super.close();
            }
        }

        @Override
        protected boolean requirePingTask() {
            return true;
        }

        @Override
        protected boolean doPing() throws IOException {
            if (cPingLogger != null) {
                this.logPingMessage("Ping request to " + this.mControl);
            }
            try {
                this.mControl.getOutputStream().write(7);
                this.mControl.flush();
                int response = this.mControl.getInputStream().read();
                if (cPingLogger != null) {
                    this.logPingMessage("Ping response from " + this.mControl + ": " + response);
                }
                return response == 8;
            }
            catch (IOException e) {
                if (cPingLogger != null) {
                    this.logPingMessage("Ping response failure from " + this.mControl + ": " + e);
                }
                throw e;
            }
        }

        ChannelConnector.Listener dequeueConnectListener() {
            return this.mListenerQueue.dequeue();
        }

        ChannelConnector.Listener dequeueConnectListenerForClose() {
            return this.mListenerQueue.dequeueForClose();
        }

        void connected(Channel channel) {
            channel.register(this.mAllChannels);
            this.dequeueConnectListener().connected(channel);
        }
    }
}

