/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelInputStream;
import org.cojen.dirmi.io.IOExecutor;

public class BufferedInputStream
extends ChannelInputStream {
    static final int DEFAULT_SIZE = 8192;
    private final InputStream mIn;
    private byte[] mBuffer;
    private int mStart;
    private int mEnd;

    public BufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedInputStream(InputStream in, int size) {
        this.mIn = in;
        BufferedInputStream bufferedInputStream = this;
        synchronized (bufferedInputStream) {
            this.mBuffer = new byte[size];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        try {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                byte[] buffer = this.buffer();
                int start = this.mStart;
                if (this.mEnd - start > 0) {
                    this.mStart = start + 1;
                    return buffer[start] & 0xFF;
                }
                int amt = this.mIn.read(buffer, 0, buffer.length);
                if (amt <= 0) {
                    return -1;
                }
                this.mStart = 1;
                this.mEnd = amt;
                return buffer[0] & 0xFF;
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        BufferedInputStream bufferedInputStream = this;
        synchronized (bufferedInputStream) {
            byte[] buffer = this.buffer();
            int start = this.mStart;
            int avail = this.mEnd - start;
            if (avail >= len) {
                System.arraycopy(buffer, start, b, off, len);
                this.mStart = start + len;
                return len;
            }
            System.arraycopy(buffer, start, b, off, avail);
            this.mStart = 0;
            this.mEnd = 0;
            off += avail;
            len -= avail;
            try {
                if (avail > 0 && (len = Math.min(len, this.mIn.available())) <= 0) {
                    return avail;
                }
                if (len >= buffer.length) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 5, 11] lbl23 : MonitorExitStatement: MONITOREXIT : var4_4
                    int amt = this.mIn.read(b, off, len);
                    return amt <= 0 ? (avail <= 0 ? -1 : avail) : avail + amt;
                }
                int amt = this.mIn.read(buffer, 0, buffer.length);
                if (amt <= 0) {
                    return avail <= 0 ? -1 : avail;
                }
                int fill = Math.min(amt, len);
                System.arraycopy(buffer, 0, b, off, fill);
                this.mStart = fill;
                this.mEnd = amt;
                return avail + fill;
            }
            catch (IOException e) {
                try {
                    if (avail > 0) {
                        return avail;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IOException e2) {
                        this.disconnect();
                        throw e2;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        try {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                int avail;
                this.buffer();
                if (n > 0L && (avail = this.mEnd - this.mStart) > 0) {
                    long skipped = (long)avail < n ? (long)avail : n;
                    this.mStart = (int)((long)this.mStart + skipped);
                    return skipped;
                }
                return this.mIn.skip(n);
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        try {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                this.buffer();
                return this.mEnd - this.mStart + this.mIn.available();
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() throws IOException {
        try {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                this.buffer();
                return this.mEnd - this.mStart > 0 || this.mIn.available() > 0;
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public synchronized int setBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer too small: " + size);
        }
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            return 0;
        }
        int avail = this.mEnd - this.mStart;
        if (size < buffer.length) {
            size = Math.max(size, avail);
        }
        if (size != buffer.length) {
            byte[] newBuffer = new byte[size];
            System.arraycopy(buffer, this.mStart, newBuffer, 0, avail);
            this.mBuffer = newBuffer;
            this.mStart = 0;
            this.mEnd = avail;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() throws IOException {
        try {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                byte[] buffer = this.buffer();
                int avail = this.mEnd - this.mStart;
                if (avail == 0) {
                    int amt = this.mIn.read(buffer, 0, buffer.length);
                    if (amt <= 0) {
                        throw new EOFException();
                    }
                    this.mStart = 0;
                    this.mEnd = amt;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    void inputNotify(IOExecutor executor, final Channel.Listener listener) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedInputStream.this.fill();
                        listener.ready();
                    }
                    catch (IOException e) {
                        listener.closed(e);
                    }
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.inputClose();
    }

    @Override
    public void disconnect() {
        this.inputDisconnect();
    }

    @Override
    public boolean inputResume() {
        return false;
    }

    @Override
    public boolean isResumeSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void inputClose() throws IOException {
        try {
            try {
                this.mIn.close();
            }
            catch (IOException e) {
                BufferedInputStream bufferedInputStream = this;
                synchronized (bufferedInputStream) {
                    if (this.mBuffer != null) {
                        throw e;
                    }
                }
            }
        }
        finally {
            BufferedInputStream bufferedInputStream = this;
            synchronized (bufferedInputStream) {
                this.mBuffer = null;
            }
        }
    }

    @Override
    final void inputDisconnect() {
        try {
            this.inputClose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] buffer() throws ClosedException {
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            throw new ClosedException();
        }
        return buffer;
    }
}

