/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.OutputStream;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelOutputStream;
import org.cojen.dirmi.io.IOExecutor;

public class BufferedOutputStream
extends ChannelOutputStream {
    static final int DEFAULT_SIZE = 8192;
    private final OutputStream mOut;
    private byte[] mBuffer;
    private int mPos;
    private volatile boolean mWriting;

    public BufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedOutputStream(OutputStream out, int size) {
        this.mOut = out;
        BufferedOutputStream bufferedOutputStream = this;
        synchronized (bufferedOutputStream) {
            this.mBuffer = new byte[size];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        try {
            BufferedOutputStream bufferedOutputStream = this;
            synchronized (bufferedOutputStream) {
                byte[] buffer = this.buffer();
                int pos = this.mPos;
                buffer[pos++] = (byte)b;
                if (pos >= buffer.length) {
                    this.doWrite(buffer, 0, buffer.length);
                    this.mPos = 0;
                } else {
                    this.mPos = pos;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            BufferedOutputStream bufferedOutputStream = this;
            synchronized (bufferedOutputStream) {
                byte[] buffer = this.buffer();
                int pos = this.mPos;
                int avail = buffer.length - pos;
                if (avail >= len) {
                    if (pos == 0 && avail == len) {
                        this.doWrite(b, off, len);
                    } else {
                        System.arraycopy(b, off, buffer, pos, len);
                        if (avail == len) {
                            this.doWrite(buffer, 0, buffer.length);
                            this.mPos = 0;
                        } else {
                            this.mPos = pos + len;
                        }
                    }
                } else {
                    System.arraycopy(b, off, buffer, pos, avail);
                    off += avail;
                    len -= avail;
                    avail = buffer.length;
                    this.doWrite(buffer, 0, avail);
                    if (len >= avail) {
                        this.doWrite(b, off, len);
                        this.mPos = 0;
                    } else {
                        System.arraycopy(b, off, buffer, 0, len);
                        this.mPos = len;
                    }
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public synchronized boolean isReady() throws IOException {
        return this.buffer().length - this.mPos - 1 > 0;
    }

    @Override
    public synchronized int setBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer too small: " + size);
        }
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            return 0;
        }
        if (size < buffer.length) {
            size = Math.max(size, this.mPos);
        }
        if (size != buffer.length) {
            byte[] newBuffer = new byte[size];
            System.arraycopy(buffer, 0, newBuffer, 0, this.mPos);
            this.mBuffer = newBuffer;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() throws IOException {
        try {
            BufferedOutputStream bufferedOutputStream = this;
            synchronized (bufferedOutputStream) {
                byte[] buffer = this.buffer();
                int pos = this.mPos;
                int avail = buffer.length - pos - 1;
                if (avail == 0) {
                    this.doWrite(buffer, 0, pos);
                    this.mPos = 0;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    void outputNotify(IOExecutor executor, final Channel.Listener listener) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BufferedOutputStream.this.drain();
                        listener.ready();
                    }
                    catch (IOException e) {
                        listener.closed(e);
                    }
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            BufferedOutputStream bufferedOutputStream = this;
            synchronized (bufferedOutputStream) {
                byte[] buffer = this.mBuffer;
                if (buffer == null) {
                    return;
                }
                int pos = this.mPos;
                if (pos <= buffer.length) {
                    if (pos > 0) {
                        this.doWrite(buffer, 0, pos);
                        this.mPos = 0;
                    }
                    this.mWriting = true;
                    try {
                        this.mOut.flush();
                    }
                    finally {
                        this.mWriting = false;
                    }
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.outputClose();
    }

    @Override
    public void disconnect() {
        this.outputDisconnect();
    }

    @Override
    public boolean outputSuspend() throws IOException {
        this.flush();
        return false;
    }

    @Override
    final void outputClose() throws IOException {
        this.close(!this.mWriting);
    }

    @Override
    final void outputDisconnect() {
        try {
            this.close(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean flush) throws IOException {
        try {
            if (flush) {
                BufferedOutputStream bufferedOutputStream = this;
                synchronized (bufferedOutputStream) {
                    block24: {
                        if (this.mBuffer != null) break block24;
                        return;
                    }
                    this.flush();
                }
            }
            try {
                this.mOut.close();
            }
            catch (IOException e) {
                BufferedOutputStream bufferedOutputStream = this;
                synchronized (bufferedOutputStream) {
                    if (this.mBuffer != null) {
                        throw e;
                    }
                }
            }
        }
        finally {
            BufferedOutputStream bufferedOutputStream = this;
            synchronized (bufferedOutputStream) {
                this.mBuffer = null;
                this.mWriting = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(byte[] buffer, int offset, int length) throws IOException {
        this.mWriting = true;
        try {
            this.mOut.write(buffer, offset, length);
        }
        finally {
            this.mWriting = false;
        }
    }

    private byte[] buffer() throws ClosedException {
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            throw new ClosedException();
        }
        return buffer;
    }
}

