/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.util.ScheduledTask;
import org.cojen.dirmi.util.Timer;

class ChannelTimeout
extends ScheduledTask<RuntimeException> {
    private final Channel mChannel;
    private final Timer mTimer;
    private final Future<?> mFuture;
    private int mState;

    ChannelTimeout(IOExecutor executor, Channel channel, long timeout, TimeUnit unit) throws IOException {
        this(executor, channel, new Timer(timeout, unit));
    }

    ChannelTimeout(IOExecutor executor, Channel channel, Timer timer) throws IOException {
        this.mChannel = channel;
        this.mTimer = timer;
        this.mFuture = executor.schedule(this, RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws RemoteTimeoutException {
        ChannelTimeout channelTimeout = this;
        synchronized (channelTimeout) {
            if (this.mState == 2) {
                throw new RemoteTimeoutException(this.mTimer);
            }
            this.mState = 1;
        }
        this.mFuture.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        ChannelTimeout channelTimeout = this;
        synchronized (channelTimeout) {
            if (this.mState != 0) {
                return;
            }
            this.mState = 2;
        }
        this.mChannel.disconnect();
    }
}

