/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.io.Channel;

public class CloseableGroup<C extends Closeable>
implements Closeable {
    private final Map<C, Object> mGroup = new HashMap<C, Object>();
    private boolean mClosed;

    public synchronized boolean isClosed() {
        return this.mClosed;
    }

    public synchronized void checkClosed() throws ClosedException {
        if (this.mClosed) {
            throw new ClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(C member) {
        CloseableGroup closeableGroup = this;
        synchronized (closeableGroup) {
            if (!this.mClosed) {
                this.mGroup.put(member, "");
                return true;
            }
        }
        try {
            member.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void remove(C member) {
        this.mGroup.remove(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        HashMap<C, Object> copy;
        CloseableGroup closeableGroup = this;
        synchronized (closeableGroup) {
            this.mClosed = true;
            copy = new HashMap<C, Object>(this.mGroup);
            this.mGroup.clear();
        }
        for (Closeable c : copy.keySet()) {
            try {
                c.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        HashMap<C, Object> copy;
        CloseableGroup closeableGroup = this;
        synchronized (closeableGroup) {
            this.mClosed = true;
            copy = new HashMap<C, Object>(this.mGroup);
            this.mGroup.clear();
        }
        for (Closeable c : copy.keySet()) {
            ((Channel)c).disconnect();
        }
    }

    public synchronized String toString() {
        return "CloseableGroup: " + this.mGroup.keySet();
    }
}

