/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.RejectedException;

public class IOExecutor {
    private final ScheduledExecutorService mExecutor;

    public IOExecutor(ScheduledExecutorService executor) {
        if (executor == null) {
            throw new IllegalArgumentException();
        }
        this.mExecutor = executor;
    }

    public void execute(Runnable command) throws RejectedException {
        try {
            this.mExecutor.execute(command);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public <T> Future<T> submit(Callable<T> task) throws RejectedException {
        try {
            return this.mExecutor.submit(task);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public <T> Future<T> submit(Runnable task, T result) throws RejectedException {
        try {
            return this.mExecutor.submit(task, result);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public Future<?> submit(Runnable task) throws RejectedException {
        try {
            return this.mExecutor.submit(task);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) throws RejectedException {
        try {
            return this.mExecutor.schedule(command, delay, unit);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) throws RejectedException {
        try {
            return this.mExecutor.schedule(callable, delay, unit);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) throws RejectedException {
        try {
            return this.mExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) throws RejectedException {
        try {
            return this.mExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
        catch (RejectedExecutionException e) {
            throw new RejectedException(this.mExecutor.isShutdown(), (Throwable)e);
        }
    }
}

