/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.util.ScheduledTask;
import org.cojen.util.ThrowUnchecked;

class ListenerQueue<L> {
    private final IOExecutor mExecutor;
    private final Constructor<L> mListenerProxyCtor;
    private final Deque<L> mListenerQueue;
    private final Deque<Handoff> mHandoffQueue;

    ListenerQueue(IOExecutor executor, Class<L> listenerType) {
        this.mExecutor = executor;
        try {
            this.mListenerProxyCtor = Proxy.getProxyClass(listenerType.getClassLoader(), listenerType).getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
        this.mListenerQueue = new LinkedList<L>();
        this.mHandoffQueue = new LinkedList<Handoff>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(L listener) throws RejectedException {
        L handoffListener;
        Handoff handoff;
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            this.mListenerQueue.add(listener);
            handoff = this.mHandoffQueue.poll();
            if (handoff == null) {
                return;
            }
            handoffListener = this.mListenerQueue.remove();
        }
        ScheduledTask<RuntimeException> command = new ScheduledTask<RuntimeException>(){

            @Override
            protected void doRun() {
                if (handoff.handoff(handoffListener)) {
                    ListenerQueue.this.enqueue(handoff);
                }
            }
        };
        try {
            this.mExecutor.execute(command);
        }
        catch (RejectedException e) {
            try {
                this.mExecutor.schedule(command, 0L, TimeUnit.SECONDS);
                return;
            }
            catch (RejectedException e2) {
                ListenerQueue listenerQueue2 = this;
                synchronized (listenerQueue2) {
                    this.mHandoffQueue.addFirst(handoff);
                    this.mListenerQueue.addFirst(handoffListener);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L dequeue() {
        ListenerQueue listenerQueue = this;
        synchronized (listenerQueue) {
            L listener = this.mListenerQueue.poll();
            if (listener != null) {
                return listener;
            }
        }
        try {
            return this.mListenerProxyCtor.newInstance(new Handoff());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public L dequeueForClose() {
        try {
            return this.mListenerProxyCtor.newInstance(new Closer());
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(Handoff handoff) {
        L listener;
        do {
            ListenerQueue listenerQueue = this;
            synchronized (listenerQueue) {
                this.mHandoffQueue.add(handoff);
                listener = this.mListenerQueue.poll();
                if (listener == null) {
                    return;
                }
                handoff = this.mHandoffQueue.remove();
            }
        } while (handoff.handoff(listener));
    }

    private class Closer
    extends Handoff {
        private Closer() {
        }

        @Override
        boolean handoff(L listener) {
            super.handoff(listener);
            return true;
        }
    }

    private class Handoff
    implements InvocationHandler {
        private Method mMethod;
        private Object[] mArgs;

        private Handoff() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Handoff handoff = this;
            synchronized (handoff) {
                if (this.mMethod != null) {
                    throw new IllegalStateException("Already invoked listener");
                }
                this.mMethod = method;
                this.mArgs = args;
            }
            ListenerQueue.this.enqueue(this);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean handoff(L listener) {
            Object[] args;
            Method method;
            Handoff handoff = this;
            synchronized (handoff) {
                method = this.mMethod;
                args = this.mArgs;
            }
            try {
                method.invoke(listener, args);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (InvocationTargetException e) {
                ThrowUnchecked.fireCause((Throwable)e);
            }
            return false;
        }
    }
}

