/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.NioSocketChannel;
import org.cojen.dirmi.io.RecyclableSocketChannel;

class NioRecyclableSocketChannel
extends RecyclableSocketChannel {
    NioRecyclableSocketChannel(IOExecutor executor, NioSocketChannel channel) throws IOException {
        super(executor, channel);
    }

    NioRecyclableSocketChannel(NioRecyclableSocketChannel channel, RecyclableSocketChannel.Input in, RecyclableSocketChannel.Output out) {
        super(channel, in, out);
    }

    @Override
    protected NioRecyclableSocketChannel newRecycledChannel(RecyclableSocketChannel.Input in, RecyclableSocketChannel.Output out) {
        return new NioRecyclableSocketChannel(this, in, out);
    }

    @Override
    public boolean usesSelectNotification() {
        return true;
    }

    @Override
    public void inputNotify(Channel.Listener listener) {
        try {
            if (this.isInputReady()) {
                this.ready(listener);
            } else {
                ((NioSocketChannel)this.socket()).inputNotify(listener);
            }
        }
        catch (IOException e) {
            this.closed(listener, e);
        }
    }

    @Override
    public void outputNotify(Channel.Listener listener) {
        try {
            if (this.isOutputReady()) {
                this.ready(listener);
            } else {
                ((NioSocketChannel)this.socket()).outputNotify(listener);
            }
        }
        catch (IOException e) {
            this.closed(listener, e);
        }
    }

    private void ready(final Channel.Listener listener) {
        try {
            this.executor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.ready();
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    private void closed(final Channel.Listener listener, final IOException cause) {
        try {
            this.executor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.closed(cause);
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }
}

