/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.SimpleSocket;
import org.cojen.dirmi.io.SocketChannelSelector;

class NioSocketChannel
implements SimpleSocket {
    final SocketChannelSelector mSelector;
    final SocketChannel mChannel;
    private final Input mIn;
    private final Output mOut;

    NioSocketChannel(SocketChannelSelector selector, SocketChannel channel) {
        try {
            channel.socket().setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.mSelector = selector;
        this.mChannel = channel;
        this.mIn = new Input();
        this.mOut = new Output();
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.mChannel.close();
        }
        finally {
            this.mIn.ready();
            this.mOut.ready();
        }
    }

    @Override
    public Object getLocalAddress() {
        return this.mChannel.socket().getLocalSocketAddress();
    }

    @Override
    public Object getRemoteAddress() {
        return this.mChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public InputStream getInputStream() {
        return this.mIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.mOut;
    }

    public void inputNotify(Channel.Listener listener) {
        this.mSelector.inputNotify(this.mChannel, listener);
    }

    public void outputNotify(Channel.Listener listener) {
        this.mSelector.outputNotify(this.mChannel, listener);
    }

    private static class Ready
    extends IOException {
        static final Ready THE = new Ready();

        private Ready() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private class Output
    extends OutputStream
    implements Channel.Listener {
        private ByteBuffer mBuffer;
        private byte[] mWrapped;
        private IOException mNotify;

        private Output() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int amt;
            ByteBuffer buffer;
            if (this.mWrapped == b) {
                buffer = this.mBuffer;
            } else {
                this.mBuffer = buffer = ByteBuffer.wrap(b);
                this.mWrapped = b;
            }
            buffer.position(off).limit(off + len);
            SocketChannel channel = NioSocketChannel.this.mChannel;
            while ((amt = channel.write(buffer)) < len) {
                len -= amt;
                NioSocketChannel.this.mSelector.outputNotify(channel, this);
                Output output = this;
                synchronized (output) {
                    IOException ex;
                    while ((ex = this.mNotify) == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                    this.mNotify = null;
                    if (ex != Ready.THE) {
                        ex.fillInStackTrace();
                        throw ex;
                    }
                }
            }
        }

        @Override
        public void close() throws IOException {
            NioSocketChannel.this.close();
        }

        @Override
        public synchronized void ready() {
            if (this.mNotify == null) {
                this.mNotify = Ready.THE;
            }
            this.notifyAll();
        }

        @Override
        public void rejected(RejectedException cause) {
            try {
                NioSocketChannel.this.mChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed(cause);
        }

        @Override
        public synchronized void closed(IOException cause) {
            this.mNotify = cause;
            this.notifyAll();
        }
    }

    private class Input
    extends InputStream
    implements Channel.Listener {
        private ByteBuffer mBuffer;
        private byte[] mWrapped;
        private IOException mNotify;

        private Input() {
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b, 0, 1) <= 0 ? -1 : b[0] & 0xFF;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int amt;
            ByteBuffer buffer;
            if (this.mWrapped == b) {
                buffer = this.mBuffer;
            } else {
                this.mBuffer = buffer = ByteBuffer.wrap(b);
                this.mWrapped = b;
            }
            buffer.position(off).limit(off + len);
            SocketChannel channel = NioSocketChannel.this.mChannel;
            while ((amt = channel.read(buffer)) == 0) {
                NioSocketChannel.this.mSelector.inputNotify(channel, this);
                Input input = this;
                synchronized (input) {
                    IOException ex;
                    while ((ex = this.mNotify) == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException();
                        }
                    }
                    this.mNotify = null;
                    if (ex != Ready.THE) {
                        ex.fillInStackTrace();
                        throw ex;
                    }
                }
            }
            return amt;
        }

        @Override
        public void close() throws IOException {
            NioSocketChannel.this.close();
        }

        @Override
        public synchronized void ready() {
            if (this.mNotify == null) {
                this.mNotify = Ready.THE;
            }
            this.notifyAll();
        }

        @Override
        public void rejected(RejectedException cause) {
            try {
                NioSocketChannel.this.mChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.closed(cause);
        }

        @Override
        public synchronized void closed(IOException cause) {
            this.mNotify = cause;
            this.notifyAll();
        }
    }
}

