/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelInputStream;
import org.cojen.dirmi.io.IOExecutor;

abstract class PacketInputStream<P extends PacketInputStream<P>>
extends ChannelInputStream {
    private static final AtomicReferenceFieldUpdater<PacketInputStream, InputStream> inUpdater = AtomicReferenceFieldUpdater.newUpdater(PacketInputStream.class, InputStream.class, "mIn");
    static final int DEFAULT_SIZE = 8192;
    volatile InputStream mIn;
    byte[] mBuffer;
    int mStart;
    int mEnd;
    private int mPacketSize;

    public PacketInputStream(InputStream in) {
        this(in, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketInputStream(InputStream in, int size) {
        this.mIn = in;
        PacketInputStream packetInputStream = this;
        synchronized (packetInputStream) {
            this.mBuffer = new byte[size];
        }
    }

    protected PacketInputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                InputStream in = this.in();
                int packetSize = this.mPacketSize;
                if (packetSize < 0) {
                    return -1;
                }
                byte[] buffer = this.mBuffer;
                int b = this.readFrom(in, buffer);
                if (b < 0) {
                    this.mPacketSize = -2;
                    return b;
                }
                if (--packetSize >= 0) {
                    this.mPacketSize = packetSize;
                    return b;
                }
                if (b == 0) {
                    this.mPacketSize = -1;
                    return -1;
                }
                int b2 = this.readFrom(in, buffer);
                if (b2 < 0) {
                    this.mPacketSize = -2;
                    return -1;
                }
                if (b < 128) {
                    this.mPacketSize = b - 1;
                    return b2;
                }
                int b3 = this.readFrom(in, buffer);
                if (b3 < 0) {
                    this.mPacketSize = -2;
                    return -1;
                }
                this.mPacketSize = ((b & 0x7F) << 8 | b2) + 127;
                return b3;
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private int readFrom(InputStream in, byte[] buffer) throws IOException {
        if (buffer == null) {
            throw new ClosedException();
        }
        int start = this.mStart;
        if (this.mEnd - start > 0) {
            this.mStart = start + 1;
            return buffer[start] & 0xFF;
        }
        int amt = in.read(buffer, 0, buffer.length);
        if (amt <= 0) {
            return -1;
        }
        this.mStart = 1;
        this.mEnd = amt;
        return buffer[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                int amt;
                InputStream in = this.in();
                byte[] buffer = this.mBuffer;
                int packetSize = this.mPacketSize;
                if (packetSize <= 0) {
                    if (packetSize < 0) {
                        return -1;
                    }
                    int b1 = this.readFrom(in, buffer);
                    if (b1 <= 0) {
                        this.mPacketSize = b1 == 0 ? -1 : -2;
                        return -1;
                    }
                    if (b1 < 128) {
                        packetSize = b1;
                    } else {
                        int b2 = this.readFrom(in, buffer);
                        if (b2 < 0) {
                            this.mPacketSize = -2;
                            return -1;
                        }
                        packetSize = ((b1 & 0x7F) << 8 | b2) + 128;
                    }
                }
                if ((amt = this.readFrom(in, buffer, b, off, len > packetSize ? packetSize : len)) < 0) {
                    this.mPacketSize = -2;
                    return -1;
                }
                this.mPacketSize = packetSize - amt;
                return amt;
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private int readFrom(InputStream in, byte[] buffer, byte[] b, int off, int len) throws IOException {
        int start = this.mStart;
        int avail = this.mEnd - start;
        if (avail >= len) {
            System.arraycopy(buffer, start, b, off, len);
            this.mStart = start + len;
            return len;
        }
        System.arraycopy(buffer, start, b, off, avail);
        this.mStart = 0;
        this.mEnd = 0;
        off += avail;
        len -= avail;
        try {
            if (avail > 0 && (len = Math.min(len, in.available())) <= 0) {
                return avail;
            }
            if (len >= buffer.length) {
                int amt = in.read(b, off, len);
                return amt <= 0 ? (avail <= 0 ? -1 : avail) : avail + amt;
            }
            int amt = in.read(buffer, 0, buffer.length);
            if (amt <= 0) {
                return avail <= 0 ? -1 : avail;
            }
            int fill = Math.min(amt, len);
            System.arraycopy(buffer, 0, b, off, fill);
            this.mStart = fill;
            this.mEnd = amt;
            return avail + fill;
        }
        catch (IOException e) {
            if (avail > 0) {
                return avail;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                InputStream in = this.in();
                if (n <= 0L) {
                    return 0L;
                }
                if (n > Integer.MAX_VALUE) {
                    n = Integer.MAX_VALUE;
                }
                return this.skip(in, (int)n);
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    private int skip(InputStream in, int n) throws IOException {
        int amt;
        int packetSize = this.mPacketSize;
        if (packetSize <= 0) {
            if (packetSize < 0) {
                return 0;
            }
            int b1 = this.readFrom(in, this.mBuffer);
            if (b1 <= 0) {
                this.mPacketSize = b1 == 0 ? -1 : -2;
                return 0;
            }
            if (b1 < 128) {
                packetSize = b1;
            } else {
                int b2 = this.readFrom(in, this.mBuffer);
                if (b2 < 0) {
                    this.mPacketSize = -2;
                    return 0;
                }
                packetSize = ((b1 & 0x7F) << 8 | b2) + 128;
            }
        }
        if (n > packetSize) {
            n = packetSize;
        }
        if ((amt = this.mEnd - this.mStart) <= 0) {
            if ((n = (int)in.skip(n)) <= 0) {
                this.mPacketSize = -2;
                return 0;
            }
        } else {
            if (n > amt) {
                n = amt;
            }
            this.mStart += n;
        }
        this.mPacketSize = packetSize - n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean drain(InputStream in, int amount) {
        P recycled;
        int end;
        int start;
        byte[] buffer;
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                while (this.skip(in, amount) > 0) {
                }
                if (this.mPacketSize != -1) {
                    return this.mPacketSize < -1;
                }
                buffer = this.mBuffer;
                if (this.mBuffer == null) {
                    return true;
                }
                start = this.mStart;
                end = this.mEnd;
            }
        }
        catch (IOException e) {
            try {
                in.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            return true;
        }
        P p = recycled = this.newInstance();
        synchronized (p) {
            ((PacketInputStream)recycled).mIn = in;
            ((PacketInputStream)recycled).mBuffer = buffer;
            ((PacketInputStream)recycled).mStart = start;
            ((PacketInputStream)recycled).mEnd = end;
        }
        this.recycled(recycled);
        return true;
    }

    @Override
    public int available() throws IOException {
        this.in();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() throws IOException {
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                InputStream in = this.in();
                return this.mPacketSize >= 0 && (this.mEnd - this.mStart > 0 || in.available() > 0);
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public synchronized int setBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer too small: " + size);
        }
        byte[] buffer = this.mBuffer;
        if (buffer == null) {
            return 0;
        }
        int avail = this.mEnd - this.mStart;
        if (size < buffer.length) {
            size = Math.max(size, avail);
        }
        if (size != buffer.length) {
            byte[] newBuffer = new byte[size];
            System.arraycopy(buffer, this.mStart, newBuffer, 0, avail);
            this.mBuffer = newBuffer;
            this.mStart = 0;
            this.mEnd = avail;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fill() throws IOException {
        try {
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                InputStream in = this.in();
                byte[] buffer = this.mBuffer;
                if (buffer == null) {
                    throw new ClosedException();
                }
                int avail = this.mEnd - this.mStart;
                if (avail == 0) {
                    int amt = in.read(buffer, 0, buffer.length);
                    if (amt <= 0) {
                        throw new EOFException();
                    }
                    this.mStart = 0;
                    this.mEnd = amt;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    void inputNotify(IOExecutor executor, final Channel.Listener listener) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PacketInputStream.this.fill();
                        listener.ready();
                    }
                    catch (IOException e) {
                        listener.closed(e);
                    }
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.inputClose();
    }

    @Override
    public void disconnect() {
        this.inputDisconnect();
    }

    @Override
    public synchronized boolean inputResume() {
        if (this.mIn == null) {
            return false;
        }
        if (this.mPacketSize == 0 && this.mEnd - this.mStart > 0 && this.mBuffer[this.mStart] == 0) {
            try {
                this.read();
            }
            catch (IOException e) {
                return false;
            }
        }
        if (this.mPacketSize != -1) {
            return false;
        }
        this.mPacketSize = 0;
        return true;
    }

    @Override
    public boolean isResumeSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void inputClose() throws IOException {
        InputStream in;
        block15: {
            P recycled;
            int end;
            int start;
            byte[] buffer;
            in = inUpdater.getAndSet(this, null);
            if (in == null) {
                return;
            }
            PacketInputStream packetInputStream = this;
            synchronized (packetInputStream) {
                int packetSize = this.mPacketSize;
                if (packetSize < -1) {
                    break block15;
                }
                if (packetSize >= 0) {
                    try {
                        this.executor().execute(new Runnable(){

                            @Override
                            public void run() {
                                PacketInputStream.this.drain(in, Integer.MAX_VALUE);
                            }
                        });
                        return;
                    }
                    catch (RejectedException e) {
                        break block15;
                    }
                }
                buffer = this.mBuffer;
                if (this.mBuffer == null) {
                    break block15;
                }
                this.mBuffer = null;
                start = this.mStart;
                end = this.mEnd;
            }
            P p = recycled = this.newInstance();
            synchronized (p) {
                ((PacketInputStream)recycled).mIn = in;
                ((PacketInputStream)recycled).mBuffer = buffer;
                ((PacketInputStream)recycled).mStart = start;
                ((PacketInputStream)recycled).mEnd = end;
            }
            this.recycled(recycled);
            return;
        }
        try {
            in.close();
        }
        finally {
            this.mBuffer = null;
        }
    }

    @Override
    final void inputDisconnect() {
        InputStream in = inUpdater.getAndSet(this, null);
        if (in == null) {
            return;
        }
        try {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.mBuffer = null;
        }
    }

    protected abstract IOExecutor executor();

    protected abstract P newInstance();

    protected abstract void recycled(P var1);

    private InputStream in() throws ClosedException {
        InputStream in = this.mIn;
        if (in == null) {
            throw new ClosedException();
        }
        return in;
    }
}

