/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelOutputStream;
import org.cojen.dirmi.io.IOExecutor;

abstract class PacketOutputStream<P extends PacketOutputStream<P>>
extends ChannelOutputStream {
    private static final AtomicReferenceFieldUpdater<PacketOutputStream, OutputStream> outUpdater = AtomicReferenceFieldUpdater.newUpdater(PacketOutputStream.class, OutputStream.class, "mOut");
    static final int DEFAULT_SIZE = 8192;
    volatile OutputStream mOut;
    byte[] mBuffer;
    int mPos;

    public PacketOutputStream(OutputStream out) {
        this(out, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketOutputStream(OutputStream out, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Buffer too small: " + size);
        }
        size = Math.min(size, 32895);
        this.mOut = out;
        PacketOutputStream packetOutputStream = this;
        synchronized (packetOutputStream) {
            this.mBuffer = new byte[2 + size];
            this.mPos = 2;
        }
    }

    protected PacketOutputStream() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        try {
            PacketOutputStream packetOutputStream = this;
            synchronized (packetOutputStream) {
                OutputStream out = this.out();
                byte[] buffer = this.mBuffer;
                int pos = this.mPos;
                buffer[pos++] = (byte)b;
                if (pos >= buffer.length) {
                    this.doWrite(out, buffer, 2, buffer.length - 2);
                    this.mPos = 2;
                } else {
                    this.mPos = pos;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            PacketOutputStream packetOutputStream = this;
            synchronized (packetOutputStream) {
                OutputStream out = this.out();
                byte[] buffer = this.mBuffer;
                int pos = this.mPos;
                int avail = buffer.length - pos;
                if (avail >= len) {
                    if (pos == 2 && avail == len && off >= 2) {
                        this.doWriteAndUndoPrefix(out, b, off, len);
                    } else {
                        System.arraycopy(b, off, buffer, pos, len);
                        if (avail == len) {
                            this.doWrite(out, buffer, 2, buffer.length - 2);
                            this.mPos = 2;
                        } else {
                            this.mPos = pos + len;
                        }
                    }
                } else {
                    System.arraycopy(b, off, buffer, pos, avail);
                    off += avail;
                    len -= avail;
                    avail = buffer.length - 2;
                    this.doWrite(out, buffer, 2, avail);
                    if (len >= avail) {
                        if (off < 2) {
                            System.arraycopy(b, off, buffer, 2, avail);
                            off += avail;
                            len -= avail;
                            this.doWrite(out, buffer, 2, avail);
                        }
                        if (len >= avail) {
                            this.doWriteAndUndoPrefix(out, b, off, len);
                            this.mPos = 2;
                            return;
                        }
                    }
                    System.arraycopy(b, off, buffer, 2, len);
                    this.mPos = 2 + len;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public synchronized boolean isReady() throws IOException {
        this.out();
        return this.mBuffer.length - this.mPos - 1 > 0;
    }

    @Override
    public synchronized int setBufferSize(int size) {
        byte[] buffer;
        block7: {
            block6: {
                if (size < 1) {
                    throw new IllegalArgumentException("Buffer too small: " + size);
                }
                if (this.mOut == null) break block6;
                buffer = this.mBuffer;
                if (this.mBuffer != null) break block7;
            }
            return 0;
        }
        if ((size = Math.min(size, 32895)) < buffer.length - 2) {
            size = Math.max(size, this.mPos - 2);
        }
        if (size != buffer.length - 2) {
            byte[] newBuffer = new byte[2 + size];
            System.arraycopy(buffer, 2, newBuffer, 2, this.mPos - 2);
            this.mBuffer = newBuffer;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain() throws IOException {
        try {
            PacketOutputStream packetOutputStream = this;
            synchronized (packetOutputStream) {
                OutputStream out = this.out();
                byte[] buffer = this.mBuffer;
                int pos = this.mPos;
                int avail = buffer.length - pos - 1;
                if (avail == 0) {
                    this.doWrite(out, buffer, 2, pos - 2);
                    this.mPos = 2;
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    void outputNotify(IOExecutor executor, final Channel.Listener listener) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        PacketOutputStream.this.drain();
                        listener.ready();
                    }
                    catch (IOException e) {
                        listener.closed(e);
                    }
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try {
            PacketOutputStream packetOutputStream = this;
            synchronized (packetOutputStream) {
                OutputStream out = this.mOut;
                if (out == null) {
                    return;
                }
                int pos = this.mPos;
                byte[] buffer = this.mBuffer;
                if (pos <= buffer.length) {
                    if (pos > 2) {
                        this.doWrite(out, buffer, 2, pos - 2);
                        this.mPos = 2;
                    }
                    out.flush();
                }
            }
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        this.outputClose();
    }

    @Override
    public void disconnect() {
        this.outputDisconnect();
    }

    @Override
    public synchronized boolean outputSuspend() throws IOException {
        OutputStream out = this.mOut;
        if (out == null) {
            return false;
        }
        this.writeSuspendMarker(out, this.mBuffer, false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void outputClose() throws IOException {
        P recycled;
        byte[] buffer;
        OutputStream out = outUpdater.getAndSet(this, null);
        if (out == null) {
            return;
        }
        PacketOutputStream packetOutputStream = this;
        synchronized (packetOutputStream) {
            buffer = this.mBuffer;
            this.mBuffer = null;
            try {
                this.writeSuspendMarker(out, buffer, true);
            }
            catch (IOException e) {
                this.outputDisconnect(out);
                throw e;
            }
        }
        P p = recycled = this.newInstance();
        synchronized (p) {
            ((PacketOutputStream)recycled).mOut = out;
            ((PacketOutputStream)recycled).mBuffer = buffer;
            ((PacketOutputStream)recycled).mPos = 2;
        }
        this.recycled(recycled);
    }

    @Override
    final void outputDisconnect() {
        this.outputDisconnect(outUpdater.getAndSet(this, null));
    }

    private void outputDisconnect(OutputStream out) {
        if (out == null) {
            return;
        }
        try {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.mBuffer = null;
        }
    }

    protected abstract P newInstance();

    protected abstract void recycled(P var1);

    private void writeSuspendMarker(OutputStream out, byte[] buffer, boolean forClose) throws IOException {
        int pos = this.mPos;
        if (pos >= buffer.length) {
            this.doWrite(out, buffer, 2, pos - 2);
            out.write(0);
            out.flush();
            this.mPos = 2;
        } else {
            int length = pos - 2;
            if (length <= 0) {
                try {
                    out.write(0);
                    out.flush();
                }
                catch (IOException e) {
                    if (!forClose) {
                        throw e;
                    }
                    this.outputDisconnect(out);
                    return;
                }
            } else {
                buffer[pos] = 0;
                if (length < 128) {
                    buffer[1] = (byte)length;
                    pos = 1;
                    length += 2;
                } else {
                    buffer[1] = (byte)(length - 128);
                    buffer[0] = (byte)(length - 128 >> 8 | 0x80);
                    pos = 0;
                    length += 3;
                }
                out.write(buffer, pos, length);
                out.flush();
                this.mPos = 2;
            }
        }
    }

    private void doWrite(OutputStream out, byte[] buffer, int offset, int length) throws IOException {
        if (length < 128) {
            buffer[--offset] = (byte)length;
            ++length;
        } else {
            buffer[--offset] = (byte)(length - 128);
            buffer[--offset] = (byte)(length - 128 >> 8 | 0x80);
            length += 2;
        }
        out.write(buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWriteAndUndoPrefix(OutputStream out, byte[] buffer, int offset, int length) throws IOException {
        if (length < 128) {
            byte original = buffer[--offset];
            buffer[offset] = (byte)length;
            try {
                out.write(buffer, offset, length + 1);
            }
            finally {
                buffer[offset] = original;
            }
        }
        byte original_1 = buffer[--offset];
        byte original_0 = buffer[--offset];
        buffer[offset + 1] = (byte)(length - 128);
        buffer[offset] = (byte)(length - 128 >> 8 | 0x80);
        try {
            out.write(buffer, offset, length + 2);
        }
        finally {
            buffer[offset + 1] = original_1;
            buffer[offset] = original_0;
        }
    }

    private OutputStream out() throws ClosedException {
        OutputStream out = this.mOut;
        if (out == null) {
            throw new ClosedException();
        }
        return out;
    }
}

