/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import org.cojen.dirmi.io.BufferedChannelOutputStream;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.PipeNotify;
import org.cojen.dirmi.io.PipedInputStream;
import org.cojen.dirmi.io.PipedOutputStream;

class PipedChannel
implements Channel {
    private final IOExecutor mExecutor;
    private final Input mIn;
    private final PipedOutputStream mPout;
    private final BufferedChannelOutputStream mOut;

    PipedChannel(IOExecutor executor, PipedInputStream in, PipedOutputStream out, int outputBufferSize) {
        this.mExecutor = executor;
        this.mIn = new Input(in);
        this.mPout = out;
        this.mOut = new BufferedChannelOutputStream(this, out, outputBufferSize);
    }

    @Override
    public Object getLocalAddress() {
        return this.mIn.toString();
    }

    @Override
    public Object getRemoteAddress() {
        return this.mPout.toString();
    }

    @Override
    public InputStream getInputStream() {
        return this.mIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.mOut;
    }

    @Override
    public boolean isInputReady() throws IOException {
        return this.mIn.isReady();
    }

    @Override
    public boolean isOutputReady() throws IOException {
        return this.mPout.isReady() || this.mOut.isReady();
    }

    @Override
    public int setInputBufferSize(int size) {
        return 0;
    }

    @Override
    public int setOutputBufferSize(int size) {
        return this.mOut.setBufferSize(size);
    }

    @Override
    public void inputNotify(Channel.Listener listener) {
        this.mIn.inputNotify(this.mExecutor, listener);
    }

    @Override
    public void outputNotify(Channel.Listener listener) {
        try {
            if (this.isOutputReady()) {
                new PipeNotify(this.mExecutor, listener);
            } else {
                this.mOut.outputNotify(this.mExecutor, listener);
            }
        }
        catch (IOException e) {
            new PipeNotify(this.mExecutor, listener, e);
        }
    }

    @Override
    public boolean usesSelectNotification() {
        return false;
    }

    @Override
    public boolean inputResume() {
        return false;
    }

    @Override
    public boolean isResumeSupported() {
        return false;
    }

    @Override
    public boolean outputSuspend() throws IOException {
        this.flush();
        return false;
    }

    public String toString() {
        return "Channel {localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }

    @Override
    public void register(CloseableGroup<? super Channel> group) {
    }

    @Override
    public boolean isClosed() {
        return this.mIn.isClosed() || this.mPout.isClosed();
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public void close() throws IOException {
        this.preClose();
        this.mOut.outputClose();
        this.mIn.inputClose();
    }

    @Override
    public void disconnect() {
        this.preClose();
        this.mOut.outputDisconnect();
        this.mIn.inputClose();
    }

    @Override
    public Remote installRecycler(Channel.Recycler recycler) {
        return null;
    }

    @Override
    public void setRecycleControl(Remote control) {
    }

    private synchronized void preClose() {
    }

    private class Input
    extends InputStream {
        private final PipedInputStream mIn;

        Input(PipedInputStream in) {
            this.mIn = in;
        }

        @Override
        public int read() throws IOException {
            return this.mIn.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.mIn.read(b);
        }

        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            return this.mIn.read(b, offset, length);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.mIn.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.mIn.available();
        }

        @Override
        public void close() throws IOException {
            PipedChannel.this.close();
        }

        public String toString() {
            return this.mIn.toString();
        }

        void inputNotify(IOExecutor executor, Channel.Listener listener) {
            this.mIn.inputNotify(executor, listener);
        }

        boolean isReady() throws IOException {
            return this.mIn.isReady();
        }

        boolean isClosed() {
            return this.mIn.isClosed();
        }

        void inputClose() {
            this.mIn.close();
        }
    }
}

