/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.cojen.dirmi.Asynchronous;
import org.cojen.dirmi.Disposer;
import org.cojen.dirmi.Ordered;
import org.cojen.dirmi.Unreferenced;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.PacketInputStream;
import org.cojen.dirmi.io.PacketOutputStream;
import org.cojen.dirmi.io.SimpleSocket;
import org.cojen.dirmi.io.SocketChannel;

class RecyclableSocketChannel
extends SocketChannel {
    private static final int REMOTE_RECYCLE_READY = 1;
    private static final int LOCAL_RECYCLE_READY = 2;
    private static final int OUTPUT_CLOSED = 4;
    private Channel.Recycler mRecycler;
    private RecycleControl mRemoteControl;
    private Input mRecycledInput;
    private Output mRecycledOutput;
    private int mState;

    RecyclableSocketChannel(IOExecutor executor, SimpleSocket socket) throws IOException {
        super(executor, socket);
    }

    RecyclableSocketChannel(RecyclableSocketChannel channel, Input in, Output out) {
        super(channel, in, out);
        in.setChannel(this);
        out.setChannel(this);
    }

    @Override
    public synchronized Remote installRecycler(Channel.Recycler recycler) {
        if (this.mRecycler != null) {
            throw new IllegalStateException();
        }
        if (recycler == null) {
            throw new IllegalArgumentException();
        }
        this.mRecycler = recycler;
        return new LocalControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecycleControl(Remote control) {
        if (!(control instanceof RecycleControl)) {
            throw new IllegalArgumentException();
        }
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            this.mRemoteControl = (RecycleControl)control;
        }
    }

    @Override
    Input createInputStream(SimpleSocket socket) throws IOException {
        return new Input(socket.getInputStream(), this);
    }

    @Override
    Output createOutputStream(SimpleSocket socket) throws IOException {
        return new Output(socket.getOutputStream(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RecycleControl remoteControl;
        int state;
        block9: {
            if (!this.markClosed()) {
                return;
            }
            RecyclableSocketChannel recyclableSocketChannel = this;
            synchronized (recyclableSocketChannel) {
                state = this.mState;
                if (this.mRecycler != null && (remoteControl = this.mRemoteControl) != null) {
                    this.mState = state |= 4;
                    break block9;
                }
                this.mRemoteControl = null;
            }
            super.close();
            return;
        }
        try {
            if ((state & 2) != 0) {
                remoteControl.outputCloseAndDispose();
            } else {
                remoteControl.outputClose();
            }
            this.getInputStream().inputClose();
            this.getOutputStream().outputClose();
        }
        catch (IOException e) {
            this.forceDisconnect();
            throw e;
        }
    }

    @Override
    public void disconnect() {
        if (this.markClosed()) {
            this.forceDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceDisconnect() {
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            this.mRemoteControl = null;
        }
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unreferenced() {
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            if ((this.mState & 1) != 0) {
                return;
            }
        }
        this.forceDisconnect();
    }

    protected RecyclableSocketChannel newRecycledChannel(Input in, Output out) {
        return new RecyclableSocketChannel(this, in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void inputRecycled(Input in) {
        RecycleControl ready;
        int state;
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            state = this.mState;
            this.mRecycledInput = in;
            if (this.mRecycledOutput == null) {
                ready = null;
            } else {
                ready = this.mRemoteControl;
                this.mState = state |= 2;
            }
        }
        this.localRecycled(ready, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void outputRecycled(Output out) {
        RecycleControl ready;
        int state;
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            state = this.mState;
            this.mRecycledOutput = out;
            if (this.mRecycledInput == null) {
                ready = null;
            } else {
                ready = this.mRemoteControl;
                this.mState = state |= 2;
            }
        }
        this.localRecycled(ready, state);
    }

    private void localRecycled(RecycleControl ready, int state) {
        if (ready != null) {
            try {
                if ((state & 4) != 0) {
                    ready.recycleReadyAndDispose();
                } else {
                    ready.recycleReady();
                }
            }
            catch (RemoteException e) {
                this.forceDisconnect();
            }
        }
        this.handoff(false);
    }

    void remoteRecycleReady() {
        this.handoff(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handoff(boolean remoteKnownReady) {
        Channel.Recycler recycler;
        Output out;
        Input in;
        RecyclableSocketChannel recyclableSocketChannel = this;
        synchronized (recyclableSocketChannel) {
            if (remoteKnownReady) {
                this.mState |= 1;
            }
            if ((this.mState & 1) == 0 || (in = this.mRecycledInput) == null || (out = this.mRecycledOutput) == null) {
                return;
            }
            recycler = this.mRecycler;
            this.mRecycledInput = null;
            this.mRecycledOutput = null;
        }
        recycler.recycled(this.newRecycledChannel(in, out));
    }

    private class LocalControl
    implements RecycleControl,
    Unreferenced {
        private LocalControl() {
        }

        @Override
        public void outputClose() {
            try {
                RecyclableSocketChannel.this.getOutputStream().outputClose();
            }
            catch (IOException e) {
                RecyclableSocketChannel.this.disconnect();
            }
        }

        @Override
        public void outputCloseAndDispose() {
            this.outputClose();
        }

        @Override
        public void recycleReady() {
            RecyclableSocketChannel.this.remoteRecycleReady();
        }

        @Override
        public void recycleReadyAndDispose() {
            this.recycleReady();
        }

        @Override
        public void unreferenced() {
            RecyclableSocketChannel.this.unreferenced();
        }
    }

    public static interface RecycleControl
    extends Remote {
        @Ordered
        @Asynchronous
        public void outputClose() throws RemoteException;

        @Ordered
        @Asynchronous
        @Disposer
        public void outputCloseAndDispose() throws RemoteException;

        @Ordered
        @Asynchronous
        public void recycleReady() throws RemoteException;

        @Ordered
        @Asynchronous
        @Disposer
        public void recycleReadyAndDispose() throws RemoteException;
    }

    static class Output
    extends PacketOutputStream<Output> {
        private volatile RecyclableSocketChannel mChannel;

        Output(OutputStream out, RecyclableSocketChannel channel) {
            super(out);
            this.mChannel = channel;
        }

        private Output() {
        }

        @Override
        public void close() throws IOException {
            RecyclableSocketChannel channel = this.mChannel;
            if (channel != null) {
                channel.close();
            }
        }

        @Override
        public void disconnect() {
            RecyclableSocketChannel channel = this.mChannel;
            if (channel != null) {
                channel.disconnect();
            }
        }

        @Override
        protected Output newInstance() {
            return new Output();
        }

        @Override
        protected void recycled(Output newInstance) {
            this.mChannel.outputRecycled(newInstance);
        }

        void setChannel(RecyclableSocketChannel channel) {
            this.mChannel = channel;
        }
    }

    static class Input
    extends PacketInputStream<Input> {
        private volatile RecyclableSocketChannel mChannel;

        Input(InputStream in, RecyclableSocketChannel channel) {
            super(in);
            this.mChannel = channel;
        }

        private Input() {
        }

        @Override
        public void close() throws IOException {
            RecyclableSocketChannel channel = this.mChannel;
            if (channel != null) {
                channel.close();
            }
        }

        @Override
        public void disconnect() {
            RecyclableSocketChannel channel = this.mChannel;
            if (channel != null) {
                channel.disconnect();
            }
        }

        @Override
        protected IOExecutor executor() {
            return this.mChannel.executor();
        }

        @Override
        protected Input newInstance() {
            return new Input();
        }

        @Override
        protected void recycled(Input newInstance) {
            this.mChannel.inputRecycled(newInstance);
        }

        void setChannel(RecyclableSocketChannel channel) {
            this.mChannel = channel;
        }
    }
}

