/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.ChannelConnectWaiter;
import org.cojen.dirmi.io.ChannelConnector;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.NioRecyclableSocketChannel;
import org.cojen.dirmi.io.NioSocketChannel;
import org.cojen.dirmi.io.SocketChannelSelector;
import org.cojen.dirmi.util.ScheduledTask;
import org.cojen.dirmi.util.Timer;

public class RecyclableSocketChannelSelector
implements SocketChannelSelector {
    private final IOExecutor mExecutor;
    private final Selector mSelector;
    private final ConcurrentLinkedQueue<Selectable> mQueue;

    public RecyclableSocketChannelSelector(IOExecutor executor) throws IOException {
        this(executor, Selector.open());
    }

    private RecyclableSocketChannelSelector(IOExecutor executor, Selector selector) {
        if (executor == null || selector == null) {
            throw new IllegalArgumentException();
        }
        this.mExecutor = executor;
        this.mSelector = selector;
        this.mQueue = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void selectLoop() throws IOException {
        executor = this.mExecutor;
        selector = this.mSelector;
        queue = this.mQueue;
        try {
            block9: while (true) {
                count = selector.select();
                didRegister = false;
                while ((selectable = queue.poll()) != null) {
                    didRegister = true;
                    selectable.register(selector);
                }
                if (count == 0) {
                    if (!selector.isOpen()) {
                        return;
                    }
                    if (didRegister) continue;
                    var7_8 = selector.keys().iterator();
                    while (true) {
                        if (!var7_8.hasNext()) continue block9;
                        key = var7_8.next();
                        if (!key.isValid() || key.channel().isOpen()) continue;
                        key.cancel();
                    }
                }
                it = selector.selectedKeys().iterator();
                while (true) lbl-1000:
                // 5 sources

                {
                    if (it.hasNext()) ** break;
                    continue block9;
                    key = it.next();
                    selected = (Selectable)key.attachment();
                    try {
                        try {
                            executor.execute(selected);
                        }
                        catch (RejectedException e) {
                            try {
                                executor.schedule(selected, 0L, TimeUnit.SECONDS);
                            }
                            catch (RejectedException e2) {
                                selected.rejected(e);
                            }
                        }
                    }
                    finally {
                        key.cancel();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
        catch (ClosedSelectorException e) {
            return;
        }
        ** GOTO lbl-1000
    }

    @Override
    public void close() throws IOException {
        this.mSelector.close();
    }

    public ChannelAcceptor newChannelAcceptor(SocketAddress localAddress) throws IOException {
        return new NioChannelAcceptor(localAddress);
    }

    public ChannelConnector newChannelConnector(SocketAddress remoteAddress) {
        return this.newChannelConnector(remoteAddress, null);
    }

    public ChannelConnector newChannelConnector(SocketAddress remoteAddress, SocketAddress localAddress) {
        return new NioChannelConnector(remoteAddress, localAddress);
    }

    void connectNotify(SocketChannel channel, CloseableGroup<Channel> connected, ChannelConnector.Listener listener) {
        this.mQueue.add(new ConnectNotify(channel, connected, listener));
        this.mSelector.wakeup();
    }

    void acceptNotify(AccessControlContext context, CloseableGroup<Channel> accepted, ServerSocketChannel channel, ChannelAcceptor.Listener listener) {
        this.mQueue.add(new AcceptNotify(context, accepted, channel, listener));
        this.mSelector.wakeup();
    }

    @Override
    public void inputNotify(SocketChannel channel, Channel.Listener listener) {
        this.mQueue.add(new ChannelNotify(channel, listener, 1));
        this.mSelector.wakeup();
    }

    @Override
    public void outputNotify(SocketChannel channel, Channel.Listener listener) {
        this.mQueue.add(new ChannelNotify(channel, listener, 4));
        this.mSelector.wakeup();
    }

    @Override
    public IOExecutor executor() {
        return this.mExecutor;
    }

    static Timer toTimer(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            return null;
        }
        if (timeout == 0L) {
            return new Timer(0L, TimeUnit.NANOSECONDS);
        }
        return new Timer(timeout, unit);
    }

    private class NioChannelConnector
    implements ChannelConnector {
        final SocketAddress mRemoteAddress;
        final SocketAddress mLocalAddress;
        private final AccessControlContext mContext;
        private final CloseableGroup<Channel> mConnected;

        NioChannelConnector(SocketAddress remoteAddress, SocketAddress localAddress) {
            if (remoteAddress == null) {
                throw new IllegalArgumentException("Must provide a remote address");
            }
            this.mRemoteAddress = remoteAddress;
            this.mLocalAddress = localAddress;
            this.mContext = AccessController.getContext();
            this.mConnected = new CloseableGroup();
        }

        @Override
        public Object getRemoteAddress() {
            return this.mRemoteAddress;
        }

        @Override
        public Object getLocalAddress() {
            return this.mLocalAddress;
        }

        @Override
        public Channel connect() throws IOException {
            return this.connect(-1L, null);
        }

        @Override
        public Channel connect(long timeout, TimeUnit unit) throws IOException {
            this.mConnected.checkClosed();
            ChannelConnectWaiter waiter = new ChannelConnectWaiter();
            this.connect(waiter);
            if (timeout < 0L) {
                return waiter.waitForChannel();
            }
            return waiter.waitForChannel(timeout, unit);
        }

        @Override
        public Channel connect(Timer timer) throws IOException {
            this.mConnected.checkClosed();
            return this.connect(timer.duration(), timer.unit());
        }

        @Override
        public void connect(ChannelConnector.Listener listener) {
            SocketChannel sc;
            try {
                try {
                    sc = AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>(){

                        @Override
                        public SocketChannel run() throws IOException {
                            SocketChannel sc = SocketChannel.open();
                            sc.configureBlocking(false);
                            if (NioChannelConnector.this.mLocalAddress != null) {
                                sc.socket().bind(NioChannelConnector.this.mLocalAddress);
                            }
                            sc.connect(NioChannelConnector.this.mRemoteAddress);
                            return sc;
                        }
                    }, this.mContext);
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
            }
            catch (IOException e) {
                listener.failed(e);
                return;
            }
            RecyclableSocketChannelSelector.this.connectNotify(sc, this.mConnected, listener);
        }

        @Override
        public void close() {
            this.mConnected.close();
        }

        public String toString() {
            return "ChannelConnector {localAddress=" + this.mLocalAddress + ", remoteAddress=" + this.mRemoteAddress + '}';
        }
    }

    private class NioChannelAcceptor
    implements ChannelAcceptor {
        private final SocketAddress mLocalAddress;
        private final ServerSocketChannel mChannel;
        private final AccessControlContext mContext;
        private final CloseableGroup<Channel> mAccepted;
        final ConcurrentLinkedQueue<Channel> mAcceptQueue;

        NioChannelAcceptor(SocketAddress localAddress) throws IOException {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.configureBlocking(false);
            ssc.socket().setReuseAddress(true);
            ssc.socket().bind(localAddress, 1000);
            this.mLocalAddress = ssc.socket().getLocalSocketAddress();
            this.mChannel = ssc;
            this.mContext = AccessController.getContext();
            this.mAccepted = new CloseableGroup();
            this.mAcceptQueue = new ConcurrentLinkedQueue();
        }

        @Override
        public Channel accept() throws IOException {
            return this.accept(-1L, null);
        }

        @Override
        public Channel accept(long timeout, TimeUnit unit) throws IOException {
            return this.accept(RecyclableSocketChannelSelector.toTimer(timeout, unit));
        }

        @Override
        public Channel accept(Timer timer) throws IOException {
            this.mAccepted.checkClosed();
            class Listener
            implements ChannelAcceptor.Listener {
                private Channel mChannel;
                private IOException mException;
                private boolean mAbandoned;

                Listener() {
                }

                @Override
                public synchronized void accepted(Channel channel) {
                    if (this.mAbandoned) {
                        NioChannelAcceptor.this.mAcceptQueue.add(channel);
                    } else {
                        this.mChannel = channel;
                        this.notify();
                    }
                }

                @Override
                public synchronized void rejected(RejectedException cause) {
                    this.mException = cause;
                    this.notify();
                }

                @Override
                public synchronized void failed(IOException cause) {
                    this.mException = cause;
                    this.notify();
                }

                @Override
                public synchronized void closed(IOException cause) {
                    this.mException = cause;
                    this.notify();
                }

                synchronized Channel waitForChannel(Timer timer) throws IOException {
                    while (this.mChannel == null) {
                        if (this.mException != null) {
                            if (this.mException.getCause() instanceof SecurityException) {
                                throw (SecurityException)this.mException.getCause();
                            }
                            throw this.mException;
                        }
                        try {
                            try {
                                if (timer == null) {
                                    this.wait();
                                    continue;
                                }
                                long remaining = RemoteTimeoutException.checkRemaining(timer);
                                this.wait(timer.unit().toMillis(remaining));
                            }
                            catch (InterruptedException e) {
                                throw new InterruptedIOException();
                            }
                        }
                        catch (IOException e) {
                            this.mAbandoned = true;
                            throw e;
                        }
                    }
                    return this.mChannel;
                }
            }
            Listener listener = new Listener();
            this.accept(listener);
            return listener.waitForChannel(timer);
        }

        @Override
        public void accept(final ChannelAcceptor.Listener listener) {
            Channel channel = this.mAcceptQueue.poll();
            if (channel != null) {
                listener.accepted(channel);
            }
            RecyclableSocketChannelSelector.this.acceptNotify(this.mContext, this.mAccepted, this.mChannel, new ChannelAcceptor.Listener(){

                @Override
                public void accepted(Channel channel) {
                    if (NioChannelAcceptor.this.acceptedChannel(channel)) {
                        listener.accepted(channel);
                    } else {
                        listener.closed(new ClosedException());
                    }
                }

                @Override
                public void rejected(RejectedException cause) {
                    listener.rejected(cause);
                }

                @Override
                public void failed(IOException cause) {
                    listener.failed(cause);
                }

                @Override
                public void closed(IOException cause) {
                    listener.closed(cause);
                }
            });
        }

        @Override
        public void close() {
            this.mAccepted.close();
            try {
                this.mChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public Object getLocalAddress() {
            return this.mLocalAddress;
        }

        public String toString() {
            return "ChannelAcceptor {localAddress=" + this.mLocalAddress + '}';
        }

        boolean acceptedChannel(Channel channel) {
            if (this.mAccepted.isClosed()) {
                channel.disconnect();
                return false;
            }
            return true;
        }
    }

    private class AcceptNotify
    extends Selectable {
        private final AccessControlContext mContext;
        private final CloseableGroup<Channel> mAccepted;
        final ServerSocketChannel mChannel;
        private final ChannelAcceptor.Listener mListener;

        AcceptNotify(AccessControlContext context, CloseableGroup<Channel> accepted, ServerSocketChannel channel, ChannelAcceptor.Listener listener) {
            this.mContext = context;
            this.mAccepted = accepted;
            this.mChannel = channel;
            this.mListener = listener;
        }

        @Override
        void register(Selector selector) {
            try {
                this.mChannel.register(selector, 16, this);
            }
            catch (ClosedChannelException e) {
                this.mListener.closed(e);
            }
            catch (RuntimeException e) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mListener.closed(new IOException(e));
            }
        }

        @Override
        void rejected(RejectedException cause) {
            this.mListener.rejected(cause);
        }

        @Override
        protected void doRun() {
            SocketChannel channel;
            try {
                try {
                    channel = AccessController.doPrivileged(new PrivilegedExceptionAction<SocketChannel>(){

                        @Override
                        public SocketChannel run() throws IOException {
                            return AcceptNotify.this.mChannel.accept();
                        }
                    }, this.mContext);
                    channel.configureBlocking(false);
                }
                catch (PrivilegedActionException e) {
                    throw (IOException)e.getCause();
                }
            }
            catch (SecurityException e) {
                this.mListener.failed(new IOException(e));
                return;
            }
            catch (Exception e) {
                try {
                    this.mChannel.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                this.mListener.closed(e instanceof IOException ? (IOException)e : new IOException(e));
                return;
            }
            try {
                NioSocketChannel nsc = new NioSocketChannel(RecyclableSocketChannelSelector.this, channel);
                NioRecyclableSocketChannel nrsc = new NioRecyclableSocketChannel(RecyclableSocketChannelSelector.this.executor(), nsc);
                nrsc.register(this.mAccepted);
                this.mListener.accepted(nrsc);
            }
            catch (IOException e) {
                this.mListener.failed(e);
            }
        }
    }

    private class ConnectNotify
    extends Selectable {
        private final CloseableGroup<Channel> mConnected;
        private final SocketChannel mChannel;
        private final ChannelConnector.Listener mListener;

        ConnectNotify(SocketChannel channel, CloseableGroup<Channel> connected, ChannelConnector.Listener listener) {
            this.mConnected = connected;
            this.mChannel = channel;
            this.mListener = listener;
        }

        @Override
        void register(Selector selector) {
            try {
                this.mChannel.register(selector, 8, this);
            }
            catch (ClosedChannelException e) {
                this.mListener.failed(e);
            }
            catch (RuntimeException e) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mListener.failed(new IOException(e));
            }
        }

        @Override
        void rejected(RejectedException cause) {
            this.mListener.rejected(cause);
        }

        @Override
        protected void doRun() {
            try {
                this.mChannel.finishConnect();
                NioSocketChannel nsc = new NioSocketChannel(RecyclableSocketChannelSelector.this, this.mChannel);
                NioRecyclableSocketChannel nrsc = new NioRecyclableSocketChannel(RecyclableSocketChannelSelector.this.executor(), nsc);
                nrsc.register(this.mConnected);
                this.mListener.connected(nrsc);
            }
            catch (IOException e) {
                this.mListener.failed(e);
            }
        }
    }

    private static class ChannelNotify
    extends Selectable {
        private final SocketChannel mChannel;
        private final Channel.Listener mListener;
        private final int mOps;

        ChannelNotify(SocketChannel channel, Channel.Listener listener, int ops) {
            this.mChannel = channel;
            this.mListener = listener;
            this.mOps = ops;
        }

        @Override
        void register(Selector selector) {
            try {
                this.mChannel.register(selector, this.mOps, this);
            }
            catch (ClosedChannelException e) {
                this.mListener.closed(e);
            }
            catch (RuntimeException e) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mListener.closed(new IOException(e));
            }
        }

        @Override
        void rejected(RejectedException cause) {
            this.mListener.rejected(cause);
        }

        @Override
        protected void doRun() {
            this.mListener.ready();
        }
    }

    private static abstract class Selectable
    extends ScheduledTask<RuntimeException> {
        private Selectable() {
        }

        abstract void register(Selector var1);

        abstract void rejected(RejectedException var1);
    }
}

