/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelInputStream;
import org.cojen.dirmi.io.ChannelOutputStream;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.SimpleSocket;

abstract class SocketChannel
implements Channel {
    private static final AtomicIntegerFieldUpdater<SocketChannel> closedUpdater = AtomicIntegerFieldUpdater.newUpdater(SocketChannel.class, "mClosed");
    private final IOExecutor mExecutor;
    private final SimpleSocket mSocket;
    private final ChannelInputStream mIn;
    private final ChannelOutputStream mOut;
    private CloseableGroup<? super Channel>[] mGroups;
    private volatile int mClosed;

    public static SimpleSocket toSimpleSocket(final Socket socket) {
        return new SimpleSocket(){

            @Override
            public void flush() throws IOException {
                socket.getOutputStream().flush();
            }

            @Override
            public void close() throws IOException {
                socket.close();
            }

            @Override
            public Object getLocalAddress() {
                return socket.getLocalSocketAddress();
            }

            @Override
            public Object getRemoteAddress() {
                return socket.getRemoteSocketAddress();
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return socket.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return socket.getOutputStream();
            }
        };
    }

    SocketChannel(IOExecutor executor, SimpleSocket socket) throws IOException {
        this.mExecutor = executor;
        this.mSocket = socket;
        try {
            this.mIn = this.createInputStream(socket);
            this.mOut = this.createOutputStream(socket);
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SocketChannel(SocketChannel channel, ChannelInputStream in, ChannelOutputStream out) {
        this.mExecutor = channel.mExecutor;
        this.mSocket = channel.mSocket;
        this.mIn = in;
        this.mOut = out;
        SimpleSocket simpleSocket = this.mSocket;
        synchronized (simpleSocket) {
            this.mGroups = channel.mGroups;
            if (channel.mGroups != null) {
                for (CloseableGroup<? super Channel> group : this.mGroups) {
                    group.remove(channel);
                }
                channel.mGroups = null;
            }
        }
    }

    @Override
    public ChannelInputStream getInputStream() {
        return this.mIn;
    }

    @Override
    public ChannelOutputStream getOutputStream() {
        return this.mOut;
    }

    @Override
    public Object getLocalAddress() {
        return this.mSocket.getLocalAddress();
    }

    @Override
    public Object getRemoteAddress() {
        return this.mSocket.getRemoteAddress();
    }

    @Override
    public boolean isInputReady() throws IOException {
        return this.mIn.isReady();
    }

    @Override
    public boolean isOutputReady() throws IOException {
        return this.mOut.isReady();
    }

    @Override
    public int setInputBufferSize(int size) {
        return this.mIn.setBufferSize(size);
    }

    @Override
    public int setOutputBufferSize(int size) {
        return this.mOut.setBufferSize(size);
    }

    @Override
    public void inputNotify(Channel.Listener listener) {
        this.mIn.inputNotify(this.mExecutor, listener);
    }

    @Override
    public void outputNotify(Channel.Listener listener) {
        this.mOut.outputNotify(this.mExecutor, listener);
    }

    @Override
    public boolean inputResume() {
        return this.mIn.inputResume();
    }

    @Override
    public boolean isResumeSupported() {
        return this.mIn.isResumeSupported();
    }

    @Override
    public boolean outputSuspend() throws IOException {
        return this.mOut.outputSuspend();
    }

    public String toString() {
        return "Channel {localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }

    @Override
    public void flush() throws IOException {
        this.mOut.flush();
    }

    @Override
    public boolean usesSelectNotification() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(CloseableGroup<? super Channel> group) {
        if (!group.add(this)) {
            return;
        }
        SimpleSocket simpleSocket = this.mSocket;
        synchronized (simpleSocket) {
            if (this.mGroups == null) {
                this.mGroups = new CloseableGroup[]{group};
            } else {
                CloseableGroup[] groups = new CloseableGroup[this.mGroups.length + 1];
                System.arraycopy(this.mGroups, 0, groups, 0, this.mGroups.length);
                groups[groups.length - 1] = group;
                this.mGroups = groups;
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.mClosed != 0;
    }

    @Override
    public void close() throws IOException {
        this.preClose();
        try {
            this.mOut.outputClose();
        }
        catch (IOException e) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        this.mSocket.close();
        this.mIn.inputClose();
    }

    @Override
    public void disconnect() {
        this.preClose();
        this.mOut.outputDisconnect();
        this.mIn.inputDisconnect();
        try {
            this.mSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preClose() {
        this.mClosed = 1;
        SimpleSocket simpleSocket = this.mSocket;
        synchronized (simpleSocket) {
            if (this.mGroups != null) {
                for (CloseableGroup<? super Channel> group : this.mGroups) {
                    group.remove(this);
                }
                this.mGroups = null;
            }
        }
    }

    protected IOExecutor executor() {
        return this.mExecutor;
    }

    protected SimpleSocket socket() {
        return this.mSocket;
    }

    protected boolean markClosed() {
        return closedUpdater.compareAndSet(this, 0, 1);
    }

    abstract ChannelInputStream createInputStream(SimpleSocket var1) throws IOException;

    abstract ChannelOutputStream createOutputStream(SimpleSocket var1) throws IOException;
}

