/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelAcceptor;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.SimpleSocket;
import org.cojen.dirmi.io.SocketChannel;
import org.cojen.dirmi.util.Timer;

abstract class SocketChannelAcceptor
implements ChannelAcceptor {
    static final int LISTEN_BACKLOG = 1000;
    private final IOExecutor mExecutor;
    private final SocketAddress mLocalAddress;
    private final ServerSocket mServerSocket;
    private final AccessControlContext mContext;
    private final CloseableGroup<Channel> mAccepted;
    volatile boolean mAnyAccepted;

    public SocketChannelAcceptor(IOExecutor executor, SocketAddress localAddress) throws IOException {
        this(executor, localAddress, new ServerSocket());
    }

    public SocketChannelAcceptor(IOExecutor executor, SocketAddress localAddress, ServerSocket serverSocket) throws IOException {
        if (executor == null) {
            throw new IllegalArgumentException("Must provide an executor");
        }
        if (serverSocket == null) {
            throw new IllegalArgumentException("Must provide a server socket");
        }
        this.mExecutor = executor;
        this.mServerSocket = serverSocket;
        serverSocket.setReuseAddress(true);
        serverSocket.bind(localAddress, 1000);
        this.mLocalAddress = serverSocket.getLocalSocketAddress();
        this.mContext = AccessController.getContext();
        this.mAccepted = new CloseableGroup();
    }

    @Override
    public Channel accept() throws IOException {
        return this.accept(-1L, null);
    }

    @Override
    public synchronized Channel accept(long timeout, TimeUnit unit) throws IOException {
        Socket socket;
        this.mAccepted.checkClosed();
        if (timeout < 0L) {
            this.mServerSocket.setSoTimeout(0);
        } else {
            long millis = unit.toMillis(timeout);
            if (millis <= 0L) {
                throw new RemoteTimeoutException(timeout, unit);
            }
            if (millis > Integer.MAX_VALUE) {
                this.mServerSocket.setSoTimeout(0);
            } else {
                this.mServerSocket.setSoTimeout((int)millis);
            }
        }
        try {
            socket = this.acceptSocket();
        }
        catch (SocketTimeoutException e) {
            throw new RemoteTimeoutException(timeout, unit);
        }
        catch (IOException e) {
            this.mAccepted.checkClosed();
            throw e;
        }
        socket.setTcpNoDelay(true);
        Channel channel = this.createChannel(SocketChannel.toSimpleSocket(socket));
        channel.register(this.mAccepted);
        return channel;
    }

    @Override
    public Channel accept(Timer timer) throws IOException {
        this.mAccepted.checkClosed();
        return this.accept(RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    @Override
    public void accept(final ChannelAcceptor.Listener listener) {
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Channel channel;
                    if (SocketChannelAcceptor.this.mAccepted.isClosed()) {
                        listener.closed(new ClosedException());
                        return;
                    }
                    try {
                        try {
                            channel = SocketChannelAcceptor.this.accept();
                            SocketChannelAcceptor.this.mAnyAccepted = true;
                        }
                        catch (SSLException e) {
                            if (!SocketChannelAcceptor.this.mAnyAccepted && e.getClass() == SSLException.class) {
                                SocketChannelAcceptor.this.close();
                            }
                            throw e;
                        }
                    }
                    catch (IOException e) {
                        if (SocketChannelAcceptor.this.mAccepted.isClosed()) {
                            listener.closed(e);
                        } else {
                            listener.failed(e);
                        }
                        return;
                    }
                    listener.accepted(channel);
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    @Override
    public void close() {
        this.mAccepted.close();
        try {
            this.mServerSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "ChannelAcceptor {localAddress=" + this.mLocalAddress + '}';
    }

    @Override
    public final SocketAddress getLocalAddress() {
        return this.mLocalAddress;
    }

    protected IOExecutor executor() {
        return this.mExecutor;
    }

    abstract Channel createChannel(SimpleSocket var1) throws IOException;

    private Socket acceptSocket() throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    return SocketChannelAcceptor.this.mServerSocket.accept();
                }
            }, this.mContext);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

