/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;
import org.cojen.dirmi.io.Channel;
import org.cojen.dirmi.io.ChannelConnector;
import org.cojen.dirmi.io.CloseableGroup;
import org.cojen.dirmi.io.IOExecutor;
import org.cojen.dirmi.io.SimpleSocket;
import org.cojen.dirmi.io.SocketChannel;
import org.cojen.dirmi.util.Timer;

abstract class SocketChannelConnector
implements ChannelConnector {
    private final IOExecutor mExecutor;
    private final SocketAddress mRemoteAddress;
    private final SocketAddress mLocalAddress;
    private final SocketFactory mFactory;
    private final AccessControlContext mContext;
    private final CloseableGroup<Channel> mConnected;

    public SocketChannelConnector(IOExecutor executor, SocketAddress remoteAddress) {
        this(executor, remoteAddress, null);
    }

    public SocketChannelConnector(IOExecutor executor, SocketAddress remoteAddress, SocketAddress localAddress) {
        this(executor, remoteAddress, localAddress, SocketFactory.getDefault());
    }

    public SocketChannelConnector(IOExecutor executor, SocketAddress remoteAddress, SocketAddress localAddress, SocketFactory factory) {
        if (executor == null) {
            throw new IllegalArgumentException("Must provide an executor");
        }
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Must provide a remote address");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Must provide a SocketFactory");
        }
        this.mExecutor = executor;
        this.mRemoteAddress = remoteAddress;
        this.mLocalAddress = localAddress;
        this.mFactory = factory;
        this.mContext = AccessController.getContext();
        this.mConnected = new CloseableGroup();
    }

    @Override
    public Channel connect() throws IOException {
        return this.connect(-1L, null);
    }

    @Override
    public Channel connect(final long timeout, final TimeUnit unit) throws IOException {
        Socket socket;
        this.mConnected.checkClosed();
        if (timeout == 0L) {
            throw new RemoteTimeoutException(timeout, unit);
        }
        try {
            socket = AccessController.doPrivileged(new PrivilegedExceptionAction<Socket>(){

                @Override
                public Socket run() throws IOException {
                    return SocketChannelConnector.this.connectSocket(timeout, unit);
                }
            }, this.mContext);
        }
        catch (PrivilegedActionException e) {
            this.mConnected.checkClosed();
            throw (IOException)e.getCause();
        }
        Channel channel = this.createChannel(SocketChannel.toSimpleSocket(socket));
        channel.register(this.mConnected);
        return channel;
    }

    @Override
    public Channel connect(Timer timer) throws IOException {
        this.mConnected.checkClosed();
        return this.connect(RemoteTimeoutException.checkRemaining(timer), timer.unit());
    }

    @Override
    public void connect(final ChannelConnector.Listener listener) {
        try {
            this.mExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Channel channel;
                    if (SocketChannelConnector.this.mConnected.isClosed()) {
                        listener.closed(new ClosedException());
                        return;
                    }
                    try {
                        channel = SocketChannelConnector.this.connect();
                    }
                    catch (IOException e) {
                        if (SocketChannelConnector.this.mConnected.isClosed()) {
                            listener.closed(e);
                        } else {
                            listener.failed(e);
                        }
                        return;
                    }
                    listener.connected(channel);
                }
            });
        }
        catch (RejectedException e) {
            listener.rejected(e);
        }
    }

    Socket connectSocket(long timeout, TimeUnit unit) throws IOException {
        Socket socket = this.mFactory.createSocket();
        try {
            if (this.mLocalAddress != null) {
                socket.bind(this.mLocalAddress);
            }
            if (timeout < 0L) {
                socket.connect(this.mRemoteAddress);
            } else {
                long millis = unit.toMillis(timeout);
                if (millis <= 0L) {
                    throw new RemoteTimeoutException(timeout, unit);
                }
                if (millis > Integer.MAX_VALUE) {
                    socket.connect(this.mRemoteAddress);
                } else {
                    try {
                        socket.connect(this.mRemoteAddress, (int)millis);
                    }
                    catch (SocketTimeoutException e) {
                        throw new RemoteTimeoutException(timeout, unit);
                    }
                }
            }
            socket.setTcpNoDelay(true);
            return socket;
        }
        catch (SecurityException e) {
            SocketChannelConnector.disconnect(socket);
            throw e;
        }
        catch (IOException e) {
            SocketChannelConnector.disconnect(socket);
            throw e;
        }
    }

    @Override
    public void close() {
        this.mConnected.close();
    }

    public String toString() {
        return "ChannelConnector {localAddress=" + this.mLocalAddress + ", remoteAddress=" + this.mRemoteAddress + '}';
    }

    @Override
    public final SocketAddress getRemoteAddress() {
        return this.mRemoteAddress;
    }

    @Override
    public final SocketAddress getLocalAddress() {
        return this.mLocalAddress;
    }

    protected IOExecutor executor() {
        return this.mExecutor;
    }

    abstract Channel createChannel(SimpleSocket var1) throws IOException;

    private static void disconnect(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

