/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import org.cojen.dirmi.ClosedException;
import org.cojen.dirmi.RejectedException;
import org.cojen.dirmi.RemoteTimeoutException;

class Waiter<C extends Closeable> {
    private static final int AVAILABLE = 1;
    private static final int CLOSED = 2;
    private static final int INTERRUPTED = 3;
    private static final int TIMEOUT = 4;
    private static final int EXCEPTION = 5;
    private C mObject;
    private IOException mException;
    private int mState;
    private long mTimeout;
    private TimeUnit mTimeoutUnit;

    static <C extends Closeable> Waiter<C> create() {
        return new Waiter<C>();
    }

    private Waiter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void available(C object) {
        Waiter waiter = this;
        synchronized (waiter) {
            this.notify();
            if (this.mState == 0) {
                this.mObject = object;
                this.mState = 1;
                return;
            }
        }
        try {
            object.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void rejected(RejectedException e) {
        this.notify();
        if (this.mState == 0) {
            this.mException = e;
            this.mState = 5;
        }
    }

    public synchronized void failed(IOException e) {
        this.notify();
        if (this.mState == 0) {
            this.mException = e;
            this.mState = 5;
        }
    }

    public synchronized void closed(IOException e) {
        this.notify();
        if (this.mState == 0) {
            this.mState = 2;
        }
    }

    public synchronized C waitFor() throws IOException {
        C object;
        while ((object = this.check()) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return this.interrupted();
            }
        }
        return object;
    }

    public synchronized C waitFor(long timeout, TimeUnit unit) throws IOException {
        long now;
        long start = System.nanoTime();
        for (long timeoutNanos = unit.toNanos(timeout); timeoutNanos > 0L; timeoutNanos -= now - start) {
            C object = this.check();
            if (object != null) {
                return object;
            }
            now = System.nanoTime();
            start = now;
            try {
                this.wait(Math.max(1L, TimeUnit.NANOSECONDS.toMillis(timeoutNanos)));
                continue;
            }
            catch (InterruptedException e) {
                return this.interrupted();
            }
        }
        if (this.mState == 0) {
            this.mState = 4;
            this.mTimeout = timeout;
            this.mTimeoutUnit = unit;
        }
        return this.check();
    }

    private C check() throws IOException {
        switch (this.mState) {
            case 1: {
                return this.mObject;
            }
            case 2: {
                throw new ClosedException();
            }
            case 3: {
                throw new InterruptedIOException();
            }
            case 4: {
                throw new RemoteTimeoutException(this.mTimeout, this.mTimeoutUnit);
            }
            case 5: {
                this.mException.fillInStackTrace();
                throw this.mException;
            }
        }
        return null;
    }

    private C interrupted() throws IOException {
        if (this.mState == 0) {
            this.mState = 3;
        }
        return this.check();
    }
}

