/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cojen.dirmi.trace.TraceHandler;
import org.cojen.dirmi.trace.TraceModes;
import org.cojen.dirmi.trace.TraceToolbox;
import org.cojen.dirmi.trace.TracedMethod;
import org.cojen.util.IntHashMap;

public abstract class ScopedTraceHandler
implements TraceHandler {
    private final TraceToolbox mToolbox;
    private final ThreadLocal<Scope> mCurrentScope = new ThreadLocal();

    public ScopedTraceHandler(TraceToolbox toolbox) {
        this.mToolbox = toolbox;
    }

    @Override
    public TraceModes getTraceModes(String className) {
        return TraceModes.ALL_USER;
    }

    @Override
    public void enterMethod(int mid) {
        Scope scope = this.enterScope(mid);
        if (scope != null) {
            scope.enterMethod(mid);
        }
    }

    @Override
    public void enterMethod(int mid, Object argument) {
        Scope scope = this.enterScope(mid);
        if (scope != null) {
            scope.enterMethod(mid, argument);
        }
    }

    @Override
    public void enterMethod(int mid, Object ... arguments) {
        Scope scope = this.enterScope(mid);
        if (scope != null) {
            scope.enterMethod(mid, arguments);
        }
    }

    @Override
    public void exitMethod(int mid) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid)) {
            this.exitScope(scope);
        }
    }

    @Override
    public void exitMethod(int mid, long timeNanos) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid, timeNanos)) {
            this.exitScope(scope);
        }
    }

    @Override
    public void exitMethod(int mid, Object result) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid, result)) {
            this.exitScope(scope);
        }
    }

    @Override
    public void exitMethod(int mid, Object result, long timeNanos) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid, result, timeNanos)) {
            this.exitScope(scope);
        }
    }

    @Override
    public void exitMethod(int mid, Throwable t) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid, t)) {
            this.exitScope(scope);
        }
    }

    @Override
    public void exitMethod(int mid, Throwable t, long timeNanos) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null && scope.exitMethod(mid, t, timeNanos)) {
            this.exitScope(scope);
        }
    }

    protected TraceToolbox getToolbox() {
        return this.mToolbox;
    }

    protected boolean scopePut(String key, Object value) {
        Scope scope = this.mCurrentScope.get();
        if (scope == null) {
            return false;
        }
        scope.put(key, value);
        return true;
    }

    protected Object scopeGet(String key) {
        Scope scope = this.mCurrentScope.get();
        if (scope != null) {
            return scope.getExtraData().get(key);
        }
        return null;
    }

    protected abstract void report(Scope var1);

    private Scope enterScope(int mid) {
        Scope scope = this.mCurrentScope.get();
        if ((scope == null || TracedMethod.isRoot(mid)) && !TracedMethod.isGraft(mid)) {
            scope = new Scope(this.mToolbox, scope, Thread.currentThread());
            this.mCurrentScope.set(scope);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitScope(Scope scope) {
        try {
            this.report(scope);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable e) {
            Thread t = Thread.currentThread();
            t.getUncaughtExceptionHandler().uncaughtException(t, e);
        }
        finally {
            this.mCurrentScope.set(scope.transferToParent());
        }
    }

    public static final class MethodData {
        final TracedMethod mMethod;
        int mActiveCount;
        int mCallCount;
        long mTotalTimeNanos = -1L;

        MethodData(TracedMethod method) {
            this.mMethod = method;
        }

        public TracedMethod getTracedMethod() {
            return this.mMethod;
        }

        public boolean hasTotalTimeNanos() {
            return this.mTotalTimeNanos != -1L;
        }

        public long getTotalTimeNanos() {
            long total = this.mTotalTimeNanos;
            return total == -1L ? 0L : total;
        }

        public int getCallCount() {
            return this.mCallCount;
        }

        void entered() {
            ++this.mActiveCount;
            ++this.mCallCount;
        }

        boolean exited() {
            return --this.mActiveCount == 0;
        }

        boolean exited(long timeNanos) {
            if (this.exited()) {
                this.mTotalTimeNanos = this.getTotalTimeNanos() + timeNanos;
                return true;
            }
            return false;
        }

        void transferToParent(MethodData parent) {
            parent.mCallCount += this.mCallCount;
            long total = this.mTotalTimeNanos;
            if (total != -1L && parent.mActiveCount == 0) {
                parent.mTotalTimeNanos = parent.getTotalTimeNanos() + total;
            }
        }
    }

    public static class Scope {
        private final long mStartMillis = System.currentTimeMillis();
        private final TraceToolbox mToolbox;
        private final Scope mParent;
        private final Thread mThread;
        private final IntHashMap<MethodData> mMethodDataMap;
        private final ArrayList<MethodData> mMethodDataSequence;
        private Object[] mArguments;
        private boolean mHasResult;
        private Object mResult;
        private Throwable mException;
        private Map<String, Object> mExtraData;

        Scope(TraceToolbox toolbox, Scope parent, Thread thread) {
            this.mToolbox = toolbox;
            this.mParent = parent;
            this.mThread = thread;
            this.mMethodDataMap = new IntHashMap();
            this.mMethodDataSequence = new ArrayList();
        }

        public long getStartTimeMillis() {
            return this.mStartMillis;
        }

        public Thread getThread() {
            return this.mThread;
        }

        public boolean isRoot() {
            return this.mParent == null;
        }

        public List<MethodData> getMethodData() {
            return this.mMethodDataSequence;
        }

        public Object[] getArguments() {
            return this.mArguments;
        }

        public boolean hasResult() {
            return this.mHasResult;
        }

        public Object getResult() {
            return this.mResult;
        }

        public Throwable getException() {
            return this.mException;
        }

        public Map<String, Object> getExtraData() {
            Map<String, Object> extra = this.mExtraData;
            if (extra == null) {
                extra = Collections.emptyMap();
            }
            return extra;
        }

        void enterMethod(int mid) {
            this.getMethodData(mid).entered();
        }

        void enterMethod(int mid, Object ... arguments) {
            if (this.mMethodDataSequence.size() == 0) {
                this.mArguments = arguments;
            }
            this.getMethodData(mid).entered();
        }

        boolean exitMethod(int mid) {
            MethodData md = this.getMethodData(mid);
            return md.exited() && md == this.mMethodDataSequence.get(0);
        }

        boolean exitMethod(int mid, long timeNanos) {
            MethodData md = this.getMethodData(mid);
            return md.exited(timeNanos) && md == this.mMethodDataSequence.get(0);
        }

        boolean exitMethod(int mid, Object result) {
            MethodData md = this.getMethodData(mid);
            if (md.exited() && md == this.mMethodDataSequence.get(0)) {
                this.mResult = result;
                this.mHasResult = true;
                return true;
            }
            return false;
        }

        boolean exitMethod(int mid, Object result, long timeNanos) {
            MethodData md = this.getMethodData(mid);
            if (md.exited(timeNanos) && md == this.mMethodDataSequence.get(0)) {
                this.mResult = result;
                this.mHasResult = true;
                return true;
            }
            return false;
        }

        boolean exitMethod(int mid, Throwable t) {
            MethodData md = this.getMethodData(mid);
            if (md.exited() && md == this.mMethodDataSequence.get(0)) {
                this.mException = t;
                return true;
            }
            return false;
        }

        boolean exitMethod(int mid, Throwable t, long timeNanos) {
            MethodData md = this.getMethodData(mid);
            if (md.exited(timeNanos) && md == this.mMethodDataSequence.get(0)) {
                this.mException = t;
                return true;
            }
            return false;
        }

        void put(String key, Object value) {
            if (this.mExtraData == null) {
                this.mExtraData = new HashMap<String, Object>();
            }
            this.mExtraData.put(key, value);
        }

        Scope transferToParent() {
            Scope parent = this.mParent;
            if (parent != null) {
                for (MethodData md : this.mMethodDataSequence) {
                    int mid = md.mMethod.getMethodId();
                    MethodData pmd = (MethodData)parent.mMethodDataMap.get(mid);
                    if (pmd == null) {
                        parent.mMethodDataMap.put(mid, (Object)md);
                        parent.mMethodDataSequence.add(md);
                        continue;
                    }
                    md.transferToParent(pmd);
                }
            }
            return parent;
        }

        private MethodData getMethodData(int mid) {
            MethodData md = (MethodData)this.mMethodDataMap.get(mid);
            if (md == null) {
                md = new MethodData(this.mToolbox.getTracedMethod(mid));
                this.mMethodDataMap.put(mid, (Object)md);
                this.mMethodDataSequence.add(md);
            }
            return md;
        }
    }
}

