/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.cojen.dirmi.trace.ScopedTraceHandler;
import org.cojen.dirmi.trace.TraceToolbox;
import org.cojen.dirmi.trace.TracedMethod;

public class SimpleHandler
extends ScopedTraceHandler {
    private static Constructor cDateTimeCtor;
    private static volatile SimpleHandler cHandler;

    public static void setMessage(String message) {
        SimpleHandler handler = cHandler;
        if (handler != null) {
            handler.scopePut("message", message);
        }
    }

    private static String formatDate(long millis) {
        if (cDateTimeCtor != null) {
            try {
                return cDateTimeCtor.newInstance(millis).toString();
            }
            catch (Exception e) {
                cDateTimeCtor = null;
            }
        }
        return new Date(millis).toString();
    }

    public SimpleHandler(TraceToolbox toolbox) {
        super(toolbox);
        cHandler = this;
    }

    @Override
    protected void report(ScopedTraceHandler.Scope scope) {
        List<ScopedTraceHandler.MethodData> mdList = scope.getMethodData();
        StringBuilder b = new StringBuilder(500);
        b.append(">>> BEGIN TRACE\n");
        ScopedTraceHandler.MethodData root = mdList.get(0);
        TracedMethod rootMethod = root.getTracedMethod();
        if (rootMethod.getOperation() != null) {
            b.append("operation: ").append(rootMethod.getOperation()).append('\n');
        } else {
            b.append("operation: ").append(rootMethod).append('\n');
        }
        b.append("start:     ").append(SimpleHandler.formatDate(scope.getStartTimeMillis())).append('\n');
        b.append("thread:    ").append(scope.getThread()).append('\n');
        Object message = scope.getExtraData().get("message");
        if (message != null) {
            b.append("message:   ").append(message).append('\n');
        }
        if (scope.getArguments() != null) {
            b.append("args: ").append(Arrays.deepToString(scope.getArguments())).append('\n');
        }
        if (scope.hasResult()) {
            b.append("result: ").append(scope.getResult()).append('\n');
        }
        if (scope.getException() != null) {
            b.append("exception: ").append(scope.getException()).append('\n');
        }
        b.append("details...").append('\n');
        for (ScopedTraceHandler.MethodData md : mdList) {
            b.append("  ").append(md.getTracedMethod()).append('\n');
            int calls = md.getCallCount();
            long time = md.getTotalTimeNanos();
            b.append("    invocations:  ").append(calls).append('\n');
            if (!md.hasTotalTimeNanos()) continue;
            b.append("    total time:   ").append(time).append("ns\n");
            double dTime = time;
            if (calls == 1) {
                b.append("    average time: ").append(time).append("ns\n");
            } else {
                double average = dTime / (double)calls;
                b.append("    average time: ").append(average).append("ns\n");
            }
            if (time == root.getTotalTimeNanos()) {
                b.append("    percent time: 100\n");
                continue;
            }
            double percent = 100.0 * (dTime / (double)root.getTotalTimeNanos());
            b.append("    percent time: ").append(percent).append('\n');
        }
        b.append("<<< END TRACE");
        System.out.println(b);
    }

    static {
        try {
            cDateTimeCtor = Class.forName("org.joda.time.DateTime").getConstructor(Long.TYPE);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

