/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.cojen.dirmi.trace.TraceHandler;
import org.cojen.dirmi.trace.TraceModes;
import org.cojen.dirmi.trace.TraceToolbox;
import org.cojen.dirmi.trace.TracedMethod;
import org.cojen.dirmi.trace.TracedMethodRegistry;
import org.cojen.dirmi.trace.Transformer;

public class TraceAgent {
    private static final Random cRandom = new SecureRandom();
    private static final Map<Long, TraceAgent> cAgents = new HashMap<Long, TraceAgent>();
    private final long mAgentId;
    private final TracedMethodRegistry mRegistry = new TracedMethodRegistry();
    private final TraceHandler mHandler;

    public static void premain(String agentArgs, Instrumentation inst) throws Throwable {
        TraceAgent agent = new TraceAgent(agentArgs);
        inst.addTransformer(new Transformer(agent));
    }

    public static TraceAgent getTraceAgent(long id) {
        return cAgents.get(id);
    }

    private static synchronized long registerAgent(TraceAgent agent) {
        Long id;
        while (cAgents.containsKey(id = Long.valueOf(cRandom.nextLong()))) {
        }
        cAgents.put(id, agent);
        return id;
    }

    private TraceAgent(String agentArgs) throws Throwable {
        TraceHandler handler;
        boolean passArg;
        Constructor<?> ctor;
        String arg;
        String name;
        if (agentArgs == null) {
            throw new IllegalArgumentException("Must pass handler class name. For example, \"java -javaagent:<path to agent jar file>=<class name of trace handler> ...\"");
        }
        int index = agentArgs.indexOf(59);
        if (index < 0) {
            name = agentArgs;
            arg = null;
        } else {
            name = agentArgs.substring(0, index);
            arg = agentArgs.substring(index + 1);
        }
        Class<?> handlerClass = Class.forName(name);
        if (!TraceHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("Class doesn't implement TraceHandler: " + handlerClass.getName());
        }
        if (arg == null) {
            try {
                ctor = handlerClass.getConstructor(TraceToolbox.class);
                passArg = false;
            }
            catch (NoSuchMethodException e) {
                try {
                    ctor = handlerClass.getConstructor(TraceToolbox.class, String.class);
                }
                catch (NoSuchMethodException e2) {
                    throw e;
                }
                passArg = true;
            }
        } else {
            try {
                ctor = handlerClass.getConstructor(TraceToolbox.class, String.class);
                passArg = true;
            }
            catch (NoSuchMethodException e) {
                try {
                    ctor = handlerClass.getConstructor(TraceToolbox.class);
                }
                catch (NoSuchMethodException e2) {
                    throw e;
                }
                passArg = false;
            }
        }
        TraceToolbox toolbox = new TraceToolbox(this.mRegistry);
        Object[] ctorArgs = new Object[passArg ? 2 : 1];
        ctorArgs[0] = toolbox;
        if (passArg) {
            ctorArgs[1] = arg;
        }
        try {
            handler = (TraceHandler)ctor.newInstance(ctorArgs);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw cause == null ? e : cause;
        }
        this.mAgentId = TraceAgent.registerAgent(this);
        this.mHandler = handler;
    }

    public TraceHandler getTraceHandler() {
        return this.mHandler;
    }

    public void registerTraceMethod(int mid, String operation, Class clazz, String methodName, Class returnType, Class ... paramTypes) {
        this.mRegistry.registerMethod(mid, new TracedMethod(mid, operation, clazz, methodName, returnType, paramTypes));
    }

    public long getAgentId() {
        return this.mAgentId;
    }

    TraceModes getTraceModes(String className) {
        return this.mHandler.getTraceModes(className);
    }

    int reserveMethod(boolean root, boolean graft) {
        return this.mRegistry.reserveMethod(root, graft);
    }
}

