/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import java.lang.ref.WeakReference;
import org.cojen.classfile.TypeDesc;

public class TracedMethod {
    private static final Class[] NO_PARAMS = new Class[0];
    private final int mMID;
    private final String mOperation;
    private final WeakReference<Class> mClass;
    private final String mMethodName;
    private final WeakReference<Class> mReturnType;
    private final WeakReference<Class>[] mParamTypes;
    private final String mStr;

    public static boolean isRoot(int mid) {
        return (mid & Integer.MIN_VALUE) != 0;
    }

    public static boolean isGraft(int mid) {
        return (mid & 0x40000000) != 0;
    }

    TracedMethod(int mid, String operation, Class clazz, String methodName, Class returnType, Class ... paramTypes) {
        this.mMID = mid;
        this.mOperation = operation;
        StringBuilder b = new StringBuilder();
        b.append(returnType == null ? "void" : returnType.getName()).append(' ');
        b.append(TypeDesc.forClass((Class)clazz).getFullName());
        if (methodName != null) {
            b.append('.').append(methodName);
        }
        b.append('(');
        this.mClass = new WeakReference<Class>(clazz);
        this.mMethodName = methodName;
        this.mReturnType = returnType == null ? null : new WeakReference<Class>(returnType);
        if (paramTypes == null || paramTypes.length == 0) {
            this.mParamTypes = null;
        } else {
            this.mParamTypes = new WeakReference[paramTypes.length];
            boolean any = false;
            for (int i = 0; i < paramTypes.length; ++i) {
                Class paramType;
                if (any) {
                    b.append(", ");
                }
                if ((paramType = paramTypes[i]) != null) {
                    b.append(TypeDesc.forClass((Class)paramType).getFullName());
                    any = true;
                }
                this.mParamTypes[i] = paramType == null ? this.mClass : new WeakReference<Class>(paramType);
            }
        }
        this.mStr = b.append(')').toString();
    }

    public String getOperation() {
        return this.mOperation;
    }

    public boolean isConstructor() {
        return this.mMethodName == null;
    }

    public boolean isStatic() {
        WeakReference<Class>[] paramTypes = this.mParamTypes;
        return paramTypes == null || paramTypes[0] != this.mClass;
    }

    public Class getDeclaringClass() {
        return (Class)this.mClass.get();
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public Class getReturnType() {
        return this.mReturnType == null ? null : (Class)this.mReturnType.get();
    }

    public boolean isVoid() {
        return this.mReturnType == null;
    }

    public Class[] getParameterTypes() {
        WeakReference<Class>[] paramTypes = this.mParamTypes;
        if (paramTypes == null) {
            return NO_PARAMS;
        }
        int length = paramTypes.length;
        Class[] classes = new Class[length];
        int i = length;
        while (--i >= 0) {
            classes[i] = (Class)paramTypes[i].get();
        }
        return classes;
    }

    public boolean isRoot() {
        return TracedMethod.isRoot(this.mMID);
    }

    public boolean isGraft() {
        return TracedMethod.isGraft(this.mMID);
    }

    public int getMethodId() {
        return this.mMID;
    }

    public String toString() {
        return this.mStr;
    }
}

