/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import org.cojen.dirmi.trace.TracedMethod;
import org.cojen.util.IntHashMap;

class TracedMethodRegistry {
    private final IntHashMap<TracedMethod> mMethodMap = new IntHashMap();
    private int mNextId;

    public synchronized TracedMethod getTracedMethod(int mid) {
        return (TracedMethod)this.mMethodMap.get(mid);
    }

    public synchronized int reserveMethod(boolean root, boolean graft) {
        int id = ++this.mNextId;
        if (root) {
            id |= Integer.MIN_VALUE;
        }
        if (graft) {
            id |= 0x40000000;
        }
        this.mMethodMap.put(id, null);
        return id;
    }

    public synchronized void registerMethod(int mid, TracedMethod method) {
        if (this.mMethodMap.get(mid) != null || !this.mMethodMap.containsKey(mid)) {
            throw new IllegalStateException("Unknown mid: " + mid);
        }
        this.mMethodMap.put(mid, (Object)method);
    }
}

