/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.trace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.CodeDisassembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.TypeDesc;
import org.cojen.classfile.attribute.Annotation;
import org.cojen.classfile.constant.ConstantIntegerInfo;
import org.cojen.classfile.constant.ConstantStringInfo;
import org.cojen.classfile.constant.ConstantUTFInfo;
import org.cojen.dirmi.Trace;
import org.cojen.dirmi.trace.TraceAgent;
import org.cojen.dirmi.trace.TraceHandler;
import org.cojen.dirmi.trace.TraceMode;
import org.cojen.dirmi.trace.TraceModes;

class Transformer
implements ClassFileTransformer {
    private static final boolean DEBUG = Boolean.getBoolean("org.cojen.dirmi.trace.Transformer.DEBUG");
    private static final String HANDLER_FIELD_PREFIX = Transformer.class.getName().replace('.', '$') + "$handler$";
    private static int cHandlerFieldCounter = 0;
    private final TraceAgent mAgent;
    final String mHandlerFieldName;

    private static synchronized String handlerFieldName() {
        String name = HANDLER_FIELD_PREFIX + cHandlerFieldCounter;
        ++cHandlerFieldCounter;
        return name;
    }

    Transformer(TraceAgent agent) {
        this.mAgent = agent;
        this.mHandlerFieldName = Transformer.handlerFieldName();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        CodeDisassembler dis;
        ClassFile cf;
        if (loader == null) {
            return null;
        }
        try {
            loader.loadClass(TraceAgent.class.getName());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        className = className.replace('/', '.');
        if (className.startsWith("org.cojen.dirmi.trace.") || className.startsWith("sun.reflect.")) {
            return null;
        }
        TraceModes modes = this.mAgent.getTraceModes(className);
        if (modes == null || modes == TraceModes.ALL_OFF) {
            return null;
        }
        try {
            cf = ClassFile.readFrom((InputStream)new ByteArrayInputStream(classfileBuffer));
        }
        catch (Exception e) {
            IllegalClassFormatException e2 = new IllegalClassFormatException();
            e2.initCause(e);
            throw e2;
        }
        if (cf.getModifiers().isInterface()) {
            return null;
        }
        HashMap<MethodInfo, MidAndOp> transformedMethods = new HashMap<MethodInfo, MidAndOp>();
        for (MethodInfo mi : cf.getMethods()) {
            this.tryTransform(modes, transformedMethods, mi);
        }
        for (MethodInfo mi : cf.getConstructors()) {
            this.tryTransform(modes, transformedMethods, mi);
        }
        if (transformedMethods.size() == 0) {
            return null;
        }
        cf.addField(Modifiers.PRIVATE.toStatic(true), this.mHandlerFieldName, TypeDesc.forClass(TraceHandler.class));
        MethodInfo clinit = cf.getInitializer();
        if (clinit == null) {
            dis = null;
            clinit = cf.addInitializer();
        } else {
            dis = new CodeDisassembler(clinit);
        }
        CodeBuilder b = new CodeBuilder(clinit);
        TypeDesc agentType = TypeDesc.forClass(TraceAgent.class);
        LocalVariable agentVar = b.createLocalVariable("agent", agentType);
        b.loadConstant(this.mAgent.getAgentId());
        b.invokeStatic(agentType, "getTraceAgent", agentType, new TypeDesc[]{TypeDesc.LONG});
        b.storeLocal(agentVar);
        TypeDesc handlerType = TypeDesc.forClass(TraceHandler.class);
        b.loadLocal(agentVar);
        b.invokeVirtual(agentType, "getTraceHandler", handlerType, null);
        b.storeStaticField(this.mHandlerFieldName, handlerType);
        TypeDesc classType = TypeDesc.forClass(Class.class);
        TypeDesc classArrayType = classType.toArrayType();
        for (Map.Entry entry : transformedMethods.entrySet()) {
            MethodInfo mi = (MethodInfo)entry.getKey();
            MidAndOp midAndOp = (MidAndOp)entry.getValue();
            b.loadLocal(agentVar);
            b.loadConstant(midAndOp.mid);
            b.loadConstant(midAndOp.operation);
            b.loadConstant(cf.getType());
            b.loadConstant(mi.getName().equals("<init>") ? null : mi.getName());
            TypeDesc returnType = mi.getMethodDescriptor().getReturnType();
            if (returnType == null || returnType == TypeDesc.VOID) {
                b.loadNull();
            } else {
                b.loadConstant(returnType);
            }
            int hasThis = mi.getModifiers().isStatic() ? 0 : 1;
            TypeDesc[] types = mi.getMethodDescriptor().getParameterTypes();
            if (hasThis + types.length == 0) {
                b.loadNull();
            } else {
                b.loadConstant(hasThis + types.length);
                b.newObject(classArrayType);
                for (int i = 0; i < types.length; ++i) {
                    b.dup();
                    b.loadConstant(hasThis + i);
                    b.loadConstant(types[i]);
                    b.storeToArray(classType);
                }
            }
            b.invokeVirtual(agentType, "registerTraceMethod", null, new TypeDesc[]{TypeDesc.INT, TypeDesc.STRING, classType, TypeDesc.STRING, classType, classArrayType});
        }
        if (dis == null) {
            b.returnVoid();
        } else {
            dis.disassemble((CodeAssembler)b);
        }
        if (DEBUG) {
            File file = new File(cf.getClassName().replace('.', '/') + ".class");
            try {
                File tempDir = new File(System.getProperty("java.io.tmpdir"));
                file = new File(tempDir, file.getPath());
            }
            catch (SecurityException e) {
                // empty catch block
            }
            try {
                file.getParentFile().mkdirs();
                System.out.println("Dirmi trace Transformer writing to " + file);
                FileOutputStream out = new FileOutputStream(file);
                cf.writeTo((OutputStream)out);
                ((OutputStream)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            cf.writeTo((OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            IllegalClassFormatException e2 = new IllegalClassFormatException();
            e2.initCause(e);
            throw e2;
        }
        return out.toByteArray();
    }

    private String getStringParam(Map<String, Annotation.MemberValue> memberValues, String paramName) {
        Object constant;
        Annotation.MemberValue mv = memberValues.get(paramName);
        if (mv != null && (constant = mv.getValue()) != null) {
            if (constant instanceof ConstantUTFInfo) {
                return ((ConstantUTFInfo)constant).getValue();
            }
            if (constant instanceof ConstantStringInfo) {
                return ((ConstantStringInfo)constant).getValue();
            }
        }
        return null;
    }

    private Boolean getBooleanParam(Map<String, Annotation.MemberValue> memberValues, String paramName) {
        Object constant;
        Annotation.MemberValue mv = memberValues.get(paramName);
        if (mv != null && (constant = mv.getValue()) != null && constant instanceof ConstantIntegerInfo) {
            return ((ConstantIntegerInfo)constant).getValue() != 0;
        }
        return null;
    }

    private boolean getBooleanParam(Map<String, Annotation.MemberValue> memberValues, String paramName, boolean defaultValue) {
        Boolean value = this.getBooleanParam(memberValues, paramName);
        return value == null ? defaultValue : value;
    }

    private void tryTransform(TraceModes modes, Map<MethodInfo, MidAndOp> transformedMethods, MethodInfo mi) {
        boolean graft;
        boolean root;
        boolean time;
        boolean exception;
        boolean result;
        boolean args;
        String operation;
        Annotation[] annotations;
        if (mi.getModifiers().isAbstract() || mi.getModifiers().isNative()) {
            return;
        }
        Annotation traceAnnotation = null;
        for (Annotation ann : annotations = mi.getRuntimeVisibleAnnotations()) {
            if (!ann.getType().getFullName().equals(Trace.class.getName())) continue;
            traceAnnotation = ann;
            break;
        }
        if (traceAnnotation == null) {
            operation = null;
            args = modes.getTraceArguments() == TraceMode.ON;
            result = modes.getTraceResult() == TraceMode.ON;
            exception = modes.getTraceException() == TraceMode.ON;
            boolean bl = time = modes.getTraceTime() == TraceMode.ON;
            if (!(args || result || exception || time || modes.getTraceCalls() == TraceMode.ON)) {
                return;
            }
            root = false;
            graft = false;
        } else {
            Map memberValues = traceAnnotation.getMemberValues();
            operation = this.getStringParam(memberValues, "operation");
            if ("".equals(operation)) {
                operation = null;
            }
            args = this.getBooleanParam(memberValues, "args", false);
            if (modes.getTraceArguments() != TraceMode.USER) {
                args = modes.getTraceArguments() == TraceMode.ON;
            }
            result = this.getBooleanParam(memberValues, "result", false);
            if (modes.getTraceResult() != TraceMode.USER) {
                result = modes.getTraceResult() == TraceMode.ON;
            }
            exception = this.getBooleanParam(memberValues, "exception", false);
            if (modes.getTraceException() != TraceMode.USER) {
                exception = modes.getTraceException() == TraceMode.ON;
            }
            time = this.getBooleanParam(memberValues, "time", true);
            if (modes.getTraceTime() != TraceMode.USER) {
                boolean bl = time = modes.getTraceTime() == TraceMode.ON;
            }
            if (!(args || result || exception || time || modes.getTraceCalls() != TraceMode.OFF)) {
                return;
            }
            root = this.getBooleanParam(memberValues, "root", false);
            graft = this.getBooleanParam(memberValues, "graft", false);
        }
        int mid = this.transform(mi, operation, args, result, exception, time, root, graft);
        transformedMethods.put(mi, new MidAndOp(mid, operation));
    }

    private int transform(MethodInfo mi, String operation, boolean args, boolean result, boolean exception, boolean time, boolean root, boolean graft) {
        TypeDesc[] exitMethodParams;
        TypeDesc[] exitMethodParams2;
        TypeDesc[] params;
        if (mi.getMethodDescriptor().getReturnType() == TypeDesc.VOID) {
            result = false;
        }
        int mid = this.mAgent.reserveMethod(root, graft);
        CodeDisassembler dis = new CodeDisassembler(mi);
        CodeBuilder b = new CodeBuilder(mi);
        b.loadStaticField(this.mHandlerFieldName, TypeDesc.forClass(TraceHandler.class));
        b.loadConstant(mid);
        if (!args) {
            params = new TypeDesc[]{TypeDesc.INT};
        } else {
            int hasThis;
            int argCount = mi.getMethodDescriptor().getParameterCount();
            int n = hasThis = mi.getModifiers().isStatic() ? 0 : 1;
            if ((argCount += hasThis) == 0) {
                params = new TypeDesc[]{TypeDesc.INT};
            } else if (argCount == 1) {
                params = new TypeDesc[]{TypeDesc.INT, TypeDesc.OBJECT};
                if (hasThis != 0) {
                    b.loadThis();
                } else {
                    b.loadLocal(b.getParameter(0));
                    b.convert(b.getParameter(0).getType(), TypeDesc.OBJECT);
                }
            } else {
                params = new TypeDesc[]{TypeDesc.INT, TypeDesc.OBJECT.toArrayType()};
                b.loadConstant(argCount);
                b.newObject(TypeDesc.OBJECT.toArrayType());
                if (hasThis != 0) {
                    b.dup();
                    b.loadConstant(0);
                    b.loadThis();
                    b.storeToArray(TypeDesc.OBJECT);
                    --argCount;
                }
                for (int i = 0; i < argCount; ++i) {
                    b.dup();
                    b.loadConstant(hasThis + i);
                    b.loadLocal(b.getParameter(i));
                    b.convert(b.getParameter(i).getType(), TypeDesc.OBJECT);
                    b.storeToArray(TypeDesc.OBJECT);
                }
            }
        }
        b.invokeInterface(TypeDesc.forClass(TraceHandler.class), "enterMethod", null, params);
        LocalVariable startTime = null;
        if (time) {
            startTime = b.createLocalVariable("startTime", TypeDesc.LONG);
            b.invokeStatic(TypeDesc.forClass(System.class), "nanoTime", TypeDesc.LONG, null);
            b.storeLocal(startTime);
        }
        Label tryStart = b.createLabel().setLocation();
        Label tryEnd = b.createLabel();
        dis.disassemble((CodeAssembler)b, null, (Location)tryEnd);
        tryEnd.setLocation();
        LocalVariable resultVar = null;
        if (result) {
            resultVar = b.createLocalVariable("result", mi.getMethodDescriptor().getReturnType());
            b.storeLocal(resultVar);
        }
        b.loadStaticField(this.mHandlerFieldName, TypeDesc.forClass(TraceHandler.class));
        b.loadConstant(mid);
        if (time) {
            if (result) {
                exitMethodParams2 = new TypeDesc[]{TypeDesc.INT, TypeDesc.OBJECT, TypeDesc.LONG};
                b.loadLocal(resultVar);
                b.convert(resultVar.getType(), TypeDesc.OBJECT);
            } else {
                exitMethodParams2 = new TypeDesc[]{TypeDesc.INT, TypeDesc.LONG};
            }
        } else if (result) {
            exitMethodParams2 = new TypeDesc[]{TypeDesc.INT, TypeDesc.OBJECT};
            b.loadLocal(resultVar);
            b.convert(resultVar.getType(), TypeDesc.OBJECT);
        } else {
            exitMethodParams2 = new TypeDesc[]{TypeDesc.INT};
        }
        if (time) {
            b.invokeStatic(TypeDesc.forClass(System.class), "nanoTime", TypeDesc.LONG, null);
            b.loadLocal(startTime);
            b.math((byte)101);
        }
        b.invokeInterface(TypeDesc.forClass(TraceHandler.class), "exitMethod", null, exitMethodParams2);
        if (result) {
            b.loadLocal(resultVar);
        }
        b.returnValue(mi.getMethodDescriptor().getReturnType());
        b.exceptionHandler((Location)tryStart, (Location)tryEnd, null);
        TypeDesc throwableType = TypeDesc.forClass(Throwable.class);
        LocalVariable exceptionVar = null;
        if (exception) {
            exceptionVar = b.createLocalVariable("e", throwableType);
            b.storeLocal(exceptionVar);
        }
        b.loadStaticField(this.mHandlerFieldName, TypeDesc.forClass(TraceHandler.class));
        b.loadConstant(mid);
        if (time) {
            if (exception) {
                exitMethodParams = new TypeDesc[]{TypeDesc.INT, throwableType, TypeDesc.LONG};
                b.loadLocal(exceptionVar);
            } else {
                exitMethodParams = new TypeDesc[]{TypeDesc.INT, TypeDesc.LONG};
            }
        } else if (exception) {
            exitMethodParams = new TypeDesc[]{TypeDesc.INT, throwableType};
            b.loadLocal(exceptionVar);
        } else {
            exitMethodParams = new TypeDesc[]{TypeDesc.INT};
        }
        if (time) {
            b.invokeStatic(TypeDesc.forClass(System.class), "nanoTime", TypeDesc.LONG, null);
            b.loadLocal(startTime);
            b.math((byte)101);
        }
        b.invokeInterface(TypeDesc.forClass(TraceHandler.class), "exitMethod", null, exitMethodParams);
        if (exception) {
            b.loadLocal(exceptionVar);
        }
        b.throwObject();
        return mid;
    }

    private static class MidAndOp {
        public final int mid;
        public final String operation;

        MidAndOp(int mid, String operation) {
            this.mid = mid;
            this.operation = operation;
        }
    }
}

