/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.util;

import java.security.SecureRandom;

class MersenneTwisterFast {
    private static final SecureRandom cSecureRandom = new SecureRandom();
    private static final ThreadLocal<MersenneTwisterFast> cLocalInstance = new ThreadLocal<MersenneTwisterFast>(){

        @Override
        public MersenneTwisterFast initialValue() {
            return MersenneTwisterFast.newInstance();
        }
    };
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;

    static MersenneTwisterFast newInstance() {
        SecureRandom secure = cSecureRandom;
        int[] seed = new int[624];
        for (int i = 0; i < seed.length; ++i) {
            seed[i] = secure.nextInt();
        }
        return new MersenneTwisterFast(seed);
    }

    static MersenneTwisterFast localInstance() {
        return cLocalInstance.get();
    }

    public MersenneTwisterFast(long seed) {
        this.setSeed(seed);
    }

    public MersenneTwisterFast(int[] array) {
        this.setSeed(array);
    }

    public void setSeed(long seed) {
        this.mt = new int[624];
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
        this.mt[0] = (int)(seed & 0xFFFFFFFFFFFFFFFFL);
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    public void setSeed(int[] array) {
        int k;
        if (array.length == 0) {
            throw new IllegalArgumentException("Array length must be greater than zero");
        }
        this.setSeed(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > array.length ? 624 : array.length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + array[j] + j;
            ++j;
            if (++i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= array.length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    public final int nextInt() {
        int y;
        if (this.mti >= 624) {
            int kk;
            int[] mt = this.mt;
            int[] mag01 = this.mag01;
            for (kk = 0; kk < 227; ++kk) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = mt[kk] & Integer.MIN_VALUE | mt[kk + 1] & Integer.MAX_VALUE;
                mt[kk] = mt[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = mt[623] & Integer.MIN_VALUE | mt[0] & Integer.MAX_VALUE;
            mt[623] = mt[396] ^ y >>> 1 ^ mag01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    public final int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)(this.nextInt() >>> 1) >> 31);
        }
        while ((bits = this.nextInt() >>> 1) - (val = bits % n) + n - 1 < 0) {
        }
        return val;
    }

    public final void nextBytes(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int rnd = this.nextInt();
            int n = Math.min(bytes.length - i, 4);
            while (n-- > 0) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    public final long nextLong() {
        return ((long)this.nextInt() << 32) + (long)this.nextInt();
    }

    public final long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be > 0");
        }
        while ((bits = ((long)this.nextInt() << 32) + (long)this.nextInt() >>> 1) - (val = bits % n) + n - 1L < 0L) {
        }
        return val;
    }

    public final double nextDouble() {
        return (double)(((long)(this.nextInt() >>> 6) << 27) + (long)(this.nextInt() >>> 5)) / 9.007199254740992E15;
    }

    public final float nextFloat() {
        return (float)(this.nextInt() >>> 8) / 1.6777216E7f;
    }

    public final boolean nextBoolean() {
        return this.nextInt() >>> 31 != 0;
    }
}

