/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.util;

import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.cojen.dirmi.util.Random;

public class ThreadPool
extends AbstractExecutorService
implements ScheduledExecutorService {
    private static final boolean LIMIT_REACHED_THREAD_DUMP;
    private static final boolean LIMIT_REACHED_SYSTEM_EXIT;
    private static final AtomicLong cPoolNumber;
    static final AtomicLong cTaskNumber;
    private static final String SHUTDOWN_MESSAGE = "Thread pool is shutdown";
    private final AccessControlContext mContext;
    private final ThreadGroup mGroup;
    private final AtomicLong mThreadNumber = new AtomicLong(1L);
    private final String mNamePrefix;
    private final boolean mDaemon;
    private final Thread.UncaughtExceptionHandler mHandler;
    private final int mMax;
    private final long mIdleTimeout = 10000L;
    private final LinkedList<PooledThread> mPool;
    private final HashSet<PooledThread> mAllThreads;
    private final TreeSet<Task> mScheduledTasks;
    private boolean mTaskRunnerReady;
    private int mActive;
    private boolean mShutdown;

    public ThreadPool(int max, boolean daemon) {
        this(max, daemon, null, null);
    }

    public ThreadPool(int max, boolean daemon, String prefix) {
        this(max, daemon, prefix, null);
    }

    public ThreadPool(int max, boolean daemon, String prefix, Thread.UncaughtExceptionHandler handler) {
        if (max <= 0) {
            throw new IllegalArgumentException("Maximum number of threads must be greater than zero: " + max);
        }
        this.mContext = AccessController.getContext();
        SecurityManager s = System.getSecurityManager();
        ThreadGroup threadGroup = this.mGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        if (prefix == null) {
            prefix = "pool";
        }
        this.mNamePrefix = prefix + '-' + cPoolNumber.getAndIncrement() + "-thread-";
        this.mDaemon = daemon;
        this.mHandler = handler;
        this.mMax = max;
        this.mPool = new LinkedList();
        this.mAllThreads = new HashSet();
        this.mScheduledTasks = new TreeSet();
    }

    @Override
    public void execute(Runnable command) throws RejectedExecutionException {
        this.execute(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Runnable command, boolean force) throws RejectedExecutionException {
        if (command == null) {
            throw new NullPointerException("Command is null");
        }
        while (true) {
            PooledThread thread;
            block16: {
                LinkedList<PooledThread> linkedList = this.mPool;
                synchronized (linkedList) {
                    if (!force && this.mShutdown) {
                        throw new RejectedExecutionException(SHUTDOWN_MESSAGE);
                    }
                    if (!this.mPool.isEmpty()) {
                        thread = this.mPool.removeLast();
                        break block16;
                    }
                    if (this.mActive >= this.mMax) {
                        this.limitReached();
                    }
                    ++this.mActive;
                }
                try {
                    thread = this.startNewPooledThread(command);
                }
                catch (Error e) {
                    --this.mActive;
                    throw e;
                }
                return;
            }
            try {
                if (thread.setCommand(command)) {
                    return;
                }
            }
            catch (IllegalStateException e) {
                if (this.isShutdown()) {
                    throw new RejectedExecutionException(SHUTDOWN_MESSAGE);
                }
                throw e;
            }
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void limitReached() {
        String message = "Too many active threads: " + this.mMax;
        if (LIMIT_REACHED_THREAD_DUMP) {
            System.err.println(new Date() + ": " + message + "; dumping current thread and all pooled threads");
            Thread current = Thread.currentThread();
            ThreadPool.dump(System.err, current);
            HashSet<PooledThread> hashSet = this.mAllThreads;
            synchronized (hashSet) {
                for (PooledThread t : this.mAllThreads) {
                    if (t == current) continue;
                    ThreadPool.dump(System.err, t);
                }
            }
        }
        if (LIMIT_REACHED_SYSTEM_EXIT) {
            RejectedExecutionException e = new RejectedExecutionException(message + "; exiting");
            try {
                Thread t = Thread.currentThread();
                t.getUncaughtExceptionHandler().uncaughtException(t, e);
                System.exit(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        throw new RejectedExecutionException(message);
    }

    private static void dump(PrintStream out, Thread t) {
        out.println('\"' + t.getName() + "\" state=" + (Object)((Object)t.getState()));
        try {
            StackTraceElement[] trace;
            for (StackTraceElement element : trace = t.getStackTrace()) {
                out.println("\t at " + element);
            }
        }
        catch (SecurityException e) {
            out.println(e);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return new Task<Object>(Executors.callable(command), delay, 0L, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return new Task<V>(callable, delay, 0L, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        return new Task<Object>(Executors.callable(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleAtRandomRate(Runnable command, long initialDelay, long lowPeriod, long highPeriod, TimeUnit unit) {
        if (lowPeriod < 0L || highPeriod <= 0L || lowPeriod > highPeriod) {
            throw new IllegalArgumentException();
        }
        Callable<Object> callable = Executors.callable(command);
        if (lowPeriod == highPeriod) {
            return new Task<Object>(callable, initialDelay, lowPeriod, unit);
        }
        return new JitterTask<Object>(callable, initialDelay, lowPeriod, highPeriod, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            throw new IllegalArgumentException();
        }
        return new Task<Object>(Executors.callable(command), initialDelay, -delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AbstractCollection abstractCollection = this.mPool;
        synchronized (abstractCollection) {
            if (!this.mShutdown) {
                this.mShutdown = true;
                Shutdown shutdown = new Shutdown();
                for (PooledThread thread : this.mPool) {
                    thread.setCommand(shutdown);
                }
            }
            this.mPool.notifyAll();
        }
        abstractCollection = this.mScheduledTasks;
        synchronized (abstractCollection) {
            this.mScheduledTasks.clear();
            this.mScheduledTasks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        HashSet<PooledThread> hashSet = this.mAllThreads;
        synchronized (hashSet) {
            for (Thread thread : this.mAllThreads) {
                thread.interrupt();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdown() {
        LinkedList<PooledThread> linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mShutdown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminated() {
        LinkedList<PooledThread> linkedList = this.mPool;
        synchronized (linkedList) {
            return this.mShutdown && this.mActive <= 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        if (time < 0L) {
            return false;
        }
        LinkedList<PooledThread> linkedList = this.mPool;
        synchronized (linkedList) {
            if (this.isTerminated()) {
                return true;
            }
            if (time == 0L) {
                return false;
            }
            long start = System.nanoTime();
            long nanos = unit.toNanos(time);
            do {
                this.mPool.wait(ThreadPool.roundNanosToMillis(nanos));
                long now = System.nanoTime();
                if ((nanos -= now - start) <= 0L) {
                    return this.isTerminated();
                }
                start = now;
            } while (!this.isTerminated());
        }
        return true;
    }

    private static long roundNanosToMillis(long nanos) {
        if (nanos <= 9223372036853775808L) {
            nanos += 999999L;
        }
        return nanos / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadAvailable(PooledThread thread) {
        LinkedList<PooledThread> linkedList = this.mPool;
        synchronized (linkedList) {
            this.mPool.addLast(thread);
            this.mPool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void threadExiting(PooledThread thread) {
        AbstractCollection abstractCollection = this.mPool;
        synchronized (abstractCollection) {
            this.mPool.remove(thread);
            --this.mActive;
            this.mPool.notify();
        }
        abstractCollection = this.mAllThreads;
        synchronized (abstractCollection) {
            this.mAllThreads.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(Task<?> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(SHUTDOWN_MESSAGE);
        }
        TreeSet<Task> treeSet = this.mScheduledTasks;
        synchronized (treeSet) {
            if (!this.mScheduledTasks.add(task)) {
                throw new InternalError();
            }
            if (this.mScheduledTasks.first() == task) {
                if (this.mTaskRunnerReady) {
                    this.mScheduledTasks.notify();
                } else {
                    TaskRunner runner = new TaskRunner();
                    try {
                        this.execute(runner, true);
                        this.mTaskRunnerReady = true;
                    }
                    catch (RejectedExecutionException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TaskRunner needsTaskRunner() {
        TreeSet<Task> treeSet = this.mScheduledTasks;
        synchronized (treeSet) {
            if (!this.mTaskRunnerReady && !this.mScheduledTasks.isEmpty()) {
                TaskRunner runner = new TaskRunner();
                this.mTaskRunnerReady = true;
                return runner;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(Task<?> task) {
        TreeSet<Task> treeSet = this.mScheduledTasks;
        synchronized (treeSet) {
            this.mScheduledTasks.remove(task);
            if (this.mScheduledTasks.isEmpty()) {
                this.mScheduledTasks.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void runNextScheduledTask() {
        TreeSet<Task> treeSet = this.mScheduledTasks;
        synchronized (treeSet) {
            while (true) {
                if (this.mScheduledTasks.isEmpty()) {
                    this.mTaskRunnerReady = false;
                    return;
                }
                Task task = this.mScheduledTasks.first();
                long delay = task.getAtNanos() - System.nanoTime();
                if (delay <= 0L) {
                    boolean replaced;
                    this.mScheduledTasks.remove(task);
                    try {
                        this.execute(new TaskRunner(), true);
                        replaced = true;
                    }
                    catch (RejectedExecutionException e) {
                        this.mTaskRunnerReady = false;
                        replaced = false;
                    }
                    try {
                        task.run();
                        if (!replaced) return;
                        while (true) {
                            treeSet = this.mScheduledTasks;
                            synchronized (treeSet) {
                                if (this.mScheduledTasks.isEmpty()) {
                                    return;
                                }
                                task = this.mScheduledTasks.first();
                                if (task.getAtNanos() - System.nanoTime() > 0L) {
                                    return;
                                }
                                this.mScheduledTasks.remove(task);
                            }
                            Thread.interrupted();
                            task.run();
                        }
                    }
                    catch (Throwable e) {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                        return;
                    }
                }
                try {
                    this.mScheduledTasks.wait(ThreadPool.roundNanosToMillis(delay));
                }
                catch (InterruptedException e2) {
                    Thread.interrupted();
                    Object e2 = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledThread startNewPooledThread(Runnable command) {
        PooledThread thread = new PooledThread(this.mGroup, this.mNamePrefix + this.mThreadNumber.getAndIncrement(), this.mContext, command);
        if (thread.isDaemon() != this.mDaemon) {
            thread.setDaemon(this.mDaemon);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        if (this.mHandler != null) {
            thread.setUncaughtExceptionHandler(this.mHandler);
        }
        HashSet<PooledThread> hashSet = this.mAllThreads;
        synchronized (hashSet) {
            this.mAllThreads.add(thread);
        }
        try {
            thread.start();
        }
        catch (Error e) {
            HashSet<PooledThread> hashSet2 = this.mAllThreads;
            synchronized (hashSet2) {
                this.mAllThreads.remove(thread);
            }
            throw e;
        }
        return thread;
    }

    static int randomInt(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        return n;
    }

    static {
        String prefix = ThreadPool.class.getName() + ".limitReached";
        LIMIT_REACHED_THREAD_DUMP = System.getProperty(prefix + "ThreadDump", "").equals("true");
        LIMIT_REACHED_SYSTEM_EXIT = System.getProperty(prefix + "SystemExit", "").equals("true");
        cPoolNumber = new AtomicLong(1L);
        cTaskNumber = new AtomicLong(1L);
    }

    private static class Shutdown
    implements Runnable {
        private Shutdown() {
        }

        @Override
        public void run() {
            throw new ThreadDeath();
        }
    }

    private class TaskRunner
    implements Runnable {
        private TaskRunner() {
        }

        @Override
        public void run() {
            ThreadPool.this.runNextScheduledTask();
        }
    }

    private class JitterTask<V>
    extends Task<V> {
        private final long mRangeNanos;
        private int mRandom;

        JitterTask(Callable<V> callable, long initialDelay, long lowPeriod, long highPeriod, TimeUnit unit) {
            super(callable, initialDelay, lowPeriod, unit);
            this.mRangeNanos = unit.toNanos(highPeriod - lowPeriod);
            while ((this.mRandom = Random.randomInt()) == 0) {
            }
            super.start();
        }

        @Override
        void start() {
        }

        @Override
        public void run() {
            ThreadPool.this.removeTask(this);
            if (super.runAndReset()) {
                this.mAtNanos += this.mPeriodNanos + this.randomLong(this.mRangeNanos);
                try {
                    ThreadPool.this.scheduleTask(this);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String toString() {
            return "ScheduledFuture {delayNanos=" + String.valueOf(this.getDelay(TimeUnit.NANOSECONDS)) + ", lowPeriodNanos=" + String.valueOf(this.mPeriodNanos) + ", highPeriodNanos=" + String.valueOf(this.mPeriodNanos + this.mRangeNanos) + '}';
        }

        private long randomLong(long n) {
            long val;
            int n1;
            long bits;
            int n2 = this.mRandom;
            while ((bits = ((long)(n1 = ThreadPool.randomInt(n2)) << 32) + (long)(n2 = ThreadPool.randomInt(n1)) >>> 1) - (val = bits % n) + n - 1L < 0L) {
            }
            this.mRandom = n2;
            return val;
        }
    }

    private class Task<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final long mNum;
        final long mPeriodNanos;
        volatile long mAtNanos;

        Task(Callable<V> callable, long initialDelay, long period, TimeUnit unit) {
            long periodNanos;
            super(callable);
            if (period == 0L) {
                periodNanos = 0L;
            } else {
                periodNanos = unit.toNanos(period);
                if (periodNanos == 0L) {
                    periodNanos = period < 0L ? -1L : 1L;
                }
            }
            this.mPeriodNanos = periodNanos;
            this.mNum = cTaskNumber.getAndIncrement();
            long atNanos = System.nanoTime();
            if (initialDelay > 0L) {
                atNanos += unit.toNanos(initialDelay);
            }
            this.mAtNanos = atNanos;
            this.start();
        }

        void start() {
            ThreadPool.this.scheduleTask(this);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.mAtNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (this == delayed) {
                return 0;
            }
            if (delayed instanceof Task) {
                Task other = (Task)delayed;
                long diff = this.mAtNanos - other.mAtNanos;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.mNum < other.mNum) {
                    return -1;
                }
                return 1;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - delayed.getDelay(TimeUnit.NANOSECONDS);
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }

        @Override
        public void run() {
            ThreadPool.this.removeTask(this);
            long periodNanos = this.mPeriodNanos;
            if (periodNanos == 0L) {
                super.run();
            } else if (super.runAndReset()) {
                this.mAtNanos = periodNanos > 0L ? (this.mAtNanos += periodNanos) : System.nanoTime() - periodNanos;
                try {
                    ThreadPool.this.scheduleTask(this);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            ThreadPool.this.removeTask(this);
            return super.cancel(mayInterruptIfRunning);
        }

        long getAtNanos() {
            return this.mAtNanos;
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder().append("ScheduledFuture {delayNanos=").append(String.valueOf(this.getDelay(TimeUnit.NANOSECONDS)));
            if (this.mPeriodNanos != 0L) {
                b.append(", periodNanos=").append(String.valueOf(this.mPeriodNanos));
            }
            return b.append('}').toString();
        }
    }

    private class PooledThread
    extends Thread {
        private final AccessControlContext mContext;
        private Runnable mCommand;
        private boolean mExiting;

        public PooledThread(ThreadGroup group, String name, AccessControlContext context, Runnable command) {
            super(group, null, name);
            this.mContext = context;
            this.mCommand = command;
        }

        synchronized boolean setCommand(Runnable command) {
            if (this.mCommand != null) {
                throw new IllegalStateException("Command in pooled thread is already set");
            }
            if (this.mExiting) {
                return false;
            }
            this.mCommand = command;
            this.notify();
            return true;
        }

        private synchronized Runnable waitForCommand() throws InterruptedException {
            Runnable command = this.mCommand;
            if (command == null) {
                long idle = 10000L;
                if (idle != 0L) {
                    if (idle < 0L) {
                        this.wait(0L);
                    } else {
                        this.wait(idle);
                    }
                }
                if ((command = this.mCommand) == null) {
                    this.mExiting = true;
                }
            }
            this.mCommand = null;
            return command;
        }

        @Override
        public void run() {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    PooledThread.this.run0();
                    return null;
                }
            }, this.mContext);
        }

        void run0() {
            try {
                while (!ThreadPool.this.isShutdown()) {
                    Runnable command;
                    block10: {
                        if (Thread.interrupted()) continue;
                        try {
                            command = this.waitForCommand();
                            if (command != null) break block10;
                            break;
                        }
                        catch (InterruptedException e2) {
                            Object e2 = null;
                            continue;
                        }
                    }
                    do {
                        try {
                            command.run();
                        }
                        catch (Throwable e) {
                            if (!(command instanceof Shutdown)) {
                                this.getUncaughtExceptionHandler().uncaughtException(this, e);
                            }
                            Object var2_2 = null;
                        }
                    } while ((command = ThreadPool.this.needsTaskRunner()) != null);
                    ThreadPool.this.threadAvailable(this);
                }
            }
            finally {
                ThreadPool.this.threadExiting(this);
            }
        }
    }
}

