/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.util;

import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.cojen.util.ThrowUnchecked;

public class ThrottledExecutor
implements Executor {
    private final int mPermits;
    private final int mMaxQueued;
    private final LinkedList<Runnable> mQueue;
    private int mActive;

    public ThrottledExecutor(int permits, int maxQueued) {
        if (permits < 1) {
            throw new IllegalArgumentException("Permits must be at least one: " + permits);
        }
        if (maxQueued < 0) {
            throw new IllegalArgumentException("Maximum queued cannot be negative: " + maxQueued);
        }
        this.mPermits = permits;
        this.mMaxQueued = maxQueued;
        this.mQueue = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) throws RejectedExecutionException {
        if (command == null) {
            throw new NullPointerException("Command is null");
        }
        LinkedList<Runnable> queue = this.mQueue;
        ThrottledExecutor throttledExecutor = this;
        synchronized (throttledExecutor) {
            int active = this.mActive;
            if (active >= this.mPermits) {
                if (queue.size() >= this.mMaxQueued) {
                    throw new RejectedExecutionException("Too many queued commands");
                }
                queue.add(command);
                return;
            }
            if (!queue.isEmpty()) {
                queue.add(command);
                command = null;
            }
            this.mActive = ++active;
        }
        while (true) {
            if (command != null) {
                try {
                    command.run();
                }
                catch (Throwable e) {
                    try {
                        Thread t = Thread.currentThread();
                        t.getUncaughtExceptionHandler().uncaughtException(t, e);
                    }
                    catch (Throwable e2) {
                        ThrottledExecutor throttledExecutor2 = this;
                        synchronized (throttledExecutor2) {
                            if (queue.isEmpty() || this.mActive > 1) {
                                --this.mActive;
                                ThrowUnchecked.fire((Throwable)e2);
                                return;
                            }
                        }
                    }
                }
            }
            throttledExecutor = this;
            synchronized (throttledExecutor) {
                command = queue.poll();
                if (command == null) {
                    --this.mActive;
                    return;
                }
            }
        }
    }
}

