/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.util;

import java.util.concurrent.TimeUnit;

public class Timer {
    private final long mDuration;
    private final TimeUnit mUnit;
    private final long mStartNanos;

    public static Timer nanos(long duration) {
        return new Timer(duration, TimeUnit.NANOSECONDS);
    }

    public static Timer micros(long duration) {
        return new Timer(duration, TimeUnit.MICROSECONDS);
    }

    public static Timer millis(long duration) {
        return new Timer(duration, TimeUnit.MILLISECONDS);
    }

    public static Timer seconds(long duration) {
        return new Timer(duration, TimeUnit.SECONDS);
    }

    public static Timer minutes(long duration) {
        return new Timer(duration, TimeUnit.MINUTES);
    }

    public static Timer hours(long duration) {
        return new Timer(duration, TimeUnit.HOURS);
    }

    public static Timer days(long duration) {
        return new Timer(duration, TimeUnit.DAYS);
    }

    public Timer(long duration, TimeUnit unit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Negative timer duration: " + duration);
        }
        if (unit == null) {
            throw new IllegalArgumentException("Null timer unit");
        }
        this.mDuration = duration;
        this.mUnit = unit;
        this.mStartNanos = System.nanoTime();
    }

    public long duration() {
        return this.mDuration;
    }

    public TimeUnit unit() {
        return this.mUnit;
    }

    public long remaining() {
        return this.mDuration - this.mUnit.convert(System.nanoTime() - this.mStartNanos, TimeUnit.NANOSECONDS);
    }

    public String toString() {
        return "Timer {duration=" + this.mDuration + ", unit=" + (Object)((Object)this.mUnit) + ", remaining=" + this.remaining() + '}';
    }
}

