/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.dirmi.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.CodeBuilder;
import org.cojen.classfile.Modifiers;
import org.cojen.classfile.RuntimeClassFile;
import org.cojen.classfile.TypeDesc;
import org.cojen.dirmi.util.Cache;
import org.cojen.util.KeyFactory;
import org.cojen.util.ThrowUnchecked;

public class Wrapper<B, D> {
    private static final Cache<Object, Wrapper<?, ?>> cCache = Cache.newSoftValueCache(17);
    private final Class<? extends B> mAdapterClass;
    private final Constructor<B> mConstructor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B, D> Wrapper<B, D> from(Class<B> baseType, Class<D> delegateType) {
        Object key = KeyFactory.createKey((Object[])new Object[]{baseType, delegateType});
        Cache<Object, Wrapper<?, ?>> cache = cCache;
        synchronized (cache) {
            Wrapper<Object, Object> wrapper = cCache.get(key);
            if (wrapper == null) {
                Class<B> adapterClass = Wrapper.generateAdapterClass(baseType, delegateType);
                Constructor<?> ctor = null;
                for (Constructor<?> c : adapterClass.getConstructors()) {
                    if (c.getParameterTypes().length != 1) continue;
                    ctor = c;
                    break;
                }
                wrapper = new Wrapper<B, D>(adapterClass, ctor);
                cCache.put(key, wrapper);
            }
            return wrapper;
        }
    }

    protected Wrapper(Class<? extends B> adapterClass, Constructor<B> ctor) {
        this.mAdapterClass = adapterClass;
        this.mConstructor = ctor;
    }

    public B wrap(D delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate is null");
        }
        Constructor<B> ctor = this.mConstructor;
        if (ctor == null) {
            throw new IllegalArgumentException("Arguments are required");
        }
        try {
            return ctor.newInstance(delegate);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            ThrowUnchecked.fireDeclaredCause((Throwable)e, (Class[])new Class[0]);
            throw null;
        }
    }

    public Constructor<? extends B> getConstructor(Class<?> ... arguments) throws NoSuchMethodException {
        return this.mAdapterClass.getConstructor(arguments);
    }

    /*
     * WARNING - void declaration
     */
    private static <B, D> Class<? extends B> generateAdapterClass(Class<B> baseType, Class<?> delegateType) {
        List<Object> superConstructors;
        if (baseType == null || delegateType == null) {
            throw new IllegalArgumentException();
        }
        if (!baseType.isInterface() && !Modifier.isAbstract(baseType.getModifiers())) {
            throw new IllegalArgumentException("Must be an interface or abstract class: " + baseType);
        }
        Wrapper.checkClassAccess(baseType);
        Wrapper.checkClassAccess(delegateType);
        if (baseType.isInterface()) {
            superConstructors = Collections.emptyList();
        } else {
            superConstructors = Wrapper.gatherConstructors(baseType, delegateType);
            if (superConstructors.isEmpty()) {
                throw new IllegalArgumentException("No applicable constructor found in base type: " + baseType);
            }
        }
        HashMap<Object, Method> abstractMethodMap = new HashMap<Object, Method>();
        Wrapper.gatherAbstractMethods(baseType, new HashSet<Class>(), new HashMap<Object, Method>(), abstractMethodMap);
        Collection abstractMethods = abstractMethodMap.values();
        String baseName = baseType.getName();
        if (baseName.startsWith("java.")) {
            baseName = baseName.replace('.', '$');
        }
        String superName = baseType.isInterface() ? null : baseType.getName();
        RuntimeClassFile cf = new RuntimeClassFile(baseName, superName, baseType.getClassLoader());
        cf.setSourceFile(Wrapper.class.getName());
        cf.markSynthetic();
        cf.setTarget("1.5");
        if (baseType.isInterface()) {
            cf.addInterface(baseType);
        }
        TypeDesc delegateDesc = TypeDesc.forClass(delegateType);
        cf.addField(Modifiers.PRIVATE.toFinal(true), "delegate", delegateDesc);
        if (superConstructors.isEmpty()) {
            Wrapper.addPlainConstructor(cf, delegateDesc);
        } else {
            boolean plainAdded = false;
            for (Constructor constructor : superConstructors) {
                void var13_22;
                Class<?>[] paramTypes;
                block19: {
                    paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length == 0) {
                        if (plainAdded) continue;
                        plainAdded = true;
                        for (Constructor constructor2 : superConstructors) {
                            if (constructor2.getParameterTypes().length != 1) continue;
                            break block19;
                        }
                        Wrapper.addPlainConstructor(cf, delegateDesc);
                        continue;
                    }
                }
                TypeDesc[] paramDescs = new TypeDesc[paramTypes.length];
                boolean bl = true;
                while (var13_22 < paramTypes.length) {
                    paramDescs[var13_22] = TypeDesc.forClass(paramTypes[var13_22]);
                    ++var13_22;
                }
                paramDescs[0] = delegateDesc;
                CodeBuilder codeBuilder = new CodeBuilder(cf.addConstructor(Modifiers.PUBLIC, paramDescs));
                codeBuilder.loadThis();
                for (int i = 0; i < paramTypes.length; ++i) {
                    codeBuilder.loadLocal(codeBuilder.getParameter(i));
                }
                paramDescs[0] = TypeDesc.forClass(paramTypes[0]);
                codeBuilder.invokeSuperConstructor(paramDescs);
                codeBuilder.loadThis();
                codeBuilder.loadLocal(codeBuilder.getParameter(0));
                codeBuilder.storeField("delegate", delegateDesc);
                codeBuilder.returnVoid();
            }
        }
        for (Method abstractMethod : abstractMethods) {
            void var13_25;
            Method method;
            try {
                method = delegateType.getMethod(abstractMethod.getName(), abstractMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Delegate does not contain matching method: " + abstractMethod);
            }
            if (!abstractMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                throw new IllegalArgumentException("Delegate method return type is not applicable: " + method + ", expected: " + abstractMethod);
            }
            Wrapper.checkCheckedExceptions(abstractMethod, method);
            CodeBuilder b = new CodeBuilder(cf.addMethod(abstractMethod));
            b.loadThis();
            b.loadField("delegate", delegateDesc);
            int count = b.getParameterCount();
            boolean bl = false;
            while (var13_25 < count) {
                b.loadLocal(b.getParameter((int)var13_25));
                ++var13_25;
            }
            b.invoke(method);
            b.returnValue(TypeDesc.forClass(abstractMethod.getReturnType()));
        }
        return cf.defineClass();
    }

    private static void addPlainConstructor(RuntimeClassFile cf, TypeDesc delegateDesc) {
        CodeBuilder b = new CodeBuilder(cf.addConstructor(Modifiers.PUBLIC, new TypeDesc[]{delegateDesc}));
        b.loadThis();
        b.invokeSuperConstructor(null);
        b.loadThis();
        b.loadLocal(b.getParameter(0));
        b.storeField("delegate", delegateDesc);
        b.returnVoid();
    }

    private static List<Constructor> gatherConstructors(Class<?> baseType, Class<?> delegateType) {
        ArrayList<Constructor> ctors = new ArrayList<Constructor>();
        block0: for (Constructor<?> ctor : baseType.getDeclaredConstructors()) {
            int modifiers = ctor.getModifiers();
            if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) continue;
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes != null && paramTypes.length > 0) {
                if (!paramTypes[0].isAssignableFrom(delegateType)) continue;
                for (Class<?> type : paramTypes) {
                    if (!Modifier.isPublic(type.getModifiers())) continue block0;
                }
            }
            ctors.add(ctor);
        }
        return ctors;
    }

    private static void gatherAbstractMethods(Class<?> clazz, Set<Class> seen, Map<Object, Method> allMethods, Map<Object, Method> abstractMethods) {
        if (clazz == null || !seen.add(clazz)) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Object key = KeyFactory.createKey((Object[])new Object[]{method.getName(), method.getReturnType(), method.getParameterTypes()});
            if (allMethods.containsKey(key)) continue;
            allMethods.put(key, method);
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            Wrapper.checkMemberAccess(method);
            Wrapper.checkParameterAccess(method, method.getParameterTypes());
            if (abstractMethods.containsKey(key)) continue;
            abstractMethods.put(key, method);
        }
        Wrapper.gatherAbstractMethods(clazz.getSuperclass(), seen, allMethods, abstractMethods);
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            Wrapper.gatherAbstractMethods(genericDeclaration, seen, allMethods, abstractMethods);
        }
    }

    private static void checkClassAccess(Class<?> clazz) {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            throw new IllegalArgumentException("Must be public: " + clazz);
        }
    }

    private static void checkMemberAccess(Member member) {
        int modifiers = member.getModifiers();
        if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
            throw new IllegalArgumentException("Must be public or protected: " + member);
        }
    }

    private static void checkParameterAccess(Member member, Class[] paramTypes) {
        if (paramTypes != null) {
            for (Class type : paramTypes) {
                if (Modifier.isPublic(type.getModifiers())) continue;
                throw new IllegalArgumentException("Not all parameter types are public: " + member + ", " + type.getName());
            }
        }
    }

    private static void checkCheckedExceptions(Method abstractMethod, Method delegateMethod) {
        Class<?>[] delegateExceptions = delegateMethod.getExceptionTypes();
        if (delegateExceptions.length == 0) {
            return;
        }
        Class<?>[] abstractExceptions = abstractMethod.getExceptionTypes();
        block0: for (Class<?> declared : delegateExceptions) {
            if (RuntimeException.class.isAssignableFrom(declared) || Error.class.isAssignableFrom(declared)) continue;
            for (Class<?> allowed : abstractExceptions) {
                if (allowed.isAssignableFrom(declared)) continue block0;
            }
            throw new IllegalArgumentException("Delegate method declares throwing a checked exception not declared by base type method: " + abstractMethod + " does not support all exceptions " + "declared by " + delegateMethod);
        }
    }
}

