/*
 *  Copyright (C) 2022 Cojen.org
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as
 *  published by the Free Software Foundation, either version 3 of the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.cojen.tupl.rows;

import java.io.IOException;

import org.cojen.tupl.Scanner;

/**
 * Can be passed to a Scanner as if it was a row, in order to obtain undecoded row entries.
 *
 * @author Brian S O'Neill
 */
public interface RowConsumer<R> {
    void beginBatch(Scanner scanner, RowEvaluator<R> evaluator) throws IOException;

    void accept(byte[] key, byte[] value) throws IOException;
}
