/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.views.SelectCombiner;

@FunctionalInterface
public interface Combiner {
    public static Combiner first() {
        return SelectCombiner.First.THE;
    }

    public static Combiner second() {
        return SelectCombiner.Second.THE;
    }

    public static Combiner discard() {
        return SelectCombiner.Discard.THE;
    }

    public byte[] combine(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    default public boolean requireValues() {
        return true;
    }

    default public boolean combineLocks() {
        return false;
    }

    default public byte[] loadUnion(Transaction txn, byte[] key, View first, View second) throws IOException {
        byte[] v1 = first.load(txn, key);
        byte[] v2 = second.load(txn, key);
        return v1 == null ? v2 : (v2 == null ? v1 : this.combine(key, v1, v2));
    }

    default public byte[] loadIntersection(Transaction txn, byte[] key, View first, View second) throws IOException {
        byte[] v1 = first.load(txn, key);
        if (v1 == null) {
            second.touch(txn, key);
            return null;
        }
        byte[] v2 = second.load(txn, key);
        return v2 == null ? null : this.combine(key, v1, v2);
    }

    default public byte[] loadDifference(Transaction txn, byte[] key, View first, View second) throws IOException {
        byte[] v1 = first.load(txn, key);
        if (v1 == null) {
            second.touch(txn, key);
            return null;
        }
        byte[] v2 = second.load(txn, key);
        return v2 == null ? v1 : this.combine(key, v1, v2);
    }

    default public byte[][] separate(byte[] key, byte[] value) throws IOException {
        return null;
    }
}

