/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.ValueAccessor;
import org.cojen.tupl.views.ViewUtils;

public interface Cursor
extends ValueAccessor,
Closeable {
    public static final byte[] NOT_LOADED = new byte[0];

    public Ordering ordering();

    default public Comparator<byte[]> comparator() {
        return null;
    }

    public Transaction link(Transaction var1);

    public Transaction link();

    public byte[] key();

    public byte[] value();

    public boolean autoload(boolean var1);

    public boolean autoload();

    default public int compareKeyTo(byte[] rkey) {
        byte[] lkey = this.key();
        return Arrays.compareUnsigned(lkey, rkey);
    }

    default public int compareKeyTo(byte[] rkey, int offset, int length) {
        byte[] lkey = this.key();
        return Arrays.compareUnsigned(lkey, 0, lkey.length, rkey, offset, offset + length);
    }

    default public boolean register() throws IOException {
        return false;
    }

    default public void unregister() {
    }

    public LockResult first() throws IOException;

    public LockResult last() throws IOException;

    public LockResult skip(long var1) throws IOException;

    default public LockResult skip(long amount, byte[] limitKey, boolean inclusive) throws IOException {
        return ViewUtils.skip(this, amount, limitKey, inclusive);
    }

    public LockResult next() throws IOException;

    default public LockResult nextLe(byte[] limitKey) throws IOException {
        return ViewUtils.nextCmp(this, limitKey, 1);
    }

    default public LockResult nextLt(byte[] limitKey) throws IOException {
        return ViewUtils.nextCmp(this, limitKey, 0);
    }

    public LockResult previous() throws IOException;

    default public LockResult previousGe(byte[] limitKey) throws IOException {
        return ViewUtils.previousCmp(this, limitKey, -1);
    }

    default public LockResult previousGt(byte[] limitKey) throws IOException {
        return ViewUtils.previousCmp(this, limitKey, 0);
    }

    public LockResult find(byte[] var1) throws IOException;

    default public LockResult findGe(byte[] key) throws IOException {
        LockResult result = this.find(key);
        if (this.value() == null) {
            if (result == LockResult.ACQUIRED) {
                this.link().unlock();
            }
            result = this.next();
        }
        return result;
    }

    default public LockResult findGt(byte[] key) throws IOException {
        ViewUtils.findNoLock(this, key);
        return this.next();
    }

    default public LockResult findLe(byte[] key) throws IOException {
        LockResult result = this.find(key);
        if (this.value() == null) {
            if (result == LockResult.ACQUIRED) {
                this.link().unlock();
            }
            result = this.previous();
        }
        return result;
    }

    default public LockResult findLt(byte[] key) throws IOException {
        ViewUtils.findNoLock(this, key);
        return this.previous();
    }

    default public LockResult findNearby(byte[] key) throws IOException {
        return this.find(key);
    }

    default public LockResult findNearbyGe(byte[] key) throws IOException {
        LockResult result = this.findNearby(key);
        if (this.value() == null) {
            if (result == LockResult.ACQUIRED) {
                this.link().unlock();
            }
            result = this.next();
        }
        return result;
    }

    default public LockResult findNearbyGt(byte[] key) throws IOException {
        ViewUtils.findNearbyNoLock(this, key);
        return this.next();
    }

    default public LockResult findNearbyLe(byte[] key) throws IOException {
        LockResult result = this.findNearby(key);
        if (this.value() == null) {
            if (result == LockResult.ACQUIRED) {
                this.link().unlock();
            }
            result = this.previous();
        }
        return result;
    }

    default public LockResult findNearbyLt(byte[] key) throws IOException {
        ViewUtils.findNearbyNoLock(this, key);
        return this.previous();
    }

    default public LockResult random(byte[] lowKey, byte[] highKey) throws IOException {
        return this.random(lowKey, true, highKey, false);
    }

    public LockResult random(byte[] var1, boolean var2, byte[] var3, boolean var4) throws IOException;

    public boolean exists() throws IOException;

    default public LockResult lock() throws IOException {
        return this.load();
    }

    public LockResult load() throws IOException;

    public void store(byte[] var1) throws IOException;

    default public void delete() throws IOException {
        this.store(null);
    }

    default public void commit(byte[] value) throws IOException {
        ViewUtils.commit(this, value);
    }

    public Cursor copy();

    public void reset();

    @Override
    default public void close() throws IOException {
        this.reset();
    }
}

