/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLContext;
import org.cojen.tupl.DatabaseConfig;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Index;
import org.cojen.tupl.Server;
import org.cojen.tupl.Snapshot;
import org.cojen.tupl.Sorter;
import org.cojen.tupl.Table;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.View;
import org.cojen.tupl.core.Utils;
import org.cojen.tupl.diag.CompactionObserver;
import org.cojen.tupl.diag.DatabaseStats;
import org.cojen.tupl.diag.VerificationObserver;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.io.CauseCloseable;
import org.cojen.tupl.remote.ClientDatabase;

public interface Database
extends CauseCloseable,
Flushable {
    public static Database open(DatabaseConfig config) throws IOException {
        return config.mLauncher.open(false, null);
    }

    public static Database destroy(DatabaseConfig config) throws IOException {
        return config.mLauncher.open(true, null);
    }

    public static Database connect(SocketAddress addr, SSLContext context, long ... tokens) throws IOException {
        return ClientDatabase.connect(addr, context, tokens);
    }

    public Index openIndex(byte[] var1) throws IOException;

    default public Index openIndex(String name) throws IOException {
        return this.openIndex(name.getBytes(StandardCharsets.UTF_8));
    }

    public Index findIndex(byte[] var1) throws IOException;

    default public Index findIndex(String name) throws IOException {
        return this.findIndex(name.getBytes(StandardCharsets.UTF_8));
    }

    public Index indexById(long var1) throws IOException;

    default public Index indexById(byte[] id) throws IOException {
        if (id.length != 8) {
            throw new IllegalArgumentException("Expected an 8 byte identifier: " + id.length);
        }
        return this.indexById(Utils.decodeLongBE(id, 0));
    }

    default public <R> Table<R> openTable(Class<R> type) throws IOException {
        return this.openIndex(type.getName()).asTable(type);
    }

    default public <R> Table<R> findTable(Class<R> type) throws IOException {
        Index ix = this.findIndex(type.getName());
        return ix == null ? null : ix.asTable(type);
    }

    public void renameIndex(Index var1, byte[] var2) throws IOException;

    default public void renameIndex(Index index, String newName) throws IOException {
        this.renameIndex(index, newName.getBytes(StandardCharsets.UTF_8));
    }

    public Runnable deleteIndex(Index var1) throws IOException;

    public Index newTemporaryIndex() throws IOException;

    public View indexRegistryByName() throws IOException;

    public View indexRegistryById() throws IOException;

    default public Transaction newTransaction() {
        return this.newTransaction(null);
    }

    public Transaction newTransaction(DurabilityMode var1);

    public CustomHandler customWriter(String var1) throws IOException;

    public PrepareHandler prepareWriter(String var1) throws IOException;

    public Sorter newSorter();

    public long preallocate(long var1) throws IOException;

    default public void capacityLimit(long bytes) {
        throw new UnsupportedOperationException();
    }

    default public long capacityLimit() {
        return -1L;
    }

    default public void capacityLimitOverride(long bytes) {
        throw new UnsupportedOperationException();
    }

    public Snapshot beginSnapshot() throws IOException;

    public static Database restoreFromSnapshot(DatabaseConfig config, InputStream in) throws IOException {
        return config.mLauncher.open(false, in);
    }

    public void createCachePrimer(OutputStream var1) throws IOException;

    public void applyCachePrimer(InputStream var1) throws IOException;

    public Server newServer() throws IOException;

    public DatabaseStats stats();

    @Override
    public void flush() throws IOException;

    public void sync() throws IOException;

    public void checkpoint() throws IOException;

    public void suspendCheckpoints();

    public void resumeCheckpoints();

    public Lock commitLock();

    public boolean compactFile(CompactionObserver var1, double var2) throws IOException;

    public boolean verify(VerificationObserver var1) throws IOException;

    public boolean isLeader();

    public void uponLeader(Runnable var1, Runnable var2);

    public boolean failover() throws IOException;

    @Override
    default public void close() throws IOException {
        this.close(null);
    }

    @Override
    public void close(Throwable var1) throws IOException;

    public boolean isClosed();

    public void shutdown() throws IOException;
}

