/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.zip.Checksum;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.LockUpgradeRule;
import org.cojen.tupl.core.Launcher;
import org.cojen.tupl.diag.EventListener;
import org.cojen.tupl.ext.Crypto;
import org.cojen.tupl.ext.CustomHandler;
import org.cojen.tupl.ext.PrepareHandler;
import org.cojen.tupl.io.PageArray;
import org.cojen.tupl.io.PageCompressor;
import org.cojen.tupl.repl.ReplicatorConfig;
import org.cojen.tupl.repl.StreamReplicator;

public class DatabaseConfig
implements Cloneable {
    final Launcher mLauncher;

    public DatabaseConfig() {
        this.mLauncher = new Launcher();
    }

    private DatabaseConfig(Launcher launcher) {
        this.mLauncher = launcher;
    }

    public DatabaseConfig baseFile(File file) {
        this.mLauncher.baseFile(file == null ? null : file.getAbsoluteFile());
        return this;
    }

    public DatabaseConfig baseFilePath(String path) {
        return this.baseFile(path == null ? null : new File(path));
    }

    public DatabaseConfig createFilePath(boolean mkdirs) {
        this.mLauncher.createFilePath(mkdirs);
        return this;
    }

    public DatabaseConfig dataFile(File file) {
        return this.dataFiles(file);
    }

    public DatabaseConfig dataFiles(File ... files) {
        if (files != null && files.length != 0) {
            File[] dataFiles = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                dataFiles[i] = files[i].getAbsoluteFile();
            }
            files = dataFiles;
        }
        this.mLauncher.dataFiles(files);
        return this;
    }

    public DatabaseConfig mapDataFiles(boolean mapped) {
        this.mLauncher.mapDataFiles(mapped);
        return this;
    }

    public DatabaseConfig dataPageArray(PageArray array) {
        this.mLauncher.dataPageArray(array);
        return this;
    }

    public DatabaseConfig minCacheSize(long minBytes) {
        this.mLauncher.minCacheSize(minBytes);
        return this;
    }

    public DatabaseConfig maxCacheSize(long maxBytes) {
        this.mLauncher.maxCacheSize(maxBytes);
        return this;
    }

    public DatabaseConfig cacheSize(long size) {
        this.minCacheSize(size);
        this.maxCacheSize(size);
        return this;
    }

    public DatabaseConfig durabilityMode(DurabilityMode durabilityMode) {
        this.mLauncher.durabilityMode(durabilityMode);
        return this;
    }

    public DatabaseConfig lockUpgradeRule(LockUpgradeRule lockUpgradeRule) {
        this.mLauncher.lockUpgradeRule(lockUpgradeRule);
        return this;
    }

    public DatabaseConfig lockTimeout(long timeout, TimeUnit unit) {
        this.mLauncher.lockTimeout(timeout, unit);
        return this;
    }

    public DatabaseConfig checkpointRate(long rate, TimeUnit unit) {
        this.mLauncher.checkpointRate(rate, unit);
        return this;
    }

    public DatabaseConfig checkpointSizeThreshold(long bytes) {
        this.mLauncher.checkpointSizeThreshold(bytes);
        return this;
    }

    public DatabaseConfig checkpointDelayThreshold(long delay, TimeUnit unit) {
        this.mLauncher.checkpointDelayThreshold(delay, unit);
        return this;
    }

    public DatabaseConfig maxCheckpointThreads(int num) {
        this.mLauncher.maxCheckpointThreads(num);
        return this;
    }

    public DatabaseConfig eventListener(EventListener listener) {
        this.mLauncher.eventListener(listener);
        return this;
    }

    public DatabaseConfig eventListeners(EventListener ... listeners) {
        this.mLauncher.eventListeners(listeners);
        return this;
    }

    public DatabaseConfig syncWrites(boolean fileSync) {
        this.mLauncher.syncWrites(fileSync);
        return this;
    }

    public DatabaseConfig readOnly(boolean readOnly) {
        this.mLauncher.readOnly(readOnly);
        return this;
    }

    public DatabaseConfig pageSize(int size) {
        this.mLauncher.pageSize(size);
        return this;
    }

    public DatabaseConfig directPageAccess(boolean direct) {
        this.mLauncher.directPageAccess(direct);
        return this;
    }

    public DatabaseConfig cachePriming(boolean priming) {
        this.mLauncher.cachePriming(priming);
        return this;
    }

    public DatabaseConfig cleanShutdown(boolean shutdown) {
        this.mLauncher.cleanShutdown(shutdown);
        return this;
    }

    public DatabaseConfig replicate(ReplicatorConfig config) {
        this.mLauncher.replicate(config);
        return this;
    }

    public DatabaseConfig replicate(StreamReplicator repl) {
        this.mLauncher.replicate(repl);
        return this;
    }

    public DatabaseConfig maxReplicaThreads(int num) {
        this.mLauncher.maxReplicaThreads(num);
        return this;
    }

    public DatabaseConfig enableJMX(boolean enable) {
        this.mLauncher.enableJMX(enable);
        return this;
    }

    public DatabaseConfig encrypt(Crypto crypto) {
        this.mLauncher.encrypt(crypto);
        return this;
    }

    public DatabaseConfig checksumPages(Supplier<Checksum> factory) {
        this.mLauncher.checksumPages(factory);
        return this;
    }

    public DatabaseConfig compressPages(int fullPageSize, long cacheSize, Supplier<PageCompressor> factory) {
        this.mLauncher.compressPages(fullPageSize, cacheSize, factory);
        return this;
    }

    public DatabaseConfig customHandlers(Map<String, ? extends CustomHandler> handlers) {
        this.mLauncher.customHandlers(handlers);
        return this;
    }

    public DatabaseConfig prepareHandlers(Map<String, ? extends PrepareHandler> handlers) {
        this.mLauncher.prepareHandlers(handlers);
        return this;
    }

    public void debugOpen(PrintStream out, Map<String, ?> properties) throws IOException {
        this.mLauncher.debugOpen(out, properties);
    }

    public DatabaseConfig clone() {
        return new DatabaseConfig(this.mLauncher.clone());
    }
}

