/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.cojen.tupl.core.Utils;

public class DatabaseException
extends IOException {
    private static final long serialVersionUID = 1L;

    public DatabaseException() {
    }

    public DatabaseException(String message) {
        super(message);
    }

    public DatabaseException(Throwable cause) {
        super(cause);
    }

    public DatabaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public boolean isRecoverable() {
        return false;
    }

    long timeout() {
        return 0L;
    }

    TimeUnit unit() {
        return null;
    }

    Object ownerAttachment() {
        return null;
    }

    final String timeoutMessage(long nanosTimeout) {
        String msg;
        if (nanosTimeout == 0L) {
            msg = "Never waited";
        } else if (nanosTimeout < 0L) {
            msg = "Infinite wait";
        } else {
            StringBuilder b = new StringBuilder("Waited ");
            Utils.appendTimeout(b, this.timeout(), this.unit());
            Object att = this.ownerAttachment();
            if (att != null) {
                DatabaseException.appendAttachment(b, att);
            }
            return b.toString();
        }
        Object att = this.ownerAttachment();
        if (att != null) {
            StringBuilder b = new StringBuilder(msg);
            DatabaseException.appendAttachment(b, att);
            msg = b.toString();
        }
        return msg;
    }

    private static void appendAttachment(StringBuilder b, Object att) {
        b.append("; owner attachment: ").append(att);
    }
}

