/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.Collections;
import java.util.Set;
import org.cojen.tupl.LockTimeoutException;
import org.cojen.tupl.diag.DeadlockInfo;

public class DeadlockException
extends LockTimeoutException {
    private static final long serialVersionUID = 1L;
    private final boolean mGuilty;
    private final Set<DeadlockInfo> mSet;

    public DeadlockException(long nanosTimeout) {
        this(nanosTimeout, null, false, null);
    }

    public DeadlockException(long nanosTimeout, Object attachment, boolean guilty) {
        this(nanosTimeout, attachment, guilty, null);
    }

    public DeadlockException(long nanosTimeout, Object attachment, boolean guilty, Set<DeadlockInfo> set) {
        super(nanosTimeout, attachment);
        this.mGuilty = guilty;
        if (set == null) {
            set = Collections.emptySet();
        }
        this.mSet = set;
    }

    public boolean isGuilty() {
        return this.mGuilty;
    }

    public Set<DeadlockInfo> deadlockSet() {
        return this.mSet;
    }

    @Override
    public String getMessage() {
        return this.getMessage(true);
    }

    public String shortMessage() {
        return this.getMessage(false);
    }

    private String getMessage(boolean full) {
        StringBuilder b = new StringBuilder(super.getMessage());
        b.append("; caller ");
        if (this.mGuilty) {
            b.append("helped cause the deadlock");
        } else {
            b.append("might be innocent");
        }
        b.append('.');
        if (full && !this.mSet.isEmpty()) {
            b.append(" Deadlock set: ").append(this.mSet);
        }
        return b.toString();
    }
}

