/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.util.concurrent.TimeUnit;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.core.Utils;

public class LockTimeoutException
extends LockFailureException {
    private static final long serialVersionUID = 1L;
    private final long mNanosTimeout;
    private final Object mOwnerAttachment;
    private TimeUnit mUnit;

    public LockTimeoutException(long nanosTimeout) {
        this(nanosTimeout, null);
    }

    public LockTimeoutException(long nanosTimeout, Object attachment) {
        super((String)null);
        this.mNanosTimeout = nanosTimeout;
        this.mOwnerAttachment = attachment;
    }

    public long timeoutNanos() {
        return this.mNanosTimeout;
    }

    @Override
    public String getMessage() {
        return this.timeoutMessage(this.mNanosTimeout);
    }

    @Override
    public long timeout() {
        return this.unit().convert(this.mNanosTimeout, TimeUnit.NANOSECONDS);
    }

    @Override
    public Object ownerAttachment() {
        return this.mOwnerAttachment;
    }

    @Override
    public TimeUnit unit() {
        TimeUnit unit = this.mUnit;
        if (unit != null) {
            return unit;
        }
        this.mUnit = Utils.inferUnit(TimeUnit.NANOSECONDS, this.mNanosTimeout);
        return this.mUnit;
    }
}

