/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.cojen.tupl.io.Utils;

public interface Scanner<R>
extends Spliterator<R>,
Closeable {
    public R row();

    public R step() throws IOException;

    public R step(R var1) throws IOException;

    @Override
    default public boolean tryAdvance(Consumer<? super R> action) {
        try {
            R row = this.row();
            if (row == null) {
                return false;
            }
            this.step();
            action.accept(row);
            return true;
        }
        catch (Throwable e) {
            Utils.closeQuietly(this);
            throw Utils.rethrow(e);
        }
    }

    @Override
    default public void forEachRemaining(Consumer<? super R> action) {
        try {
            R row = this.row();
            while (row != null) {
                action.accept(row);
                row = this.step();
            }
        }
        catch (Throwable e) {
            Utils.closeQuietly(this);
            Utils.rethrow(e);
        }
    }

    @Override
    default public Spliterator<R> trySplit() {
        return null;
    }

    @Override
    public void close() throws IOException;
}

