/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Scanner;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Updater;
import org.cojen.tupl.diag.QueryPlan;
import org.cojen.tupl.io.Utils;

public interface Table<R>
extends Closeable {
    public Class<R> rowType();

    public R newRow();

    public R cloneRow(R var1);

    public void unsetRow(R var1);

    public void copyRow(R var1, R var2);

    public Scanner<R> newScanner(Transaction var1) throws IOException;

    public Scanner<R> newScanner(Transaction var1, String var2, Object ... var3) throws IOException;

    public Updater<R> newUpdater(Transaction var1) throws IOException;

    public Updater<R> newUpdater(Transaction var1, String var2, Object ... var3) throws IOException;

    default public Stream<R> newStream(Transaction txn) {
        try {
            return Table.newStream(this.newScanner(txn));
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    default public Stream<R> newStream(Transaction txn, String query, Object ... args) {
        try {
            return Table.newStream(this.newScanner(txn, query, args));
        }
        catch (IOException e) {
            throw Utils.rethrow(e);
        }
    }

    private static <R> Stream<R> newStream(Scanner<R> scanner) {
        return (Stream)StreamSupport.stream(scanner, false).onClose(() -> {
            try {
                scanner.close();
            }
            catch (Throwable e) {
                Utils.rethrow(e);
            }
        });
    }

    public Transaction newTransaction(DurabilityMode var1);

    public boolean isEmpty() throws IOException;

    public boolean load(Transaction var1, R var2) throws IOException;

    public boolean exists(Transaction var1, R var2) throws IOException;

    public void store(Transaction var1, R var2) throws IOException;

    public R exchange(Transaction var1, R var2) throws IOException;

    public boolean insert(Transaction var1, R var2) throws IOException;

    public boolean replace(Transaction var1, R var2) throws IOException;

    public boolean update(Transaction var1, R var2) throws IOException;

    public boolean merge(Transaction var1, R var2) throws IOException;

    public boolean delete(Transaction var1, R var2) throws IOException;

    public Comparator<R> comparator(String var1);

    public Predicate<R> predicate(String var1, Object ... var2);

    public QueryPlan scannerPlan(Transaction var1, String var2, Object ... var3) throws IOException;

    public QueryPlan updaterPlan(Transaction var1, String var2, Object ... var3) throws IOException;

    default public QueryPlan streamPlan(Transaction txn, String query, Object ... args) throws IOException {
        return this.scannerPlan(txn, query, args);
    }

    @Override
    public void close() throws IOException;

    public boolean isClosed();
}

