/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Comparator;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.core.Utils;

@FunctionalInterface
public interface Transformer {
    default public Boolean requireValue() {
        return Boolean.TRUE;
    }

    public byte[] transformValue(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    default public byte[] transformValue(Cursor cursor, byte[] tkey) throws IOException {
        byte[] value = cursor.value();
        if (value == Cursor.NOT_LOADED && this.requireValue() != Boolean.FALSE) {
            cursor.load();
            value = cursor.value();
        }
        return this.transformValue(value, cursor.key(), tkey);
    }

    default public byte[] inverseTransformValue(byte[] tvalue, byte[] key, byte[] tkey) throws ViewConstraintException, IOException {
        throw new ViewConstraintException("Inverse transform isn't supported");
    }

    default public byte[] transformKey(Cursor cursor) throws IOException {
        return cursor.key();
    }

    default public byte[] inverseTransformKey(byte[] tkey) {
        return tkey;
    }

    default public byte[] inverseTransformKeyGt(byte[] tkey) {
        return Utils.increment(tkey = (byte[])tkey.clone(), 0, tkey.length) ? this.inverseTransformKey(tkey) : null;
    }

    default public byte[] inverseTransformKeyLt(byte[] tkey) {
        return Utils.decrement(tkey = (byte[])tkey.clone(), 0, tkey.length) ? this.inverseTransformKey(tkey) : null;
    }

    default public Ordering transformedOrdering(Ordering original) {
        return original;
    }

    default public Comparator<byte[]> transformedComparator(Comparator<byte[]> original) {
        return original;
    }
}

