/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.tupl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import org.cojen.tupl.Combiner;
import org.cojen.tupl.Cursor;
import org.cojen.tupl.DeadlockException;
import org.cojen.tupl.DurabilityMode;
import org.cojen.tupl.Filter;
import org.cojen.tupl.LockFailureException;
import org.cojen.tupl.LockMode;
import org.cojen.tupl.LockResult;
import org.cojen.tupl.Ordering;
import org.cojen.tupl.Transaction;
import org.cojen.tupl.Transformer;
import org.cojen.tupl.ViewConstraintException;
import org.cojen.tupl.io.Utils;
import org.cojen.tupl.views.BoundedView;
import org.cojen.tupl.views.DifferenceView;
import org.cojen.tupl.views.IntersectionView;
import org.cojen.tupl.views.KeyOnlyView;
import org.cojen.tupl.views.ReverseView;
import org.cojen.tupl.views.TransformedView;
import org.cojen.tupl.views.UnionView;
import org.cojen.tupl.views.UnmodifiableView;
import org.cojen.tupl.views.ViewUtils;

public interface View {
    public Ordering ordering();

    default public Comparator<byte[]> comparator() {
        return null;
    }

    public Cursor newCursor(Transaction var1);

    default public Cursor newAccessor(Transaction txn, byte[] key) throws IOException {
        Cursor c = this.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            return c;
        }
        catch (Throwable e) {
            Utils.closeQuietly(c);
            throw e;
        }
    }

    default public Transaction newTransaction(DurabilityMode durabilityMode) {
        throw new UnsupportedOperationException();
    }

    default public boolean isEmpty() throws IOException {
        return ViewUtils.isEmpty(this);
    }

    default public long count(byte[] lowKey, byte[] highKey) throws IOException {
        return this.count(lowKey, true, highKey, false);
    }

    default public long count(byte[] lowKey, boolean lowInclusive, byte[] highKey, boolean highInclusive) throws IOException {
        return ViewUtils.count(this, false, lowKey, lowInclusive, highKey, highInclusive ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public byte[] load(Transaction txn, byte[] key) throws IOException {
        Cursor c = this.newCursor(txn);
        try {
            c.find(key);
            byte[] byArray = c.value();
            return byArray;
        }
        finally {
            c.reset();
        }
    }

    default public boolean exists(Transaction txn, byte[] key) throws IOException {
        return this.load(txn, key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void store(Transaction txn, byte[] key, byte[] value) throws IOException {
        txn = ViewUtils.enterScope(this, txn);
        Cursor c = this.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            if (c.key() == null) {
                if (value == null) {
                    return;
                }
                throw new ViewConstraintException();
            }
            c.commit(value);
        }
        finally {
            txn.exit();
            c.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public byte[] exchange(Transaction txn, byte[] key, byte[] value) throws IOException {
        txn = ViewUtils.enterScope(this, txn);
        Cursor c = this.newCursor(txn);
        try {
            c.find(key);
            if (c.key() == null) {
                if (value == null) {
                    byte[] byArray = null;
                    return byArray;
                }
                throw new ViewConstraintException();
            }
            byte[] old = c.value();
            c.commit(value);
            byte[] byArray = old;
            return byArray;
        }
        finally {
            txn.exit();
            c.reset();
        }
    }

    default public boolean insert(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.update(txn, key, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean replace(Transaction txn, byte[] key, byte[] value) throws IOException {
        txn = ViewUtils.enterScope(this, txn);
        Cursor c = this.newCursor(txn);
        try {
            c.autoload(false);
            c.find(key);
            if (c.key() == null) {
                throw new ViewConstraintException();
            }
            if (c.value() == null) {
                boolean bl = false;
                return bl;
            }
            c.commit(value);
            boolean bl = true;
            return bl;
        }
        finally {
            txn.exit();
            c.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean update(Transaction txn, byte[] key, byte[] value) throws IOException {
        txn = ViewUtils.enterScope(this, txn);
        Cursor c = this.newCursor(txn);
        try {
            c.find(key);
            if (c.key() == null) {
                throw new ViewConstraintException();
            }
            if (Arrays.equals(c.value(), value)) {
                boolean bl = false;
                return bl;
            }
            c.commit(value);
            boolean bl = true;
            return bl;
        }
        finally {
            txn.exit();
            c.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean update(Transaction txn, byte[] key, byte[] oldValue, byte[] newValue) throws IOException {
        txn = ViewUtils.enterScope(this, txn);
        Cursor c = this.newCursor(txn);
        try {
            c.autoload(oldValue != null);
            c.find(key);
            if (c.key() == null) {
                throw new ViewConstraintException();
            }
            if (!Arrays.equals(c.value(), oldValue)) {
                boolean bl = false;
                return bl;
            }
            if (oldValue != null || newValue != null) {
                c.commit(newValue);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            txn.exit();
            c.reset();
        }
    }

    default public boolean delete(Transaction txn, byte[] key) throws IOException {
        return this.replace(txn, key, null);
    }

    default public boolean remove(Transaction txn, byte[] key, byte[] value) throws IOException {
        return this.update(txn, key, value, null);
    }

    default public LockResult touch(Transaction txn, byte[] key) throws LockFailureException {
        try {
            if (txn == null) {
                this.exists(null, key);
            } else {
                LockMode mode = txn.lockMode();
                if (mode == LockMode.READ_COMMITTED) {
                    LockResult result = this.lockShared(txn, key);
                    if (result == LockResult.ACQUIRED) {
                        txn.unlock();
                    }
                } else if (!mode.noReadLock) {
                    if (mode == LockMode.UPGRADABLE_READ) {
                        return this.lockUpgradable(txn, key);
                    }
                    return this.lockShared(txn, key);
                }
            }
        }
        catch (LockFailureException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return LockResult.UNOWNED;
    }

    default public LockResult tryLockShared(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return ViewUtils.tryLock(txn, key, nanosTimeout, this::lockShared);
    }

    public LockResult lockShared(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    default public LockResult tryLockUpgradable(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return ViewUtils.tryLock(txn, key, nanosTimeout, this::lockUpgradable);
    }

    public LockResult lockUpgradable(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    default public LockResult tryLockExclusive(Transaction txn, byte[] key, long nanosTimeout) throws DeadlockException, LockFailureException, ViewConstraintException {
        return ViewUtils.tryLock(txn, key, nanosTimeout, this::lockExclusive);
    }

    public LockResult lockExclusive(Transaction var1, byte[] var2) throws LockFailureException, ViewConstraintException;

    public LockResult lockCheck(Transaction var1, byte[] var2) throws ViewConstraintException;

    default public View viewGe(byte[] key) {
        Ordering ordering = this.ordering();
        if (ordering == Ordering.ASCENDING) {
            return BoundedView.viewGe(this, key);
        }
        if (ordering == Ordering.DESCENDING) {
            return BoundedView.viewGe(this.viewReverse(), key).viewReverse();
        }
        throw new UnsupportedOperationException("Unsupported ordering: " + ordering);
    }

    default public View viewGt(byte[] key) {
        Ordering ordering = this.ordering();
        if (ordering == Ordering.ASCENDING) {
            return BoundedView.viewGt(this, key);
        }
        if (ordering == Ordering.DESCENDING) {
            return BoundedView.viewGt(this.viewReverse(), key).viewReverse();
        }
        throw new UnsupportedOperationException("Unsupported ordering: " + ordering);
    }

    default public View viewLe(byte[] key) {
        Ordering ordering = this.ordering();
        if (ordering == Ordering.ASCENDING) {
            return BoundedView.viewLe(this, key);
        }
        if (ordering == Ordering.DESCENDING) {
            return BoundedView.viewLe(this.viewReverse(), key).viewReverse();
        }
        throw new UnsupportedOperationException("Unsupported ordering: " + ordering);
    }

    default public View viewLt(byte[] key) {
        Ordering ordering = this.ordering();
        if (ordering == Ordering.ASCENDING) {
            return BoundedView.viewLt(this, key);
        }
        if (ordering == Ordering.DESCENDING) {
            return BoundedView.viewLt(this.viewReverse(), key).viewReverse();
        }
        throw new UnsupportedOperationException("Unsupported ordering: " + ordering);
    }

    default public View viewPrefix(byte[] prefix, int trim) {
        Ordering ordering = this.ordering();
        if (ordering == Ordering.ASCENDING) {
            return BoundedView.viewPrefix(this, prefix, trim);
        }
        if (ordering == Ordering.DESCENDING) {
            return BoundedView.viewPrefix(this.viewReverse(), prefix, trim).viewReverse();
        }
        throw new UnsupportedOperationException("Unsupported ordering: " + ordering);
    }

    default public View viewTransformed(Transformer transformer) {
        return TransformedView.apply(this, transformer);
    }

    default public View viewFiltered(Filter filter) {
        return this.viewTransformed(filter);
    }

    default public View viewUnion(Combiner combiner, View second) {
        if (combiner == null) {
            combiner = Combiner.first();
        }
        return new UnionView(combiner, this, second);
    }

    default public View viewIntersection(Combiner combiner, View second) {
        if (combiner == null) {
            combiner = Combiner.first();
        }
        return new IntersectionView(combiner, this, second);
    }

    default public View viewDifference(Combiner combiner, View second) {
        if (combiner == null) {
            combiner = Combiner.discard();
        }
        return new DifferenceView(combiner, this, second);
    }

    default public View viewKeys() {
        return new KeyOnlyView(this);
    }

    default public View viewReverse() {
        return new ReverseView(this);
    }

    default public View viewUnmodifiable() {
        return UnmodifiableView.apply(this);
    }

    public boolean isUnmodifiable();

    default public boolean isModifyAtomic() {
        return false;
    }
}

